/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.ScaleLayer;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ChartLinesLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final BooleanProperty majorLinesVisible = new SimpleBooleanProperty((Object)this, "majorLinesVisible", true);
    private final ObjectProperty<Paint> majorLinesStroke = new SimpleObjectProperty((Object)this, "majorLinesStroke");
    private final DoubleProperty majorLinesLineWidth = new SimpleDoubleProperty((Object)this, "majorLinesLineWidth");
    private final BooleanProperty minorLinesVisible = new SimpleBooleanProperty((Object)this, "minorLinesVisible", true);
    private final ObjectProperty<Paint> minorLinesStroke = new SimpleObjectProperty((Object)this, "minorLinesStroke");
    private final DoubleProperty minorLinesLineWidth = new SimpleDoubleProperty((Object)this, "minorLinesLineWidth");
    private final ObjectProperty<double[]> majorLineDashes = new SimpleObjectProperty((Object)this, "majorLineDashes");
    private final ObjectProperty<double[]> minorLineDashes = new SimpleObjectProperty((Object)this, "minorLineDashes", (Object)new double[]{4.0, 4.0});

    public ChartLinesLayer(GraphicsBase<R> graphics) {
        super("Chart Lines", graphics);
        this.setMajorLinesLineWidth(0.5);
        this.setMajorLinesStroke((Paint)Color.GRAY);
        this.setMinorLinesLineWidth(0.5);
        this.setMinorLinesStroke((Paint)Color.LIGHTGRAY);
        this.redrawObservable((Observable)this.majorLinesLineWidth);
        this.redrawObservable((Observable)this.majorLinesStroke);
        this.redrawObservable((Observable)this.majorLinesVisible);
        this.redrawObservable((Observable)this.majorLineDashes);
        this.redrawObservable((Observable)this.minorLinesLineWidth);
        this.redrawObservable((Observable)this.minorLinesStroke);
        this.redrawObservable((Observable)this.minorLinesVisible);
        this.redrawObservable((Observable)this.minorLineDashes);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showChartLinesLayerProperty());
    }

    public final BooleanProperty majorLinesVisibleProperty() {
        return this.majorLinesVisible;
    }

    public final void setMajorLinesVisible(boolean visible) {
        this.majorLinesVisibleProperty().set(visible);
    }

    public final boolean isMajorLinesVisible() {
        return this.majorLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> majorLinesStrokeProperty() {
        return this.majorLinesStroke;
    }

    public final Paint getMajorLinesStroke() {
        return (Paint)this.majorLinesStrokeProperty().get();
    }

    public final void setMajorLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.majorLinesStrokeProperty().set((Object)stroke);
    }

    public final DoubleProperty majorLinesLineWidthProperty() {
        return this.majorLinesLineWidth;
    }

    public final double getMajorLinesLineWidth() {
        return this.majorLinesLineWidthProperty().get();
    }

    public final void setMajorLinesLineWidth(double lineWidth) {
        this.majorLinesLineWidthProperty().set(lineWidth);
    }

    public final BooleanProperty minorLinesVisibleProperty() {
        return this.minorLinesVisible;
    }

    public final void setMinorLinesVisible(boolean visible) {
        this.minorLinesVisibleProperty().set(visible);
    }

    public final boolean isMinorLinesVisible() {
        return this.minorLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> minorLinesStrokeProperty() {
        return this.minorLinesStroke;
    }

    public final Paint getMinorLinesStroke() {
        return (Paint)this.minorLinesStrokeProperty().get();
    }

    public final void setMinorLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.minorLinesStrokeProperty().set((Object)stroke);
    }

    public final DoubleProperty minorLinesLineWidthProperty() {
        return this.minorLinesLineWidth;
    }

    public final double getMinorLinesLineWidth() {
        return this.minorLinesLineWidthProperty().get();
    }

    public final void setMinorLinesLineWidth(double lineWidth) {
        this.minorLinesLineWidthProperty().set(lineWidth);
    }

    public final ObjectProperty<double[]> majorLineDashesProperty() {
        return this.majorLineDashes;
    }

    public final void setMajorLineDashes(double ... dashes) {
        this.majorLineDashesProperty().set((Object)dashes);
    }

    public final double[] getMajorLineDashes() {
        return (double[])this.majorLineDashesProperty().get();
    }

    public final ObjectProperty<double[]> minorLineDashesProperty() {
        return this.minorLineDashes;
    }

    public final void setMinorLineDashes(double ... dashes) {
        this.minorLineDashesProperty().set((Object)dashes);
    }

    public final double[] getMinorLineDashes() {
        return (double[])this.minorLineDashesProperty().get();
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        R row = canvas.getRow();
        if (row != null) {
            GraphicsContext gc = canvas.getGraphicsContext2D();
            Layout layout = ((Row)row).getLayout();
            if (layout instanceof ChartLayout) {
                double xOffset = this.calculateXOffset();
                double height = canvas.getHeight();
                double width = canvas.getWidth();
                this.drawLines(xOffset, 0.0, height, width, gc, (ChartLayout)layout);
            }
            int lineCount = ((Row)row).getLineCount();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                layout = ((Row)row).getLineLayout(lineIndex);
                if (!(layout instanceof ChartLayout)) continue;
                double lineLocation = ((Row)row).getLineLocation(lineIndex);
                double lineHeight = ((Row)row).getLineHeight(lineIndex);
                double xOffset = this.calculateXOffset();
                double height = canvas.getHeight();
                double width = canvas.getWidth();
                this.drawLines(xOffset, lineLocation, lineHeight, width, gc, (ChartLayout)layout);
            }
        }
    }

    private double calculateXOffset() {
        ScaleLayer scaleLayer = this.getGraphics().getSystemLayer(ScaleLayer.class);
        if (scaleLayer != null && scaleLayer.isVisible()) {
            return scaleLayer.getScaleWidth();
        }
        return 0.0;
    }

    private void drawLines(double xOffset, double yOffset, double height, double width, GraphicsContext gc, ChartLayout layout) {
        double y;
        double value;
        double padding = layout.getPadding();
        double minChartValue = layout.getMinValue();
        double maxChartValue = layout.getMaxValue();
        double range = maxChartValue - minChartValue;
        double ppv = (height -= padding * 2.0) / range;
        double zeroLineLocation = yOffset + padding + layout.getMaxValue() * ppv;
        gc.setStroke(this.getMinorLinesStroke());
        gc.setLineWidth(this.getMinorLinesLineWidth());
        gc.setLineDashes(this.getMinorLineDashes());
        Iterator iterator = layout.getMinorTicks().iterator();
        while (iterator.hasNext()) {
            value = (Double)iterator.next();
            y = (double)((int)(zeroLineLocation - value * ppv)) + 0.5;
            gc.strokeLine(xOffset, y, width, y);
        }
        gc.setStroke(this.getMajorLinesStroke());
        gc.setLineWidth(this.getMajorLinesLineWidth());
        gc.setLineDashes(this.getMajorLineDashes());
        iterator = layout.getMajorTicks().iterator();
        while (iterator.hasNext()) {
            value = (Double)iterator.next();
            y = (double)((int)(zeroLineLocation - value * ppv)) + 0.5;
            gc.strokeLine(xOffset, y, width, y);
        }
    }
}

