/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics.layer;

import com.flexganttfx.model.Layout;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.AgendaLayout;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.ScaleLayer;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.util.AgendaHelper;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class AgendaLinesLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private final BooleanProperty majorLinesVisible = new SimpleBooleanProperty((Object)this, "majorLinesVisible", true);
    private final ObjectProperty<Paint> majorLinesStroke = new SimpleObjectProperty((Object)this, "majorLinesStroke");
    private final DoubleProperty majorLinesLineWidth = new SimpleDoubleProperty((Object)this, "majorLinesLineWidth");
    private final BooleanProperty minorLinesVisible = new SimpleBooleanProperty((Object)this, "minorLinesVisible", true);
    private final ObjectProperty<Paint> minorLinesStroke = new SimpleObjectProperty((Object)this, "minorLinesStroke");
    private final DoubleProperty minorLinesLineWidth = new SimpleDoubleProperty((Object)this, "minorLinesLineWidth");
    private final ObjectProperty<double[]> majorLineDashes = new SimpleObjectProperty((Object)this, "majorLineDashes");
    private final ObjectProperty<double[]> minorLineDashes = new SimpleObjectProperty((Object)this, "minorLineDashes", (Object)new double[]{4.0, 4.0});

    public AgendaLinesLayer(GraphicsBase<R> graphics) {
        super("Agenda Lines", graphics);
        this.setMajorLinesLineWidth(0.5);
        this.setMajorLinesStroke((Paint)Color.GRAY);
        this.setMinorLinesLineWidth(0.5);
        this.setMinorLinesStroke((Paint)Color.LIGHTGRAY);
        this.redrawObservable((Observable)this.majorLinesLineWidth);
        this.redrawObservable((Observable)this.majorLinesStroke);
        this.redrawObservable((Observable)this.majorLinesVisible);
        this.redrawObservable((Observable)this.minorLinesLineWidth);
        this.redrawObservable((Observable)this.minorLinesStroke);
        this.redrawObservable((Observable)this.minorLinesVisible);
        this.fadeInOutObservable((ObservableBooleanValue)graphics.showAgendaLinesLayerProperty());
    }

    public final BooleanProperty majorLinesVisibleProperty() {
        return this.majorLinesVisible;
    }

    public final void setMajorLinesVisible(boolean visible) {
        this.majorLinesVisibleProperty().set(visible);
    }

    public final boolean isMajorLinesVisible() {
        return this.majorLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> majorLinesStrokeProperty() {
        return this.majorLinesStroke;
    }

    public final Paint getMajorLinesStroke() {
        return (Paint)this.majorLinesStrokeProperty().get();
    }

    public final void setMajorLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.majorLinesStrokeProperty().set((Object)stroke);
    }

    public final DoubleProperty majorLinesLineWidthProperty() {
        return this.majorLinesLineWidth;
    }

    public final double getMajorLinesLineWidth() {
        return this.majorLinesLineWidthProperty().get();
    }

    public final void setMajorLinesLineWidth(double lineWidth) {
        this.majorLinesLineWidthProperty().set(lineWidth);
    }

    public final BooleanProperty minorLinesVisibleProperty() {
        return this.minorLinesVisible;
    }

    public final void setMinorLinesVisible(boolean visible) {
        this.minorLinesVisibleProperty().set(visible);
    }

    public final boolean isMinorLinesVisible() {
        return this.minorLinesVisibleProperty().get();
    }

    public final ObjectProperty<Paint> minorLinesStrokeProperty() {
        return this.minorLinesStroke;
    }

    public final Paint getMinorLinesStroke() {
        return (Paint)this.minorLinesStrokeProperty().get();
    }

    public final void setMinorLinesStroke(Paint stroke) {
        Objects.requireNonNull(stroke);
        this.minorLinesStrokeProperty().set((Object)stroke);
    }

    public final DoubleProperty minorLinesLineWidthProperty() {
        return this.minorLinesLineWidth;
    }

    public final double getMinorLinesLineWidth() {
        return this.minorLinesLineWidthProperty().get();
    }

    public final void setMinorLinesLineWidth(double lineWidth) {
        this.minorLinesLineWidthProperty().set(lineWidth);
    }

    public final ObjectProperty<double[]> majorLineDashesProperty() {
        return this.majorLineDashes;
    }

    public final void setMajorLineDashes(double ... dashes) {
        this.majorLineDashesProperty().set((Object)dashes);
    }

    public final double[] getMajorLineDashes() {
        return (double[])this.majorLineDashesProperty().get();
    }

    public final ObjectProperty<double[]> minorLineDashesProperty() {
        return this.minorLineDashes;
    }

    public final void setMinorLineDashes(double ... dashes) {
        this.minorLineDashesProperty().set((Object)dashes);
    }

    public final double[] getMinorLineDashes() {
        return (double[])this.minorLineDashesProperty().get();
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        double height = canvas.getHeight();
        double width = canvas.getWidth();
        R row = canvas.getRow();
        if (row != null) {
            double xOffset = this.calculateXOffset();
            GraphicsContext gc = canvas.getGraphicsContext2D();
            Layout layout = ((Row)row).getLayout();
            if (layout instanceof AgendaLayout) {
                this.drawLines(xOffset, 0.0, height, width, gc, (AgendaLayout)layout);
            }
            int lineCount = ((Row)row).getLineCount();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                layout = ((Row)row).getLineLayout(lineIndex);
                if (!(layout instanceof AgendaLayout)) continue;
                double lineLocation = ((Row)row).getLineLocation(lineIndex);
                double lineHeight = ((Row)row).getLineHeight(lineIndex);
                this.drawLines(xOffset, lineLocation, lineHeight, width, gc, (AgendaLayout)layout);
            }
        }
    }

    private double calculateXOffset() {
        ScaleLayer scaleLayer = this.getGraphics().getSystemLayer(ScaleLayer.class);
        if (scaleLayer != null && scaleLayer.isVisible()) {
            return scaleLayer.getScaleWidth();
        }
        return 0.0;
    }

    private void drawLines(double xOffset, double yOffset, double height, double width, GraphicsContext gc, AgendaLayout layout) {
        List<AgendaHelper.AgendaLineLocation> locations = AgendaHelper.getLineLocations(layout, yOffset += layout.getPadding(), height -= 2.0 * layout.getPadding());
        for (AgendaHelper.AgendaLineLocation loc : locations) {
            if (this.isMajorLinesVisible() && !loc.isMinor()) {
                gc.setLineWidth(this.getMajorLinesLineWidth());
                gc.setLineDashes(this.getMajorLineDashes());
                gc.setStroke(this.getMajorLinesStroke());
                gc.strokeLine(xOffset, loc.getLocation(), width, loc.getLocation());
            }
            if (!this.isMinorLinesVisible() || !loc.isMinor()) continue;
            gc.setLineWidth(this.getMinorLinesLineWidth());
            gc.setLineDashes(this.getMinorLineDashes());
            gc.setStroke(this.getMinorLinesStroke());
            gc.strokeLine(xOffset, loc.getLocation(), width, loc.getLocation());
        }
    }
}

