/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import java.time.Instant;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;

public class LassoEvent
extends InputEvent {
    private static final long serialVersionUID = -79848169297372705L;
    public static final EventType<LassoEvent> ALL = new EventType(InputEvent.ANY, "ALL");
    public static final EventType<LassoEvent> SELECTION_STARTED = new EventType(ALL, "SELECTION_STARTED");
    public static final EventType<LassoEvent> SELECTION_FINISHED = new EventType(ALL, "SELECTION_FINISHED");
    public static final EventType<LassoEvent> SELECTION_ONGOING = new EventType(ALL, "SELECTION_ONGOING");
    private final LassoInfo info;

    public LassoEvent(GraphicsBase<?> target, EventType<? extends LassoEvent> eventType, LassoInfo info) {
        super(target, target, eventType);
        this.info = info;
    }

    public final LassoInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "type = " + this.getEventType() + ", source = " + this.getSource() + ", target = " + this.getTarget() + ", info = " + this.getInfo();
    }

    public static final class LassoInfo {
        private final Instant startTime;
        private final Instant endTime;
        private final LocalTime localStartTime;
        private final LocalTime localEndTime;
        private final List<Row<?, ?, ?>> rows;
        private final List<ActivityRef<?>> activities;
        private final MouseEvent mouseEvent;

        public LassoInfo(MouseEvent mouseEvent, Instant startTime, Instant endTime, LocalTime localStartTime, LocalTime localEndTime, List<Row<?, ?, ?>> rows, List<ActivityRef<?>> activities) {
            this.mouseEvent = Objects.requireNonNull(mouseEvent);
            this.startTime = Objects.requireNonNull(startTime);
            this.endTime = Objects.requireNonNull(endTime);
            this.localStartTime = localStartTime;
            this.localEndTime = localEndTime;
            this.rows = rows;
            this.activities = activities;
        }

        public MouseEvent getMouseEvent() {
            return this.mouseEvent;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final LocalTime getLocalStartTime() {
            return this.localStartTime;
        }

        public final LocalTime getLocalEndTime() {
            return this.localEndTime;
        }

        public final List<Row<?, ?, ?>> getRows() {
            return this.rows;
        }

        public final List<ActivityRef<?>> getActivities() {
            return this.activities;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("start time = ").append(this.startTime);
            sb.append(", end time = ").append(this.endTime);
            sb.append(", local start time = ").append(this.localStartTime);
            sb.append(", local end time = ").append(this.localEndTime);
            if (this.rows != null) {
                sb.append(", rows = ").append(Arrays.toString(this.rows.toArray()));
            }
            if (this.activities != null) {
                sb.append(", activities = ").append(Arrays.toString(this.activities.toArray()));
            }
            return sb.toString();
        }
    }
}

