/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view.container;

import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.container.ContainerBase;
import impl.com.flexganttfx.skin.container.MultiGanttChartContainerSkin;
import javafx.geometry.Orientation;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitPane;

public class MultiGanttChartContainerBase<T extends GanttChartBase<?>>
extends ContainerBase<T> {
    private final SplitPane splitPane = new SplitPane();

    protected MultiGanttChartContainerBase(boolean autoBinding, T ... ganttCharts) {
        super(autoBinding, ganttCharts);
        this.splitPane.setOrientation(Orientation.VERTICAL);
        this.resetDividerPositions();
    }

    public MultiGanttChartContainerBase(T ... ganttCharts) {
        this(true, (GanttChartBase[])ganttCharts);
    }

    public MultiGanttChartContainerBase(boolean autoBinding) {
        this(autoBinding, null);
    }

    public MultiGanttChartContainerBase() {
        this(true);
    }

    public final void resetDividerPositions() {
        int count = this.getGanttCharts().size();
        if (count > 0) {
            double[] positions = new double[count - 1];
            for (int i = 0; i < count - 1; ++i) {
                positions[i] = (double)(i + 1) * (1.0 / (double)this.getGanttCharts().size());
            }
            this.splitPane.setDividerPositions(positions);
        }
    }

    public final SplitPane getSplitPane() {
        return this.splitPane;
    }

    protected Skin<?> createDefaultSkin() {
        return new MultiGanttChartContainerSkin(this);
    }
}

