/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.view;

import com.flexganttfx.model.Row;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.util.Messages;
import com.flexganttfx.view.util.RowHeader;
import impl.com.flexganttfx.skin.GanttChartSkin;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.controlsfx.control.MasterDetailPane;

public class GanttChart<R extends Row<?, ?, ?>>
extends GanttChartBase<R> {
    private static final String STANDARD_DISPLAY_MODE_TREE_TABLE_VIEW = "tree-table-view-standard-display-mode";
    private static final String TABLE_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW = "tree-table-view-table-only-display-mode";
    private static final String GRAPHICS_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW = "tree-table-view-graphics-only-display-mode";
    private final TreeTableView<R> treeTableView;
    private final RowHeader<R> rowHeader;
    private final ScrollBar treeTableScrollBar;
    private final MasterDetailPane treeTableMasterDetailPane;
    private final ObjectProperty<DisplayMode> displayMode = new SimpleObjectProperty((Object)this, "displayMode", (Object)DisplayMode.STANDARD);
    private BooleanProperty tableMenuButtonVisible;
    private final ObjectProperty<R> root = new SimpleObjectProperty((Object)this, "root");
    private final BooleanProperty showTreeTable = new SimpleBooleanProperty((Object)this, "showTreeTable", true);
    private final ObjectProperty<RowHeaderType> rowHeaderType = new SimpleObjectProperty((Object)this, "rowHeaderType", (Object)RowHeaderType.ROW_NUMBER);
    private final ObjectProperty<Callback<R, Node>> rowHeaderNodeFactory = new SimpleObjectProperty((Object)this, "rowHeaderNodeFactory", row -> new Label());

    public GanttChart() {
        this(null);
    }

    public GanttChart(R root) {
        this.setRoot(root);
        this.treeTableView = this.createTreeTable();
        this.treeTableView.getStyleClass().add((Object)"gantt-tree-table-view");
        this.redrawObservable((Observable)this.treeTableView.sortModeProperty());
        this.displayModeProperty().addListener(evt -> this.updateTreeTableStyles());
        this.updateTreeTableStyles();
        this.treeTableScrollBar = new ScrollBar();
        this.treeTableScrollBar.setOrientation(Orientation.HORIZONTAL);
        this.treeTableMasterDetailPane = new MasterDetailPane(Side.LEFT);
        this.treeTableMasterDetailPane.setId("treetable-master-detail-pane");
        Bindings.bindBidirectional((Property)this.treeTableMasterDetailPane.showDetailNodeProperty(), (Property)this.showTreeTableProperty());
        this.redrawObservable((Observable)this.rootProperty());
        this.rowHeader = this.createRowHeader();
        TreeTableColumn nameColumn = new TreeTableColumn(Messages.getString("GanttChart.NAME_COLUMN"));
        nameColumn.setPrefWidth(200.0);
        nameColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("name"));
        nameColumn.setEditable(true);
        this.getTreeTable().getColumns().add((Object)nameColumn);
        this.getTreeTable().setTreeColumn(nameColumn);
        Region graphicViewHeader = new Region();
        graphicViewHeader.getStyleClass().add((Object)"graphic-view-header");
        this.setGraphicsHeader((Node)graphicViewHeader);
        ListViewGraphics graphics = this.getGraphics();
        graphics.rowFilterProperty().bindBidirectional(this.rowFilterProperty());
    }

    protected Skin<?> createDefaultSkin() {
        return new GanttChartSkin(this);
    }

    private void updateTreeTableStyles() {
        this.treeTableView.getStyleClass().remove((Object)STANDARD_DISPLAY_MODE_TREE_TABLE_VIEW);
        this.treeTableView.getStyleClass().remove((Object)TABLE_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW);
        this.treeTableView.getStyleClass().remove((Object)GRAPHICS_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW);
        switch (this.getDisplayMode()) {
            case STANDARD: {
                this.treeTableView.getStyleClass().add((Object)STANDARD_DISPLAY_MODE_TREE_TABLE_VIEW);
                break;
            }
            case TABLE_ONLY: {
                this.treeTableView.getStyleClass().add((Object)TABLE_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW);
                break;
            }
            case GRAPHICS_ONLY: {
                this.treeTableView.getStyleClass().add((Object)GRAPHICS_ONLY_DISPLAY_MODE_TREE_TABLE_VIEW);
                break;
            }
        }
    }

    public final ObjectProperty<DisplayMode> displayModeProperty() {
        return this.displayMode;
    }

    public final void setDisplayMode(DisplayMode mode) {
        this.displayModeProperty().set((Object)mode);
    }

    public final DisplayMode getDisplayMode() {
        return (DisplayMode)((Object)this.displayModeProperty().get());
    }

    protected TreeTableView<R> createTreeTable() {
        TreeTableView table = new TreeTableView();
        table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        table.setPlaceholder((Node)new Label(Messages.getString("GanttChart.PLACEHOLDER_NO_DATA")));
        return table;
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty((Object)this, "tableMenuButtonVisible", true);
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean value) {
        this.tableMenuButtonVisibleProperty().set(value);
    }

    public final boolean isTableMenuButtonVisible() {
        return this.tableMenuButtonVisible != null && this.tableMenuButtonVisible.get();
    }

    public final ObjectProperty<R> rootProperty() {
        return this.root;
    }

    public final void setRoot(R root) {
        this.rootProperty().set(root);
    }

    public final R getRoot() {
        return (R)((Row)this.root.get());
    }

    public final RowHeader<R> getRowHeader() {
        return this.rowHeader;
    }

    protected RowHeader<R> createRowHeader() {
        return new RowHeader(this);
    }

    public final ScrollBar getTreeTableScrollBar() {
        return this.treeTableScrollBar;
    }

    public final TreeTableView<R> getTreeTable() {
        return this.treeTableView;
    }

    public MasterDetailPane getTreeTableMasterDetailPane() {
        return this.treeTableMasterDetailPane;
    }

    public final BooleanProperty showTreeTableProperty() {
        return this.showTreeTable;
    }

    public final boolean isShowTreeTable() {
        return this.showTreeTableProperty().get();
    }

    public final void setShowTreeTable(boolean show) {
        this.showTreeTableProperty().set(show);
    }

    public final ObjectProperty<RowHeaderType> rowHeaderTypeProperty() {
        return this.rowHeaderType;
    }

    public final void setRowHeaderType(RowHeaderType type) {
        Objects.requireNonNull(type);
        this.rowHeaderTypeProperty().set((Object)type);
    }

    public final RowHeaderType getRowHeaderType() {
        return (RowHeaderType)((Object)this.rowHeaderTypeProperty().get());
    }

    public final ObjectProperty<Callback<R, Node>> rowHeaderNodeFactoryProperty() {
        return this.rowHeaderNodeFactory;
    }

    public final void setRowHeaderNodeFactory(Callback<R, Node> factory) {
        Objects.requireNonNull(factory);
        this.rowHeaderNodeFactory.set(factory);
    }

    public final Callback<R, Node> getRowHeaderNodeFactory() {
        return (Callback)this.rowHeaderNodeFactory.get();
    }

    public final void expandRows() {
        this.expandOrCollapseRows(true, true);
    }

    public final void expandRowsByOneLevel() {
        this.expandOrCollapseRows(true, false);
    }

    public final void collapseRows() {
        this.expandOrCollapseRows(false, true);
    }

    public final void collapseRowsByOneLevel() {
        this.expandOrCollapseRows(false, false);
    }

    private void expandOrCollapseRows(boolean expand, boolean all) {
        R root = this.getRoot();
        if (root == null) {
            return;
        }
        if (expand) {
            this.openItem((Row<?, ?, ?>)root, all);
        } else {
            int maxDepth = 0;
            if (!all) {
                maxDepth = this.computeMaxDepth((Row<?, ?, ?>)root, 0);
            }
            this.closeItem((Row<?, ?, ?>)root, all, 0, maxDepth);
            if (!this.getTreeTable().isShowRoot()) {
                ((Row)root).setExpanded(true);
            }
        }
    }

    private int computeMaxDepth(Row<?, ?, ?> row, int maxDepth) {
        int depth = row.getPath().length;
        if (row.isExpanded()) {
            for (Row child : row.getChildren()) {
                depth = Math.max(this.computeMaxDepth(child, depth), depth);
            }
        }
        return Math.max(depth, maxDepth);
    }

    private void openItem(Row<?, ?, ?> item, boolean all) {
        block2: {
            block3: {
                if (item == null || item.isLeaf()) break block2;
                if (!item.isExpanded()) break block3;
                for (Object child : item.getChildren()) {
                    this.openItem((Row)child, all);
                }
                break block2;
            }
            item.setExpanded(true);
            if (!all) break block2;
            for (Object child : item.getChildren()) {
                this.openItem((Row)child, true);
            }
        }
    }

    private void closeItem(Row<?, ?, ?> item, boolean all, int depth, int closeLevel) {
        if (item != null) {
            Object parent;
            for (Row child : item.getChildren()) {
                this.closeItem(child, all, depth + 1, closeLevel);
            }
            if (all) {
                item.setExpanded(false);
            } else if (item.getPath().length == closeLevel && (parent = item.getParent()) != null) {
                ((Row)parent).setExpanded(false);
            }
        }
    }

    public final void resizeColumns() {
        this.resizeColumns(-1);
    }

    public final void resizeColumns(int maxRows) {
        for (TreeTableColumn column : this.getTreeTable().getColumns()) {
            this.resizeColumn(column, maxRows);
        }
    }

    public final void resizeColumn(TreeTableColumn<R, ?> column) {
        this.resizeColumn(column, -1);
    }

    public final void resizeColumn(TreeTableColumn tc, int maxRows) {
        Node n;
        ObservableList items = this.getGraphics().getRows();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback cellFactory = tc.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TreeTableCell cell = (TreeTableCell)cellFactory.call((Object)tc);
        if (cell == null) {
            return;
        }
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        TreeTableRow treeTableRow = new TreeTableRow();
        treeTableRow.updateTreeTableView(this.treeTableView);
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows);
        double maxWidth = 0.0;
        for (int row = 0; row < rows; ++row) {
            treeTableRow.updateIndex(row);
            treeTableRow.updateTreeItem(this.treeTableView.getTreeItem(row));
            cell.updateTreeTableColumn(tc);
            cell.updateTreeTableView(this.treeTableView);
            cell.updateTreeTableRow(treeTableRow);
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add((Object)cell);
            cell.impl_processCSS(false);
            double w = cell.prefWidth(-1.0);
            maxWidth = Math.max(maxWidth, w);
            this.getChildren().remove((Object)cell);
        }
        cell.updateIndex(-1);
        double widthMax = maxWidth + padding;
        if (this.treeTableView.getColumnResizePolicy() == TreeTableView.CONSTRAINED_RESIZE_POLICY) {
            widthMax = Math.max(widthMax, tc.getWidth());
        }
        tc.impl_setWidth(widthMax);
    }

    public static enum RowHeaderType {
        ROW_NUMBER,
        LEVEL_NUMBER,
        GRAPHIC_NODE;

    }

    public static enum DisplayMode {
        STANDARD,
        TABLE_ONLY,
        GRAPHICS_ONLY;

    }
}

