/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.util;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class TimeInterval {
    private Instant startTime;
    private Instant endTime;

    public TimeInterval(Instant startTime, Instant endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        if (startTime.isAfter(endTime)) {
            throw new IllegalArgumentException("start time can not be after end time, start = " + startTime + ", end = " + endTime);
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Duration getDuration() {
        return Duration.between(this.startTime, this.endTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.startTime == null) {
            return other.startTime == null;
        }
        return this.startTime.equals(other.startTime);
    }

    public String toString() {
        return "TimeInterval [startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }
}

