/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.util;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;

public class ChronoUnitUtils {
    public static ZonedDateTime truncate(ZonedDateTime time, ChronoUnit unit, int stepRate, DayOfWeek firstDayOfWeek) {
        switch (unit) {
            case DAYS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.DAY_OF_YEAR, stepRate).truncatedTo(unit);
            }
            case HALF_DAYS: {
                return time.truncatedTo(unit);
            }
            case HOURS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MONTHS: {
                return time.with(ChronoField.MONTH_OF_YEAR, Math.max(1, time.get(ChronoField.MONTH_OF_YEAR) - time.get(ChronoField.MONTH_OF_YEAR) % stepRate)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            case YEARS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.YEAR, stepRate).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                ZonedDateTime result = time.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue()).truncatedTo(ChronoUnit.DAYS);
                if (result.isAfter(time)) {
                    result = result.minusWeeks(1L);
                }
                return result;
            }
            case DECADES: {
                int decade = time.getYear() / 10 * 10;
                return time.with(ChronoField.YEAR, decade).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case CENTURIES: {
                int century = time.getYear() / 100 * 100;
                return time.with(ChronoField.YEAR, century).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case MILLENNIA: {
                int millennium = time.getYear() / 1000 * 1000;
                return time.with(ChronoField.YEAR, millennium).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        return time;
    }

    public static LocalTime truncate(LocalTime time, ChronoUnit unit, int stepRate) {
        switch (unit) {
            case HOURS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return ChronoUnitUtils.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
        }
        return time;
    }

    private static ZonedDateTime adjustField(ZonedDateTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static LocalTime adjustField(LocalTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }
}

