/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.repository;

import com.flexganttfx.core.LoggingDomain;
import com.flexganttfx.model.Activity;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.repository.MutableActivityRepositoryBase;
import com.flexganttfx.model.repository.RepositoryEvent;
import com.flexganttfx.model.util.ActivityComparator;
import com.flexganttfx.model.util.ActivityHelper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListActivityRepository<A extends Activity>
extends MutableActivityRepositoryBase<A> {
    private IteratorType iteratorType = IteratorType.BINARY_ITERATOR;
    private final Map<Layer, List<A>> activitiesMap = new HashMap<Layer, List<A>>();

    public ListActivityRepository() {
        this(IteratorType.BINARY_ITERATOR);
    }

    public ListActivityRepository(IteratorType iteratorType) {
        this.setIteratorType(iteratorType);
    }

    public final IteratorType getIteratorType() {
        return this.iteratorType;
    }

    public final void setIteratorType(IteratorType iteratorType) {
        Objects.requireNonNull(iteratorType);
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINE)) {
            LoggingDomain.REPOSITORY.fine("setting iterator type to " + (Object)((Object)iteratorType));
        }
        this.iteratorType = iteratorType;
    }

    @Override
    public final Iterator<A> getActivities(Layer layer, Instant startTime, Instant endTime, TemporalUnit temporalUnit, ZoneId zoneId) {
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINEST)) {
            LoggingDomain.REPOSITORY.fine("layer = " + layer + ", temporal unit = " + temporalUnit + ", zone = " + zoneId + ", startTime = " + startTime + ", endTime = " + endTime);
        }
        switch (this.iteratorType) {
            case BINARY_ITERATOR: {
                if (LoggingDomain.REPOSITORY.isLoggable(Level.FINEST)) {
                    LoggingDomain.REPOSITORY.fine("using iterator of type " + BinarySearchActivityIterator.class.getName());
                }
                return new BinarySearchActivityIterator<A>(this.getActivities(layer), startTime, endTime);
            }
            case LINEAR_ITERATOR: {
                if (LoggingDomain.REPOSITORY.isLoggable(Level.FINEST)) {
                    LoggingDomain.REPOSITORY.fine("using iterator of type " + LinearSearchActivityIterator.class.getName());
                }
                return new LinearSearchActivityIterator<A>(this.getActivities(layer), startTime, endTime);
            }
            case SIMPLE_ITERATOR: {
                if (LoggingDomain.REPOSITORY.isLoggable(Level.FINEST)) {
                    LoggingDomain.REPOSITORY.fine("using the iterator provided by the list (which returns ALL activities)");
                }
                return this.getActivities(layer).iterator();
            }
        }
        throw new IllegalArgumentException("unknown iterator type: " + (Object)((Object)this.iteratorType));
    }

    @Override
    public final void addActivity(ActivityRef<A> activityRef) {
        Objects.requireNonNull(activityRef);
        A activity = activityRef.getActivity();
        Layer layer = activityRef.getLayer();
        List<A> activities = this.getActivities(layer);
        int index = Collections.binarySearch(activities, activity, ActivityComparator.getInstance());
        if (index < 0) {
            activities.add(-index - 1, activity);
        }
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
            LoggingDomain.REPOSITORY.finer("added activity " + activity.getName() + ", layer = " + layer.getName() + ", row = " + activityRef.getRow().getName() + ", new activities count = " + activities.size());
        }
        this.fireEvent(new RepositoryEvent(RepositoryEvent.ACTIVITY_ADDED, this, activityRef));
    }

    @Override
    public final void removeActivity(ActivityRef<A> activityRef) {
        Objects.requireNonNull(activityRef);
        A activity = activityRef.getActivity();
        Layer layer = activityRef.getLayer();
        List<A> activities = this.getActivities(layer);
        activities.remove(activity);
        if (LoggingDomain.REPOSITORY.isLoggable(Level.FINER)) {
            LoggingDomain.REPOSITORY.finer("removed activity " + activity.getName() + " from layer " + layer.getName() + ", row = " + activityRef.getRow().getName() + ", member = " + this.getActivities(layer).contains(activity) + ", new activities count = " + activities.size());
        }
        this.fireEvent(new RepositoryEvent(RepositoryEvent.ACTIVITY_REMOVED, this, activityRef));
    }

    @Override
    public final void clearActivities() {
        for (Layer layer : this.activitiesMap.keySet()) {
            List<A> activities = this.getActivities(layer);
            activities.clear();
        }
        this.fireEvent(new RepositoryEvent(this));
    }

    @Override
    public final void clearActivities(Layer layer) {
        List<A> activities = this.getActivities(layer);
        activities.clear();
        this.fireEvent(new RepositoryEvent(this));
    }

    @Override
    public final Instant getEarliestTimeUsed() {
        if (!this.activitiesMap.isEmpty()) {
            Instant time = null;
            for (List<A> list : this.activitiesMap.values()) {
                if (list.isEmpty()) continue;
                Activity activity = (Activity)list.get(0);
                if (time != null && !activity.getStartTime().isBefore(time)) continue;
                time = activity.getStartTime();
            }
            if (LoggingDomain.REPOSITORY.isLoggable(Level.FINE)) {
                if (time != null) {
                    LoggingDomain.REPOSITORY.fine("returning " + DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(time) + " for earliest time used");
                } else {
                    LoggingDomain.REPOSITORY.fine("no earliest time found");
                }
            }
            return time;
        }
        return null;
    }

    @Override
    public final Instant getLatestTimeUsed() {
        if (!this.activitiesMap.isEmpty()) {
            Instant time = null;
            for (List<A> list : this.activitiesMap.values()) {
                if (list.isEmpty()) continue;
                Activity activity = (Activity)list.get(list.size() - 1);
                if (time != null && !activity.getEndTime().isAfter(time)) continue;
                time = activity.getEndTime();
            }
            if (LoggingDomain.REPOSITORY.isLoggable(Level.FINE)) {
                if (time != null) {
                    LoggingDomain.REPOSITORY.fine("returning " + DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(time) + " for latest time used");
                } else {
                    LoggingDomain.REPOSITORY.fine("no latest time found");
                }
            }
            return time;
        }
        return null;
    }

    List<A> getActivities(Layer layer) {
        List<A> activities = this.activitiesMap.get(layer);
        if (activities == null) {
            activities = new ArrayList<A>();
            this.activitiesMap.put(layer, activities);
        }
        return activities;
    }

    public final List<A> getAllActivities() {
        ArrayList result = new ArrayList();
        this.activitiesMap.values().forEach(result::addAll);
        return result;
    }

    static class BinarySearchActivityIterator<T extends Activity>
    implements Iterator<T> {
        private List<T> objectList;
        private Instant startTime;
        private Instant endTime;
        private int index = -1;

        public BinarySearchActivityIterator(List<T> activities, Instant startTime, Instant endTime) {
            Objects.requireNonNull(activities);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.objectList = activities;
            this.startTime = startTime;
            this.endTime = endTime;
            this.index = this.findFirstObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.objectList.size() > this.index) {
                Activity obj = (Activity)this.objectList.get(this.index);
                return !obj.getStartTime().isAfter(this.endTime);
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return (T)((Activity)this.objectList.get(this.index++));
            }
            throw new UnsupportedOperationException("iterator has no more elements to return");
        }

        private int findFirstObject() {
            int result = 0;
            if (this.objectList != null && this.objectList.size() > 0) {
                Instant startTime = this.startTime;
                Instant endTime = this.endTime;
                int low = 0;
                int high = this.objectList.size() - 1;
                do {
                    int m = low + (high - low) / 2;
                    Activity obj = (Activity)this.objectList.get(m);
                    Instant su = obj.getStartTime();
                    Instant eu = obj.getEndTime();
                    if (!eu.isBefore(startTime) && !su.isAfter(endTime)) {
                        high = m - 1;
                        continue;
                    }
                    if (eu.isBefore(startTime)) {
                        low = m + 1;
                        continue;
                    }
                    if (!su.isAfter(endTime)) continue;
                    high = m - 1;
                } while (high >= low);
                result = low;
                if (low > 0) {
                    Activity obj;
                    int i = low = Math.min(low, this.objectList.size() - 1);
                    while (low >= 0 && ActivityHelper.intersect((obj = (Activity)this.objectList.get(i)).getStartTime(), obj.getEndTime(), startTime, endTime)) {
                        result = i;
                        --low;
                    }
                }
            }
            return result;
        }
    }

    static class LinearSearchActivityIterator<T extends Activity>
    implements Iterator<T> {
        private static final Logger LOGGER = Logger.getLogger(LinearSearchActivityIterator.class.getName());
        private List<T> activities;
        private int index = -1;
        private Instant startTime;
        private Instant endTime;
        private boolean reverse;

        public LinearSearchActivityIterator(List<T> activities, Instant startTime, Instant endTime, boolean reverse) {
            Objects.requireNonNull(activities);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.activities = activities;
            this.startTime = startTime;
            this.endTime = endTime;
            this.reverse = reverse;
            this.index = this.findFirstObject();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("object list size = " + activities.size());
                LOGGER.fine("start time = " + startTime);
                LOGGER.fine("end time = " + startTime);
                LOGGER.fine("reverse = " + reverse);
                LOGGER.fine("index of first activity = " + this.index);
            }
        }

        public LinearSearchActivityIterator(List<T> objectList, Instant startTime, Instant endTime) {
            this(objectList, startTime, endTime, false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("index = " + this.index);
            }
            if (this.index >= 0 && this.index < this.activities.size()) {
                Activity activity = (Activity)this.activities.get(this.index);
                return ActivityHelper.intersect(activity.getStartTime(), activity.getEndTime(), this.startTime, this.endTime);
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                if (this.reverse) {
                    return (T)((Activity)this.activities.get(this.index--));
                }
                return (T)((Activity)this.activities.get(this.index++));
            }
            throw new UnsupportedOperationException("iterator has no more elements to return");
        }

        private int findFirstObject() {
            block4: {
                if (this.activities == null || this.activities.size() <= 0) break block4;
                if (this.reverse) {
                    for (int i = this.activities.size() - 1; i >= 0; --i) {
                        Activity activity = (Activity)this.activities.get(i);
                        if (!ActivityHelper.intersect(this.startTime, this.endTime, activity.getStartTime(), activity.getEndTime())) continue;
                        return i;
                    }
                } else {
                    for (int i = 0; i < this.activities.size(); ++i) {
                        Activity activity = (Activity)this.activities.get(i);
                        if (!ActivityHelper.intersect(this.startTime, this.endTime, activity.getStartTime(), activity.getEndTime())) continue;
                        return i;
                    }
                }
            }
            return -1;
        }
    }

    public static enum IteratorType {
        SIMPLE_ITERATOR,
        BINARY_ITERATOR,
        LINEAR_ITERATOR;

    }
}

