/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.layout;

import com.flexganttfx.model.Activity;
import com.flexganttfx.model.Layout;
import com.flexganttfx.model.LinesManager;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.exception.IllegalLineIndexException;
import com.flexganttfx.model.layout.GanttLayout;
import java.util.Objects;

public class EqualLinesManager<R extends Row<?, ?, A>, A extends Activity>
implements LinesManager<A> {
    private R row;
    private double[] lineLocations;
    private Layout lineLayout;
    private double[] lineHeights;

    public EqualLinesManager(R row) {
        Objects.requireNonNull(row);
        this.row = row;
        ((Row)this.row).lineCountProperty().addListener(observable -> this.clearCache());
        ((Row)this.row).heightProperty().addListener(observable -> this.clearCache());
    }

    public final R getRow() {
        return this.row;
    }

    private void clearCache() {
        this.lineLocations = null;
        this.lineHeights = null;
    }

    private void assertLineIndex(int lineIndex) throws IllegalLineIndexException {
        if (lineIndex < 0 || lineIndex >= ((Row)this.row).getLineCount()) {
            throw new IllegalLineIndexException((Row<?, ?, ?>)this.row, lineIndex, ((Row)this.row).getLineCount());
        }
    }

    @Override
    public final double getLineLocation(int lineIndex, double rowHeight) throws IllegalLineIndexException {
        this.assertLineIndex(lineIndex);
        if (this.lineLocations == null) {
            int s = ((Row)this.row).getLineCount();
            this.lineLocations = new double[s];
            double h = ((Row)this.row).getHeight() / (double)s;
            for (int i = 0; i < s; ++i) {
                this.lineLocations[i] = (double)i * h;
            }
        }
        return this.lineLocations[lineIndex];
    }

    @Override
    public Layout getLineLayout(int lineIndex) throws IllegalLineIndexException {
        this.assertLineIndex(lineIndex);
        if (this.lineLayout == null) {
            this.lineLayout = new GanttLayout();
        }
        return this.lineLayout;
    }

    @Override
    public final double getLineHeight(int lineIndex, double rowHeight) throws IllegalLineIndexException {
        this.assertLineIndex(lineIndex);
        if (this.lineHeights == null) {
            int s = ((Row)this.row).getLineCount();
            this.lineHeights = new double[s];
            double h = ((Row)this.row).getHeight() / (double)s;
            for (int i = 0; i < s; ++i) {
                this.lineHeights[i] = h;
            }
        }
        return this.lineHeights[lineIndex];
    }

    @Override
    public int getLineIndex(A activity) {
        return -1;
    }
}

