/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Objects;

public abstract class VirtualGrid<T extends TemporalUnit> {
    private String name;
    private String shortName;
    private T unit;
    private int amount;

    public VirtualGrid(String name, String shortName, T unit, int amount) {
        this.name = Objects.requireNonNull(name);
        this.unit = (TemporalUnit)Objects.requireNonNull(unit);
        this.shortName = Objects.requireNonNull(shortName);
        if (amount <= 0) {
            throw new IllegalArgumentException("grid amount must be larger than 0 but was " + amount);
        }
        this.amount = amount;
    }

    public VirtualGrid(String name, T unit, int amount) {
        this(name, name, unit, amount);
    }

    public final String getName() {
        return this.name;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final T getUnit() {
        return this.unit;
    }

    public final int getAmount() {
        return this.amount;
    }

    public abstract Instant adjustTime(Instant var1, ZoneId var2, boolean var3, DayOfWeek var4);

    public abstract LocalTime adjustTime(LocalTime var1, boolean var2);

    public String toString() {
        return this.getName();
    }
}

