/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import com.flexganttfx.model.dateline.Resolution;
import com.flexganttfx.model.dateline.SimpleUnitGrid;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.model.util.SimpleUnit;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;

public final class SimpleUnitResolution
extends Resolution<SimpleUnit> {
    private NumberFormat formatter = DecimalFormat.getInstance();

    public SimpleUnitResolution(SimpleUnit unit, String format, int stepRate, Resolution.Position ... supportedPositions) {
        super(unit, format, stepRate, supportedPositions);
    }

    public SimpleUnitResolution(SimpleUnit unit, String format, int stepRate) {
        super(unit, format, stepRate);
    }

    @Override
    public String format(Instant instant, ZoneId zoneId) {
        SimpleUnit unit = (SimpleUnit)this.getTemporalUnit();
        if (unit.ordinal() < SimpleUnit.values().length - 1) {
            return this.formatter.format(instant.toEpochMilli() % SimpleUnit.values()[unit.ordinal() + 1].getMillis());
        }
        return this.formatter.format(instant.toEpochMilli());
    }

    @Override
    public Instant truncate(Instant temporal, ZoneId zoneId, DayOfWeek firstDayOfWeek) {
        long millis = temporal.toEpochMilli();
        millis -= millis % ((SimpleUnit)this.getTemporalUnit()).getMillis();
        millis -= millis % (long)this.getStepRate();
        return Instant.ofEpochMilli(millis);
    }

    @Override
    public Instant increment(Instant instant, ZoneId zoneId) {
        return instant.plus(((SimpleUnit)this.getTemporalUnit()).getDuration().multipliedBy(this.getStepRate()));
    }

    @Override
    public VirtualGrid<SimpleUnit> createGrid() {
        return new SimpleUnitGrid("Auto", (SimpleUnit)this.getTemporalUnit(), this.getStepRate());
    }
}

