/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.dateline;

import com.flexganttfx.core.StringUtils;
import com.flexganttfx.model.dateline.Resolution;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;

public abstract class DatelineModel<T extends TemporalUnit> {
    private ObservableSet<String> availableZoneIds = FXCollections.observableSet((Object[])new String[0]);
    private final ObservableMap<T, ObservableList<Resolution<? extends T>>> resolutionMap = FXCollections.observableHashMap();
    private final ObservableList<Resolution<? extends T>> resolutions = FXCollections.observableArrayList();
    private final ObservableList<T> temporalUnits = FXCollections.observableArrayList();
    private IntegerProperty scaleCount = new SimpleIntegerProperty(this, "scaleCount", 2){

        public void set(int value) {
            if (value < DatelineModel.this.getMinScaleCount() || value > DatelineModel.this.getMaxScaleCount()) {
                throw new IllegalArgumentException("scale count must be between " + DatelineModel.this.getMinScaleCount() + " and " + DatelineModel.this.getMaxScaleCount() + " but was " + value);
            }
            super.set(value);
        }
    };
    private IntegerProperty maxScaleCount = new SimpleIntegerProperty(this, "maxScaleCount", 5){

        public void set(int value) {
            if (value < 1 || value > 5) {
                throw new IllegalArgumentException("max scale count must be between 1 and 5 but was " + value);
            }
            if (value < DatelineModel.this.getMinScaleCount()) {
                throw new IllegalArgumentException("max scale count must be larger than or equal to min scale count");
            }
            super.set(value);
            DatelineModel.this.setScaleCount(Math.min(DatelineModel.this.getScaleCount(), value));
        }
    };
    private IntegerProperty minScaleCount = new SimpleIntegerProperty(this, "minScaleCount", 1){

        public void set(int value) {
            if (value < 1 || value > 5) {
                throw new IllegalArgumentException("min scale count must be between 1 and 5 but was " + value);
            }
            if (value > DatelineModel.this.getMaxScaleCount()) {
                throw new IllegalArgumentException("min scale count must be smaller than or equal to max scale count");
            }
            super.set(value);
            DatelineModel.this.setScaleCount(Math.max(DatelineModel.this.getScaleCount(), value));
        }
    };

    protected DatelineModel() {
        this.addZoneId("Europe/Berlin");
        this.addZoneId("America/New_York");
        this.addZoneId("Australia/Darwin");
        this.addZoneId("Australia/Sydney");
        this.addZoneId("America/Argentina/Buenos_Aires");
        this.addZoneId("Africa/Cairo");
        this.addZoneId("America/Anchorage");
        this.addZoneId("America/Sao_Paulo");
        this.addZoneId("Asia/Dhaka");
        this.addZoneId("Africa/Harare");
        this.addZoneId("America/St_Johns");
        this.addZoneId("America/Chicago");
        this.addZoneId("Asia/Shanghai");
        this.addZoneId("Africa/Addis_Ababa");
        this.addZoneId("Europe/Paris");
        this.addZoneId("America/Indiana/Indianapolis");
        this.addZoneId("Asia/Kolkata");
        this.addZoneId("Asia/Tokyo");
        this.addZoneId("Pacific/Apia");
        this.addZoneId("Asia/Yerevan");
        this.addZoneId("Pacific/Auckland");
        this.addZoneId("Asia/Karachi");
        this.addZoneId("America/Phoenix");
        this.addZoneId("America/Puerto_Rico");
        this.addZoneId("America/Los_Angeles");
        this.addZoneId("Pacific/Guadalcanal");
        this.addZoneId("Asia/Ho_Chi_Minh");
    }

    public final void addZoneId(String zoneId) {
        if (StringUtils.isBlank(zoneId)) {
            throw new IllegalArgumentException("zoneId can not be blank");
        }
        this.getAvailableZoneIds().add((Object)zoneId);
    }

    public final void addResolution(Resolution<T> resolution) {
        Objects.requireNonNull(resolution);
        this.resolutions.add(resolution);
        T temporalUnit = resolution.getTemporalUnit();
        ObservableList list = (ObservableList)this.resolutionMap.computeIfAbsent(temporalUnit, k -> FXCollections.observableArrayList());
        list.add(resolution);
        if (!this.temporalUnits.contains(temporalUnit)) {
            this.temporalUnits.add(temporalUnit);
        }
    }

    public final void removeResolution(Resolution<? extends T> resolution) {
        Objects.requireNonNull(resolution);
        this.resolutions.remove(resolution);
        T temporalUnit = resolution.getTemporalUnit();
        ObservableList list = (ObservableList)this.resolutionMap.get(temporalUnit);
        if (list != null) {
            list.remove(resolution);
            if (list.isEmpty()) {
                this.resolutionMap.remove(temporalUnit);
            }
        }
    }

    public final void clearResolutions() {
        this.resolutions.clear();
        this.temporalUnits.clear();
        this.resolutionMap.clear();
    }

    public final void clearResolutions(T temporalUnit) {
        this.temporalUnits.remove(temporalUnit);
        ArrayList list = new ArrayList((Collection)this.resolutionMap.get(temporalUnit));
        list.forEach(this::removeResolution);
    }

    public final ObservableList<T> getTemporalUnits() {
        return new ReadOnlyListWrapper(this.temporalUnits);
    }

    public final IntegerProperty scaleCountProperty() {
        return this.scaleCount;
    }

    public final int getScaleCount() {
        return this.scaleCountProperty().get();
    }

    public final void setScaleCount(int count) {
        this.scaleCountProperty().set(count);
    }

    public final IntegerProperty maxScaleCountProperty() {
        return this.maxScaleCount;
    }

    public final int getMaxScaleCount() {
        return this.maxScaleCountProperty().get();
    }

    public final void setMaxScaleCount(int count) {
        this.maxScaleCountProperty().set(count);
    }

    public final IntegerProperty minScaleCountProperty() {
        return this.minScaleCount;
    }

    public final int getMinScaleCount() {
        return this.minScaleCountProperty().get();
    }

    public final void setMinScaleCount(int count) {
        this.minScaleCountProperty().set(count);
    }

    public final ObservableSet<String> getAvailableZoneIds() {
        return this.availableZoneIds;
    }

    public final ObservableList<Resolution<? extends T>> getResolutions() {
        return new ReadOnlyListWrapper(this.resolutions);
    }

    public final Iterator<? extends Resolution<? extends T>> getResolutions(T temporalUnit) {
        List resolutions = (List)this.resolutionMap.get(temporalUnit);
        if (resolutions == null) {
            return Collections.emptyIterator();
        }
        return resolutions.iterator();
    }

    public abstract T nextTemporalUnit(T var1);
}

