/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.calendar;

import com.flexganttfx.model.Layer;
import com.flexganttfx.model.calendar.CalendarBase;
import com.flexganttfx.model.calendar.WeekendCalendarActivity;
import com.flexganttfx.model.repository.RepositoryEvent;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventTarget;

public class WeekendCalendar
extends CalendarBase<WeekendCalendarActivity> {
    private Instant lastStartTime = Instant.MIN;
    private Instant lastEndTime = Instant.MAX;
    private ZoneId lastZoneId;
    private List<WeekendCalendarActivity> entries;
    private EnumSet<DayOfWeek> weekendDays = EnumSet.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);

    public WeekendCalendar() {
        super("Weekends");
    }

    public void setWeekendDays(DayOfWeek ... days) {
        Objects.requireNonNull(days);
        this.weekendDays.clear();
        this.weekendDays.addAll(Arrays.asList(days));
        Event.fireEvent((EventTarget)this, (Event)new RepositoryEvent(this));
    }

    public DayOfWeek[] getWeekendDays() {
        return this.weekendDays.toArray(new DayOfWeek[this.weekendDays.size()]);
    }

    @Override
    public Iterator<WeekendCalendarActivity> getActivities(Layer layer, Instant startTime, Instant endTime, TemporalUnit temporalUnit, ZoneId zoneId) {
        if (!(temporalUnit instanceof ChronoUnit)) {
            return Collections.emptyListIterator();
        }
        if (startTime.equals(this.lastStartTime) && endTime.equals(this.lastEndTime) && zoneId.equals(this.lastZoneId)) {
            if (this.entries != null) {
                return this.entries.iterator();
            }
        } else {
            ChronoUnit unit = (ChronoUnit)temporalUnit;
            if (this.isSupportedUnit(unit)) {
                if (this.entries == null) {
                    this.entries = new ArrayList<WeekendCalendarActivity>();
                } else {
                    this.entries.clear();
                }
                ZonedDateTime st = ZonedDateTime.ofInstant(startTime, zoneId);
                ZonedDateTime et = ZonedDateTime.ofInstant(endTime, zoneId);
                this.findWeekends(st, et);
                this.lastStartTime = startTime;
                this.lastEndTime = endTime;
                this.lastZoneId = zoneId;
                return this.entries.iterator();
            }
        }
        return Collections.emptyListIterator();
    }

    protected boolean isSupportedUnit(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case DAYS: 
                case WEEKS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void findWeekends(ZonedDateTime st, ZonedDateTime et) {
        while (st.isBefore(et) || st.equals(et)) {
            if (this.weekendDays.contains(st.getDayOfWeek())) {
                st = st.truncatedTo(ChronoUnit.DAYS);
                this.entries.add(new WeekendCalendarActivity(st.getDayOfWeek().toString(), Instant.from(st), Instant.from(st.plusDays(1L)), st.getDayOfWeek()));
            }
            st = st.plusDays(1L);
        }
    }
}

