/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.activity;

import com.flexganttfx.model.activity.CompletableActivityBase;
import com.flexganttfx.model.activity.MutableCompletableActivity;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class MutableCompletableActivityBase<T>
extends CompletableActivityBase<T>
implements MutableCompletableActivity {
    public MutableCompletableActivityBase() {
    }

    public MutableCompletableActivityBase(String name) {
        super(name);
    }

    public MutableCompletableActivityBase(Instant startTime, Instant endTime) {
        super(startTime, endTime);
    }

    public MutableCompletableActivityBase(String name, Instant startTime, Instant endTime) {
        super(name, startTime, endTime);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setUserObject(T userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setStartTime(Instant time) {
        Objects.requireNonNull(time);
        this.startTime = time;
    }

    @Override
    public void setEndTime(Instant time) {
        Objects.requireNonNull(time);
        this.endTime = time;
    }

    public void setDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getStartTime().plus(duration));
    }

    public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    public void addDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.addDuration(duration, 1L);
    }

    public void addDuration(Duration duration, long multipliedBy) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getEndTime().plus(duration.multipliedBy(multipliedBy)));
    }

    @Override
    public void setPercentageComplete(double complete) {
        if (complete < 0.0 || complete > 100.0) {
            throw new IllegalArgumentException("percentage complete must be between 0 and 100 but was " + complete);
        }
        this.percentageComplete = complete;
    }
}

