/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.model.activity;

import com.flexganttfx.model.activity.ChartActivityBase;
import com.flexganttfx.model.activity.MutableChartActivity;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class MutableChartActivityBase<T>
extends ChartActivityBase<T>
implements MutableChartActivity {
    public MutableChartActivityBase() {
    }

    public MutableChartActivityBase(double value) {
        super(value);
    }

    public MutableChartActivityBase(double value, Instant time) {
        super(value, time);
    }

    public MutableChartActivityBase(double value, Instant startTime, Instant endTime) {
        super(value, startTime, endTime);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setUserObject(T userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setStartTime(Instant time) {
        Objects.requireNonNull(time);
        this.startTime = time;
    }

    @Override
    public void setEndTime(Instant time) {
        Objects.requireNonNull(time);
        this.endTime = time;
    }

    public void setDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getStartTime().plus(duration));
    }

    public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    public void addDuration(Duration duration) {
        Objects.requireNonNull(duration);
        this.addDuration(duration, 1L);
    }

    public void addDuration(Duration duration, long multipliedBy) {
        Objects.requireNonNull(duration);
        this.setEndTime(this.getEndTime().plus(duration.multipliedBy(multipliedBy)));
    }

    @Override
    public void setChartValue(double value) {
        this.chartValue = value;
    }

    @Override
    public String toString() {
        return super.toString() + ", chart value = " + this.getChartValue();
    }
}

