/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras.properties.layer;

import com.flexganttfx.extras.properties.ItemProvider;
import com.flexganttfx.extras.properties.layer.SystemLayerItemProvider;
import com.flexganttfx.view.graphics.layer.NowLineLayer;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.PropertySheet;

public class NowLineLayerItemProvider
implements ItemProvider<NowLineLayer> {
    @Override
    public List<PropertySheet.Item> getPropertySheetItems(final NowLineLayer layer) {
        SystemLayerItemProvider provider = new SystemLayerItemProvider();
        List<PropertySheet.Item> items = provider.getPropertySheetItems(layer);
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(layer.strokeProperty());
            }

            @Override
            public void setValue(Object value) {
                layer.setStroke((Paint)((Color)value));
            }

            @Override
            public Object getValue() {
                return layer.getStroke();
            }

            @Override
            public Class<?> getType() {
                return Color.class;
            }

            @Override
            public String getName() {
                return "Stroke";
            }

            @Override
            public String getDescription() {
                return "The color used for the now line";
            }

            @Override
            public String getCategory() {
                return "System Layer: " + layer.getName();
            }
        });
        items.add(new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(layer.lineWidthProperty());
            }

            @Override
            public void setValue(Object value) {
                layer.setLineWidth((Double)value);
            }

            @Override
            public Object getValue() {
                return layer.getLineWidth();
            }

            @Override
            public Class<?> getType() {
                return Double.class;
            }

            @Override
            public String getName() {
                return "Line Width";
            }

            @Override
            public String getDescription() {
                return "The width of the now line";
            }

            @Override
            public String getCategory() {
                return "System Layer: " + layer.getName();
            }
        });
        return items;
    }
}

