/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras;

import com.flexganttfx.extras.util.Messages;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.view.util.FlexGanttFXControl;
import impl.com.flexganttfx.extras.skin.VirtualGridControlSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;

public class VirtualGridControl
extends FlexGanttFXControl {
    private final StringProperty noGridText = new SimpleStringProperty((Object)this, "noGridText", Messages.getString("VirtualGridControl.NO_GRID"));
    private final BooleanProperty showNoGridOption = new SimpleBooleanProperty((Object)this, "showNoGridOption", true);
    private final ObjectProperty<VirtualGrid<?>> value = new SimpleObjectProperty((Object)this, "value");
    private ObservableList<VirtualGrid<?>> grids = FXCollections.observableArrayList();

    public VirtualGridControl() {
        this.getStyleClass().add((Object)"virtual-grid-control");
    }

    protected Skin<?> createDefaultSkin() {
        return new VirtualGridControlSkin(this);
    }

    public String getUserAgentStylesheet() {
        return super.getUserAgentStylesheet(VirtualGridControl.class, "virtualgrid.css");
    }

    public final StringProperty noGridTextProperty() {
        return this.noGridText;
    }

    public final void setNoGridText(String text) {
        Objects.requireNonNull(text);
        this.noGridText.set((Object)text);
    }

    public final String getNoGridText() {
        return (String)this.noGridText.get();
    }

    public final BooleanProperty showNoGridOptionProperty() {
        return this.showNoGridOption;
    }

    public final boolean isShowNoGridOption() {
        return this.showNoGridOption.get();
    }

    public final void setShowNoGridOption(boolean show) {
        this.showNoGridOption.set(show);
    }

    public final ObjectProperty<VirtualGrid<?>> valueProperty() {
        return this.value;
    }

    public final VirtualGrid<?> getValue() {
        return (VirtualGrid)this.valueProperty().get();
    }

    public final void setValue(VirtualGrid<?> grid) {
        this.valueProperty().set(grid);
    }

    public final ObservableList<VirtualGrid<?>> getGrids() {
        return this.grids;
    }
}

