/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.extras;

import com.flexganttfx.extras.util.Messages;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.dateline.VirtualGrid;
import com.flexganttfx.view.GanttChartBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import java.text.MessageFormat;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Label;
import org.controlsfx.control.StatusBar;

public class GanttChartStatusBar<R extends Row<?, ?, ?>>
extends StatusBar {
    private Label gridLabel;
    private final InvalidationListener focusedActivityListener = observable -> {
        ListViewGraphics<R> graphicsView = this.getGanttChart().getGraphics();
        ActivityRef<?> focusedActivity = graphicsView.getHoverActivity();
        if (focusedActivity != null) {
            Object activity = focusedActivity.getActivity();
            this.setText(activity.getName());
        }
    };
    private WeakInvalidationListener weakFocusedActivityListener = new WeakInvalidationListener(this.focusedActivityListener);
    private final InvalidationListener virtualGridListener = observable -> this.updateGridLabel();
    private final WeakInvalidationListener weakVirtualGridListener = new WeakInvalidationListener(this.virtualGridListener);
    private final ObjectProperty<GanttChartBase<R>> ganttChart = new SimpleObjectProperty((Object)this, "ganttChart");

    public GanttChartStatusBar() {
        this.getStylesheets().add((Object)GanttChartStatusBar.class.getResource("statusbar.css").toExternalForm());
        this.getStyleClass().add((Object)"gantt-chart-status-bar");
        this.gridLabel = new Label();
        this.gridLabel.getStyleClass().add((Object)"grid-label");
        this.getRightItems().add((Object)this.gridLabel);
        this.updateGridLabel();
        this.ganttChartProperty().addListener((observable, oldValue, newValue) -> {
            ListViewGraphics graphicsView;
            if (oldValue != null) {
                graphicsView = oldValue.getGraphics();
                graphicsView.hoverActivityProperty().removeListener((InvalidationListener)this.weakFocusedActivityListener);
                graphicsView.virtualGridProperty().removeListener((InvalidationListener)this.weakVirtualGridListener);
            }
            if (newValue != null) {
                graphicsView = newValue.getGraphics();
                graphicsView.hoverActivityProperty().addListener((InvalidationListener)this.weakFocusedActivityListener);
                graphicsView.virtualGridProperty().addListener((InvalidationListener)this.weakVirtualGridListener);
            }
            this.updateGridLabel();
        });
    }

    public GanttChartStatusBar(GanttChartBase<R> ganttChart) {
        this();
        this.setGanttChart(ganttChart);
    }

    private void updateGridLabel() {
        GanttChartBase<R> gc = this.getGanttChart();
        if (gc == null) {
            return;
        }
        ListViewGraphics<R> graphicsView = gc.getGraphics();
        VirtualGrid<?> grid = graphicsView.getVirtualGrid();
        if (grid != null) {
            this.gridLabel.setText(MessageFormat.format(Messages.getString("GanttChartStatusBar.MESSAGE_GRID_NAME"), grid.getName()));
        } else {
            this.gridLabel.setText(Messages.getString("GanttChartStatusBar.MESSAGE_GRID_OFF"));
        }
    }

    public final ObjectProperty<GanttChartBase<R>> ganttChartProperty() {
        return this.ganttChart;
    }

    public final GanttChartBase<R> getGanttChart() {
        return (GanttChartBase)((Object)this.ganttChartProperty().get());
    }

    public final void setGanttChart(GanttChartBase<R> ganttChart) {
        Objects.requireNonNull(ganttChart);
        this.ganttChartProperty().set(ganttChart);
    }
}

