/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.Lens;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.VBoxGraphics;
import com.flexganttfx.view.timeline.Timeline;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;

public class LensSkin<R extends Row<?, ?, ?>>
extends SkinBase<Lens<R>> {
    private VBoxGraphics<R> graphics;
    private Timeline timeline;

    public LensSkin(Lens<R> lens) {
        super(lens);
        InvalidationListener updateListener = it -> this.updateView();
        lens.startIndexProperty().addListener(updateListener);
        lens.getRows().addListener(updateListener);
        this.timeline = new Timeline();
        this.timeline.setModel(lens.getGraphics().getTimeline().getModel());
        this.graphics = new VBoxGraphics();
        this.graphics.setTimeline(this.timeline);
        this.graphics.setPriorityCallback(row -> Priority.NEVER);
        Bindings.bindContent(this.graphics.getLayers(), lens.getGraphics().getLayers());
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)this.timeline);
        borderPane.setCenter(this.graphics);
        this.getChildren().add((Object)borderPane);
        this.updateView();
    }

    private void updateView() {
        int index;
        ObservableList rows = ((Lens)this.getSkinnable()).getRows();
        int startIndex = ((Lens)this.getSkinnable()).getStartIndex();
        ArrayList<Row> result = new ArrayList<Row>();
        for (int i = 0; i < ((Lens)this.getSkinnable()).getRowCount() && (index = startIndex + i) < rows.size(); ++i) {
            Row row = (Row)rows.get(index);
            row.getProperties().put((Object)"com.flexganttfx.row.showing", (Object)true);
            result.add(row);
        }
        this.graphics.getRows().setAll(result);
    }
}

