/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.LensSkin;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class Lens<R extends Row<?, ?, ?>>
extends Control {
    private GraphicsBase<R> graphics;
    private final ObservableList<R> rows = FXCollections.observableArrayList();
    private final IntegerProperty startIndex = new SimpleIntegerProperty((Object)this, "startIndex", 0);
    private final IntegerProperty rowCount = new SimpleIntegerProperty((Object)this, "rowCount", 4);

    public Lens(GraphicsBase<R> graphics) {
        this.graphics = Objects.requireNonNull(graphics);
        this.getStyleClass().add((Object)"graphics-lens");
        this.prefWidthProperty().bind((ObservableValue)graphics.widthProperty());
    }

    protected Skin<?> createDefaultSkin() {
        return new LensSkin(this);
    }

    public GraphicsBase<R> getGraphics() {
        return this.graphics;
    }

    public final ObservableList<R> getRows() {
        return this.rows;
    }

    public final IntegerProperty startIndexProperty() {
        return this.startIndex;
    }

    public final void setStartIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be >= 0 but was " + index);
        }
        this.startIndexProperty().set(index);
    }

    public final int getStartIndex() {
        return this.startIndexProperty().get();
    }

    public final IntegerProperty rowCountProperty() {
        return this.rowCount;
    }

    public final void setRowCount(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("row count must be larger than 0 but was " + count);
        }
        this.rowCountProperty().set(count);
    }

    public final int getRowCount() {
        return this.rowCountProperty().get();
    }
}

