/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.DateSlider;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javafx.beans.InvalidationListener;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class DateSliderSkin
extends SkinBase<DateSlider> {
    private Slider slider = new Slider();
    private Label earliestLabel = new Label();
    private Label latestLabel;
    private Tooltip tooltip;
    boolean updatingDate;

    public DateSliderSkin(DateSlider control) {
        super((Control)control);
        this.earliestLabel.getStyleClass().add((Object)"earliest-date-label");
        this.latestLabel = new Label();
        this.latestLabel.getStyleClass().add((Object)"latest-date-label");
        this.tooltip = new Tooltip("Hello World");
        this.tooltip.getStyleClass().add((Object)"date-tooltip");
        InvalidationListener updateListener = it -> this.updateSliderMaxValue();
        control.earliestDateProperty().addListener(updateListener);
        control.latestDateProperty().addListener(updateListener);
        control.dateProperty().addListener(it -> this.updateSliderValue());
        control.dateTimeFormatterProperty().addListener(it -> this.updateLabels());
        this.updateSliderMaxValue();
        this.updateSliderValue();
        this.updateLabels();
        this.slider.valueProperty().addListener(it -> this.updateDate());
        HBox box = new HBox(10.0);
        box.setFillHeight(true);
        box.setAlignment(Pos.CENTER);
        box.getChildren().addAll((Object[])new Node[]{this.earliestLabel, this.slider, this.latestLabel});
        HBox.setHgrow((Node)this.earliestLabel, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.slider, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.latestLabel, (Priority)Priority.NEVER);
        this.slider.setTooltip(this.tooltip);
        this.slider.setOnMousePressed(evt -> {
            this.updateToolTipLocation();
            this.tooltip.show(this.slider.getScene().getWindow());
        });
        this.slider.setOnMouseDragged(evt -> this.updateToolTipLocation());
        this.slider.setOnMouseReleased(evt -> this.tooltip.hide());
        this.getChildren().add((Object)box);
    }

    private void updateToolTipLocation() {
        Region thumb = this.getThumb();
        Point2D point2D = thumb.localToScreen(0.0, 0.0);
        this.tooltip.setAnchorX(point2D.getX() + thumb.getWidth() / 2.0);
        this.tooltip.setAnchorY(point2D.getY() + thumb.getHeight() + 4.0);
    }

    private Region getThumb() {
        return (Region)this.slider.lookup(".thumb");
    }

    private void updateLabels() {
        this.earliestLabel.setText(((DateSlider)this.getSkinnable()).getDateTimeFormatter().format(((DateSlider)this.getSkinnable()).getEarliestDate()));
        this.latestLabel.setText(((DateSlider)this.getSkinnable()).getDateTimeFormatter().format(((DateSlider)this.getSkinnable()).getLatestDate()));
    }

    private void updateDate() {
        this.updatingDate = true;
        DateSlider control = (DateSlider)this.getSkinnable();
        LocalDate date = control.getEarliestDate().plusDays((long)this.slider.getValue());
        control.getProperties().put((Object)"flexganttfx.dateslider.date", (Object)date);
        this.tooltip.setText(control.getDateTimeFormatter().format(date));
        this.updatingDate = false;
    }

    private void updateSliderValue() {
        if (!this.updatingDate) {
            DateSlider control = (DateSlider)this.getSkinnable();
            long days = ChronoUnit.DAYS.between(control.getEarliestDate(), control.getDate());
            this.slider.setValue((double)days);
        }
    }

    private void updateSliderMaxValue() {
        DateSlider control = (DateSlider)this.getSkinnable();
        long days = ChronoUnit.DAYS.between(control.getEarliestDate(), control.getLatestDate());
        this.slider.setMax((double)days);
    }
}

