/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.DateSliderSkin;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class DateSlider
extends Control {
    private final ObjectProperty<DateTimeFormatter> dateTimeFormatter = new SimpleObjectProperty((Object)this, "dateTimeFormatter", (Object)DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
    private final ObjectProperty<LocalDate> earliestDate = new SimpleObjectProperty((Object)this, "earliestDate", (Object)LocalDate.now().minusMonths(1L));
    private final ObjectProperty<LocalDate> latestDate = new SimpleObjectProperty((Object)this, "latestDate", (Object)LocalDate.now().plusMonths(1L));
    private final ReadOnlyObjectWrapper<LocalDate> date = new ReadOnlyObjectWrapper((Object)this, "date", (Object)LocalDate.now());

    public DateSlider() {
        this.getStyleClass().add((Object)"date-slider");
        MapChangeListener listener = change -> {
            Object key;
            if (change.wasAdded() && (key = change.getKey()).equals("flexganttfx.dateslider.date")) {
                LocalDate value = (LocalDate)change.getValueAdded();
                this.date.set((Object)value);
            }
        };
        this.getProperties().addListener(listener);
    }

    protected Skin<?> createDefaultSkin() {
        return new DateSliderSkin(this);
    }

    public String getUserAgentStylesheet() {
        return DateSlider.class.getResource("date-slider.css").toExternalForm();
    }

    public final ObjectProperty<DateTimeFormatter> dateTimeFormatterProperty() {
        return this.dateTimeFormatter;
    }

    public final DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.dateTimeFormatter.get();
    }

    public final void setDateTimeFormatter(DateTimeFormatter value) {
        this.dateTimeFormatter.set((Object)value);
    }

    public final ObjectProperty<LocalDate> earliestDateProperty() {
        return this.earliestDate;
    }

    public final LocalDate getEarliestDate() {
        return (LocalDate)this.earliestDate.get();
    }

    public final void setEarliestDate(LocalDate value) {
        this.earliestDate.set((Object)value);
    }

    public final ObjectProperty<LocalDate> latestDateProperty() {
        return this.latestDate;
    }

    public final LocalDate getLatestDate() {
        return (LocalDate)this.latestDate.get();
    }

    public final void setLatestDate(LocalDate value) {
        this.latestDate.set((Object)value);
    }

    public final ReadOnlyObjectProperty<LocalDate> dateProperty() {
        return this.date.getReadOnlyProperty();
    }

    public final LocalDate getDate() {
        return (LocalDate)this.date.get();
    }
}

