/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.experimental;

import com.flexganttfx.experimental.ColumnBrowser;
import com.flexganttfx.experimental.ColumnValuesList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;

public class ColumnValuesListSkin<S, T>
extends SkinBase<ColumnValuesList<S, T>> {
    private Label label;
    private ChangeListener<TableView<S>> tableChangedListener = new ChangeListener<TableView<S>>(){

        public void changed(ObservableValue<? extends TableView<S>> observable, TableView<S> oldTable, TableView<S> newTable) {
            ColumnValuesListSkin.this.removeFromTable(oldTable);
            ColumnValuesListSkin.this.attachToTable(newTable);
        }
    };
    private InvalidationListener itemsChangedListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            ColumnValuesListSkin.this.updateListValues();
        }
    };

    public ColumnValuesListSkin(ColumnValuesList<S, T> valuesList) {
        super(valuesList);
        this.label = new Label();
        this.label.getStyleClass().add((Object)"list-header");
        ListView listView = valuesList.getListView();
        this.label.setOnMouseClicked(evt -> listView.getSelectionModel().clearSelection());
        this.label.setMinWidth(0.0);
        this.label.setMaxWidth(Double.MAX_VALUE);
        listView.setMinSize(0.0, 0.0);
        listView.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)this.label);
        borderPane.setCenter(listView);
        TableColumn<S, T> column = valuesList.getColumn();
        column.textProperty().addListener(evt -> this.updateLabelText());
        TableView tableView = column.getTableView();
        if (tableView != null) {
            this.attachToTable(tableView);
        }
        column.tableViewProperty().addListener(this.tableChangedListener);
        this.updateLabelText();
        this.updateListValues();
        this.getChildren().add((Object)borderPane);
    }

    private void removeFromTable(TableView<S> tableView) {
        if (tableView != null) {
            tableView.getItems().removeListener(this.itemsChangedListener);
        }
    }

    private void attachToTable(TableView<S> tableView) {
        if (tableView != null) {
            tableView.getItems().addListener(this.itemsChangedListener);
        }
    }

    private void updateLabelText() {
        ColumnValuesList browserList = (ColumnValuesList)this.getSkinnable();
        TableColumn column = browserList.getColumn();
        this.label.setText(column.getText());
    }

    private List<T> sort(Set<T> items) {
        ColumnValuesList browserList = (ColumnValuesList)this.getSkinnable();
        TableColumn column = browserList.getColumn();
        Comparator comparator = column.getComparator();
        ArrayList<T> l = new ArrayList<T>(items);
        l.sort(comparator);
        return l;
    }

    private void updateListValues() {
        ColumnValuesList valuesList = (ColumnValuesList)this.getSkinnable();
        TableColumn column = valuesList.getColumn();
        TableView table = column.getTableView();
        ColumnBrowser columnBrowser = valuesList.getColumnBrowser();
        ObservableList items = columnBrowser.getItems();
        ColumnValuesList parentValuesList = columnBrowser.getParentValuesList(valuesList);
        HashSet<Object> newSet = new HashSet<Object>();
        for (Object value : items) {
            Callback valueFactory;
            ObservableValue result;
            if (!this.isIncludedByParentValueLists(columnBrowser, parentValuesList, value) || (result = (ObservableValue)(valueFactory = column.getCellValueFactory()).call((Object)new TableColumn.CellDataFeatures(table, column, value))) == null || result.getValue() == null) continue;
            newSet.add(result.getValue());
        }
        ListView listView = valuesList.getListView();
        List newList = this.sort(newSet);
        ObservableList oldList = listView.getItems();
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (newList.contains(item)) continue;
            iter.remove();
        }
        for (Object item : newList) {
            if (oldList.contains(item)) continue;
            oldList.add(item);
        }
    }

    private boolean isIncludedByParentValueLists(ColumnBrowser<S> columnBrowser, ColumnValuesList<S, ?> parentValuesList, S value) {
        while (parentValuesList != null) {
            Predicate<S> predicate = parentValuesList.getPredicate();
            if (!predicate.test(value)) {
                return false;
            }
            parentValuesList = columnBrowser.getParentValuesList(parentValuesList);
        }
        return true;
    }
}

