/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.view;

import com.flexganttfx.emirates.model.Group;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.layer.SystemLayer;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import java.time.Instant;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

public class NameLayer<R extends Row<?, ?, ?>>
extends SystemLayer<R> {
    private Color backgroundColor = Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5);
    private Color foregroundColor = Color.WHITE;

    public NameLayer(GraphicsBase graphics) {
        super("Name Layer", graphics);
    }

    @Override
    public void drawLayer(RowCanvas<R> canvas, Instant startTime, Instant endTime) {
        R row = canvas.getRow();
        if (row != null && !(row instanceof Group)) {
            String name = ((Row)row).getName();
            GraphicsContext gc = canvas.getGraphicsContext2D();
            double textWidth = 80.0;
            double textHeight = 20.0;
            gc.setTextAlign(TextAlignment.LEFT);
            gc.setTextBaseline(VPos.BOTTOM);
            gc.setFill((Paint)this.backgroundColor);
            gc.fillRect(0.0, 0.0, textWidth + 4.0, textHeight);
            gc.setFill((Paint)this.foregroundColor);
            gc.fillText(name, 2.0, textHeight);
        }
    }
}

