/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.view;

import com.flexganttfx.core.FlexGanttFX;
import com.flexganttfx.emirates.EmiratesApp;
import com.flexganttfx.emirates.model.DataModel;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class IntroPane
extends VBox {
    public IntroPane(EmiratesApp app) {
        this.getStyleClass().add((Object)"intro-pane");
        Label emiratesLogo = new Label();
        emiratesLogo.setGraphic((Node)new ImageView(EmiratesApp.class.getResource("logo-emirates.gif").toExternalForm()));
        emiratesLogo.getStyleClass().add((Object)"emirates-logo");
        emiratesLogo.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        emiratesLogo.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)emiratesLogo, (Priority)Priority.ALWAYS);
        Label dlscLogo = new Label();
        dlscLogo.getStyleClass().add((Object)"dlsc-logo");
        dlscLogo.setMaxWidth(Double.MAX_VALUE);
        dlscLogo.setGraphic((Node)new ImageView(EmiratesApp.class.getResource("logo-dlsc.png").toExternalForm()));
        dlscLogo.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        dlscLogo.setAlignment(Pos.CENTER_RIGHT);
        HBox headerBox = new HBox();
        headerBox.getStyleClass().add((Object)"logo-header");
        headerBox.getChildren().add((Object)emiratesLogo);
        headerBox.getChildren().add((Object)dlscLogo);
        this.getChildren().add((Object)headerBox);
        VBox innerBox = new VBox();
        innerBox.getStyleClass().add((Object)"inner-box");
        VBox.setVgrow((Node)innerBox, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)innerBox);
        Label title = new Label("FlexGanttFX " + FlexGanttFX.getVersion());
        title.getStyleClass().add((Object)"demo-title");
        title.setContentDisplay(ContentDisplay.RIGHT);
        innerBox.getChildren().add((Object)title);
        Label subtitle = new Label("Proof of Concept, March 2014");
        subtitle.getStyleClass().add((Object)"demo-subtitle");
        subtitle.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        subtitle.setAlignment(Pos.TOP_LEFT);
        innerBox.getChildren().add((Object)subtitle);
        VBox.setVgrow((Node)subtitle, (Priority)Priority.ALWAYS);
        HBox buttonBox = new HBox();
        Label label = new Label();
        label.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().add((Object)label);
        buttonBox.getStyleClass().add((Object)"button-box");
        block5: for (DataModel.DataSet dataSet : DataModel.DataSet.values()) {
            Button button = new Button(dataSet.getDisplayName());
            button.setOnAction(event -> {
                button.setDisable(true);
                button.setCursor(Cursor.WAIT);
                this.setCursor(Cursor.WAIT);
                Platform.runLater(() -> app.load(dataSet));
            });
            button.setMaxHeight(Double.MAX_VALUE);
            button.setAlignment(Pos.BOTTOM_RIGHT);
            button.setContentDisplay(ContentDisplay.TOP);
            buttonBox.setFillHeight(true);
            buttonBox.getChildren().add((Object)button);
            switch (dataSet) {
                case LARGE: {
                    button.getStyleClass().add((Object)"data-set-large");
                    continue block5;
                }
                case MEDIUM: {
                    button.getStyleClass().add((Object)"data-set-medium");
                    continue block5;
                }
                case SMALL: {
                    button.getStyleClass().add((Object)"data-set-small");
                    continue block5;
                }
            }
        }
        innerBox.getChildren().add((Object)buttonBox);
        this.setEffect((Effect)new DropShadow(20.0, Color.GRAY));
    }
}

