/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.view;

import com.flexganttfx.emirates.model.Flight;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityBarRenderer;
import com.flexganttfx.view.util.Position;
import java.util.EnumMap;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FlightRenderer
extends ActivityBarRenderer<Flight> {
    private EnumMap<Flight.ServiceType, Color> servicePaintMap = new EnumMap(Flight.ServiceType.class);

    public FlightRenderer(GraphicsBase<?> graphics) {
        super(graphics, "Flight");
        this.servicePaintMap.put(Flight.ServiceType.E, Color.ALICEBLUE);
        this.servicePaintMap.put(Flight.ServiceType.J, Color.BURLYWOOD);
        this.servicePaintMap.put(Flight.ServiceType.N, Color.BLANCHEDALMOND);
        this.servicePaintMap.put(Flight.ServiceType.Y, Color.CORNSILK);
        this.servicePaintMap.put(Flight.ServiceType.Z, Color.CRIMSON);
        this.setCornersRounded(false);
    }

    @Override
    public ActivityBounds drawActivity(ActivityRef<Flight> activityRef, Position position, GraphicsContext gc, double x, double y, double w, double h, boolean selected, boolean hover, boolean highlighted, boolean pressed) {
        Color color = this.servicePaintMap.get((Object)activityRef.getActivity().getServiceType());
        this.setFill((Paint)color);
        this.setStroke((Paint)color.darker());
        ActivityBounds bounds = super.drawActivity(activityRef, position, gc, x, y, w, h, selected, hover, highlighted, pressed);
        Flight flight = activityRef.getActivity();
        this.drawText(activityRef, flight.getFlightNo(), ActivityBarRenderer.TextPosition.CENTER, gc, x, y, w, h, selected, hover, highlighted, pressed);
        if (h >= 40.0) {
            this.drawText(activityRef, flight.getServiceType().toString(), ActivityBarRenderer.TextPosition.ABOVE_LEFT, gc, x, y, w, h, selected, hover, highlighted, pressed);
            if (w >= 50.0) {
                this.drawText(activityRef, flight.getDepartureAirport(), ActivityBarRenderer.TextPosition.BELOW_LEFT, gc, x, y, w, h, selected, hover, highlighted, pressed);
                this.drawText(activityRef, flight.getArrivalAirport(), ActivityBarRenderer.TextPosition.BELOW_RIGHT, gc, x, y, w, h, selected, hover, highlighted, pressed);
            }
        }
        return bounds;
    }
}

