/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.view;

import com.flexganttfx.emirates.map.MapComponent;
import com.flexganttfx.emirates.model.Aircraft;
import com.flexganttfx.emirates.model.Flight;
import com.flexganttfx.emirates.model.Group;
import com.flexganttfx.emirates.model.ModelObject;
import com.flexganttfx.emirates.view.FlightRenderer;
import com.flexganttfx.emirates.view.GroupSystemLayer;
import com.flexganttfx.emirates.view.NameLayer;
import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.layout.GanttLayout;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.GanttChartLite;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.ActivityEvent;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.ListViewGraphics;
import com.flexganttfx.view.timeline.Timeline;
import impl.com.flexganttfx.skin.graphics.DragCanvas;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.controlsfx.control.PopOver;

public class EmiratesAircraftGanttChart
extends GanttChartLite<ModelObject<?, ?, ?>> {
    private VBox detail;
    private PopOver popOver;
    private MapComponent mapComponent = new MapComponent();

    public EmiratesAircraftGanttChart() {
        Timeline timeline = this.getTimeline();
        timeline.showTemporalUnit(ChronoUnit.HOURS, 50.0);
        timeline.setMoveAnimated(false);
        timeline.setZoomAnimated(false);
        this.getGraphics().getBackgroundSystemLayers().add((Object)new GroupSystemLayer(this.getGraphics()));
        this.getGraphics().setActivityRenderer(Flight.class, GanttLayout.class, new FlightRenderer(this.getGraphics()));
        EventHandler<ActivityEvent> updateListener = new EventHandler<ActivityEvent>(){

            public void handle(ActivityEvent event) {
                this.updateRow(event.getActivityRef().getRow());
                this.updateRow(event.getOldRow());
            }

            private void updateRow(Row<?, ?, ?> row) {
                if (row != null && row instanceof Aircraft) {
                    Aircraft aircraft = (Aircraft)row;
                    aircraft.updateInnerLines();
                    Group group = (Group)row.getParent();
                    ObservableList<Layer> layers = EmiratesAircraftGanttChart.this.getLayers();
                    Instant st = aircraft.getEarliestTimeUsed();
                    Instant et = aircraft.getLatestTimeUsed();
                    group.updateUsageProfile(new TimeInterval(st, et), (Layer)layers.get(layers.size() - 1), (Collection<Layer>)layers);
                }
            }
        };
        this.getGraphics().addEventHandler(ActivityEvent.START_TIME_CHANGE_FINISHED, (EventHandler)updateListener);
        this.getGraphics().addEventHandler(ActivityEvent.END_TIME_CHANGE_FINISHED, (EventHandler)updateListener);
        this.getGraphics().addEventHandler(ActivityEvent.DRAG_FINISHED, (EventHandler)updateListener);
        this.getGraphics().addEventHandler(ActivityEvent.HORIZONTAL_DRAG_FINISHED, (EventHandler)updateListener);
        this.getGraphics().getForegroundSystemLayers().add(new NameLayer(this.getGraphics()));
        this.getGraphics().setEditModeCallback(Flight.class, GanttLayout.class, (Callback<GraphicsBase.EditModeCallbackParameter, GraphicsBase.EditMode>)((Callback)param -> GraphicsBase.EditMode.DRAGGING_VERTICAL));
        this.getGraphics().setActivityEditingCallback(Flight.class, (Callback<GraphicsBase.EditingCallbackParameter, Boolean>)((Callback)param -> param.getEditMode().equals((Object)GraphicsBase.EditMode.DRAGGING_VERTICAL)));
        this.getGraphics().skinProperty().addListener(it -> {
            GraphicsBaseSkin skin = (GraphicsBaseSkin)this.getGraphics().getSkin();
            DragCanvas canvas = skin.getDragCanvas();
            canvas.setIncludeSelectedActivitiesInDrag(true);
        });
        this.detail = new VBox();
        this.detail.setStyle("-fx-background-color: white;");
        this.detail.setPrefWidth(400.0);
        this.detail.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)this.detail);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        this.setDetail((Node)scrollPane);
        this.setupPopOver();
    }

    private void addToDetail() {
        if (this.mapComponent != null) {
            this.mapComponent.setPreferredSize(new Dimension(200, 200));
            SwingNode swingNode = new SwingNode();
            swingNode.setStyle("-fx-border-color: black; -fx-padding: 10px;");
            swingNode.setContent((JComponent)this.mapComponent);
            VBox.setMargin((Node)swingNode, (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
            this.detail.getChildren().add((Object)swingNode);
            this.popOver = null;
            this.setShowDetail(true);
            Platform.runLater(() -> this.detail.requestLayout());
        }
    }

    private void setupPopOver() {
        ListViewGraphics graphics = this.getGraphics();
        this.getGraphics().addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getSource() != this.getGraphics()) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                ActivityBounds bounds;
                if (this.popOver == null || this.popOver.isDetached()) {
                    this.popOver = new PopOver();
                    this.popOver.setArrowLocation(PopOver.ArrowLocation.LEFT_TOP);
                    BorderPane wrapper = new BorderPane();
                    wrapper.setStyle("-fx-padding: 20;");
                    this.mapComponent = new MapComponent();
                    this.mapComponent.setBorder(new LineBorder(Color.BLACK));
                    this.mapComponent.setPreferredSize(new Dimension(600, 400));
                    SwingNode swingNode = new SwingNode();
                    swingNode.setStyle("-fx-border-color: black;");
                    swingNode.setContent((JComponent)this.mapComponent);
                    wrapper.setCenter((Node)swingNode);
                    Button detailButton = new Button("Add");
                    detailButton.setOnAction(actionEvent -> {
                        this.popOver.hide();
                        this.addToDetail();
                    });
                    HBox.setMargin((Node)detailButton, (Insets)new Insets(5.0));
                    HBox hbox = new HBox();
                    hbox.getChildren().add((Object)detailButton);
                    hbox.setAlignment(Pos.CENTER_RIGHT);
                    wrapper.setBottom((Node)hbox);
                    this.popOver.setContentNode((Node)wrapper);
                }
                if ((bounds = graphics.getActivityBoundsAt(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    Flight flight = (Flight)bounds.getActivity();
                    ArrayList<Flight> shownFlights = new ArrayList<Flight>();
                    shownFlights.add(flight);
                    for (ActivityRef activityRef : this.getGraphics().getSelectedActivities()) {
                        shownFlights.add((Flight)activityRef.getActivity());
                    }
                    SwingUtilities.invokeLater(() -> this.mapComponent.display(shownFlights));
                }
                this.popOver.show((Node)this.getGraphics(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            } else if (this.popOver != null && !this.popOver.isDetached()) {
                this.popOver.hide();
            }
        });
    }
}

