/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.model;

import com.flexganttfx.emirates.model.Aircraft;
import com.flexganttfx.emirates.model.ModelObject;
import com.flexganttfx.model.Layer;
import com.flexganttfx.model.activity.ChartActivity;
import com.flexganttfx.model.activity.MutableChartActivityBase;
import com.flexganttfx.model.layout.ChartLayout;
import com.flexganttfx.model.repository.IntervalTreeActivityRepository;
import com.flexganttfx.model.util.TimeInterval;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;

public class Group
extends ModelObject<Group, Aircraft, ChartActivity> {
    private ChartLayout layout = new ChartLayout();

    public Group(String name) {
        this.setName(name);
        this.setLayout(this.layout);
        this.setHeight(10.0);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group g = (Group)obj;
        return this.getName().equals(g.getName());
    }

    public int getMaximumNumberOfDesiredFlights() {
        return this.getChildren().size() * 4;
    }

    public int getMinimumNumberOfDesiredFlights() {
        return this.getChildren().size() * 2;
    }

    public void updateUsageProfile(TimeInterval horizon, Layer capacityLayer, Collection<Layer> layers) {
        IntervalTreeActivityRepository repository = (IntervalTreeActivityRepository)this.getRepository();
        repository.clearActivities();
        ZonedDateTime dayStartTime = ZonedDateTime.ofInstant(horizon.getStartTime(), this.getZoneId()).truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime dayEndTime = ZonedDateTime.ofInstant(horizon.getStartTime(), this.getZoneId()).truncatedTo(ChronoUnit.DAYS).plusDays(1L);
        int maximumNumberOfFlights = 0;
        ZonedDateTime stopTime = ZonedDateTime.ofInstant(horizon.getEndTime(), this.getZoneId());
        do {
            int numberOfFlights = this.calculateNumberOfFlights(dayStartTime, dayEndTime, layers);
            maximumNumberOfFlights = Math.max(maximumNumberOfFlights, numberOfFlights);
            if (numberOfFlights <= 0) continue;
            MutableChartActivityBase capacity = new MutableChartActivityBase();
            capacity.setChartValue(numberOfFlights);
            capacity.setStartTime(Instant.from(dayStartTime));
            capacity.setEndTime(Instant.from(dayEndTime));
            this.addActivity(capacityLayer, capacity);
        } while ((dayEndTime = (dayStartTime = dayStartTime.plusDays(1L)).plusDays(1L)).isBefore(stopTime));
        this.layout.setMinValue(0.0);
        this.layout.setMaxValue((double)this.getMaximumNumberOfDesiredFlights() * 1.5);
        this.layout.getMajorTicks().clear();
        this.layout.getMinorTicks().clear();
        this.layout.getMajorTicks().add((Object)new Double(this.getMinimumNumberOfDesiredFlights()));
        this.layout.getMajorTicks().add((Object)new Double(this.getMaximumNumberOfDesiredFlights()));
    }

    private int calculateNumberOfFlights(ZonedDateTime start, ZonedDateTime end, Collection<Layer> layers) {
        int numberOfFlights = 0;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Aircraft child;
            Aircraft aircraft = child = (Aircraft)iterator.next();
            for (Layer layer : layers) {
                Iterator iter = aircraft.getRepository().getActivities(layer, Instant.from(start), Instant.from(end), ChronoUnit.DAYS, this.getZoneId());
                while (iter.hasNext()) {
                    ++numberOfFlights;
                    iter.next();
                }
            }
        }
        return numberOfFlights;
    }
}

