/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.model;

import com.flexganttfx.emirates.model.ROW;
import com.flexganttfx.model.activity.MutableActivityBase;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Flight
extends MutableActivityBase<String> {
    private static final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final DateFormat timeFormat = new SimpleDateFormat("HHmm");
    private static final Calendar dateCalendar = Calendar.getInstance();
    private static final Calendar timeCalendar = Calendar.getInstance();
    public static final Set<String> serviceTypes = new HashSet<String>();
    private String departureAirport;
    private String arrivalAirport;
    private String flightNo;
    private String aircraft;
    private ServiceType serviceType = ServiceType.E;
    private boolean invalid;
    private int lineIndex = -1;

    public Flight(ROW row) {
        super(row.getFLIGHTNO());
        try {
            Date departureDate = dateFormat.parse(row.getORIGINDATE());
            Date departureTime = timeFormat.parse(Short.toString(row.getSTANDARDDEPTIME()));
            Date arrivalDate = dateFormat.parse(row.getARRIVALDATE());
            Date arrivalTime = timeFormat.parse(Short.toString(row.getSTANDARDARRIVALTIME()));
            departureDate = this.createCompleteDate(departureDate, departureTime);
            arrivalDate = this.createCompleteDate(arrivalDate, arrivalTime);
            this.setStartTime(departureDate.toInstant());
            this.setDuration(Duration.between(departureDate.toInstant(), arrivalDate.toInstant()));
            String st = row.getSERVICETYPE();
            serviceTypes.add(st);
            this.serviceType = ServiceType.valueOf(st);
            this.departureAirport = row.getDEPARTURESTATION();
            this.arrivalAirport = row.getARRIVALSTATION();
            this.flightNo = row.getFLIGHTNO();
            this.aircraft = row.getResource();
        }
        catch (ParseException e) {
            this.invalid = true;
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getFlightNo() {
        return this.flightNo;
    }

    public String getDepartureAirport() {
        return this.departureAirport;
    }

    public String getArrivalAirport() {
        return this.arrivalAirport;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    private Date createCompleteDate(Date date, Date time) {
        dateCalendar.setTime(date);
        timeCalendar.setTime(time);
        dateCalendar.set(11, timeCalendar.get(11));
        dateCalendar.set(12, timeCalendar.get(12));
        return dateCalendar.getTime();
    }

    public String getAircraft() {
        return this.aircraft;
    }

    public void setLineIndex(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }

    public static enum ServiceType {
        E,
        N,
        Y,
        J,
        Z;

    }
}

