/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.model;

import com.flexganttfx.emirates.EmiratesApp;
import com.flexganttfx.emirates.model.Aircraft;
import com.flexganttfx.emirates.model.Flight;
import com.flexganttfx.emirates.model.Group;
import com.flexganttfx.emirates.model.ModelObject;
import com.flexganttfx.emirates.model.ROW;
import com.flexganttfx.emirates.model.ROWDATA;
import com.flexganttfx.extras.GanttChartStatusBar;
import com.flexganttfx.model.Layer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class DataModel
extends HashMap<Group, Map<String, Aircraft>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DataModel.class.getName());
    private Instant start;
    private Instant end;
    private Layer capacityLayer = new Layer("Capacity");
    private Map<Flight.ServiceType, Layer> layerMap = new HashMap<Flight.ServiceType, Layer>();
    private GanttChartStatusBar<?> statusBar;
    private List<ModelObject<?, ?, ?>> rows = new ArrayList();

    public DataModel(DataSet dataSet, GanttChartStatusBar<?> statusBar) throws IOException {
        this.statusBar = statusBar;
        switch (dataSet) {
            case SMALL: {
                this.loadDataSet("flights-small.zip", 17785);
                break;
            }
            case MEDIUM: {
                this.loadDataSet("flights-medium.zip", 116423);
                break;
            }
            case LARGE: {
                this.loadDataSet("flights-large.zip", 244373);
            }
        }
        for (String s : Flight.serviceTypes) {
            LOGGER.info("service type: " + s);
        }
        this.keySet().forEach((? super T group) -> {
            this.rows.add((ModelObject<?, ?, ?>)group);
            this.rows.addAll(this.getAircrafts((Group)group));
        });
    }

    public Collection<Layer> getLayers() {
        return this.layerMap.values();
    }

    private void loadDataSet(String zipArchive, int numberOfFlightsInFile) throws IOException {
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(EmiratesApp.class.getResourceAsStream(zipArchive));
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".xml")) continue;
                File file = new File(System.getProperty("user.home"), ze.getName());
                if (!file.exists()) {
                    int size;
                    LOGGER.info("Unzipping " + ze.getName());
                    System.out.println("Extracting data file " + ze.getName() + " into your home directory.<br>This might take a while");
                    LOGGER.info("Unzipping to " + file.getAbsolutePath());
                    FileOutputStream fout = new FileOutputStream(file);
                    byte[] buffer = new byte[2048];
                    BufferedOutputStream bos = new BufferedOutputStream(fout, buffer.length);
                    while ((size = zin.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, size);
                    }
                    bos.flush();
                    bos.close();
                    zin.closeEntry();
                    fout.close();
                    LOGGER.info("Done unzipping!");
                } else {
                    System.out.println("Data file exists, no need to extract from archive.");
                }
                try {
                    this.unmarshal(new FileReader(file), numberOfFlightsInFile);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                LOGGER.info("returned from unmarshalling");
            }
            LOGGER.info("yahoo");
        }
        catch (Exception e) {
            LOGGER.info("exception");
            e.printStackTrace();
        }
        LOGGER.info("done unzipping and unmarshalling");
    }

    private void unmarshal(FileReader reader, final int numberOfFlightsInFile) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ROWDATA.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        final HashMap flights = new HashMap();
        unmarshaller.setListener(new Unmarshaller.Listener(){
            ZonedDateTime startTime = ZonedDateTime.now();
            int counter = 0;

            public void afterUnmarshal(Object target, Object parent) {
                if (target instanceof ROW) {
                    Aircraft aircraftRow;
                    ROW row = (ROW)target;
                    String resourceName = row.getResource();
                    Group group = new Group(new StringTokenizer(resourceName, "-").nextToken());
                    HashMap<String, Aircraft> aircraftMap = (HashMap<String, Aircraft>)DataModel.this.get(group);
                    if (aircraftMap == null) {
                        aircraftMap = new HashMap<String, Aircraft>();
                        DataModel.this.put(group, aircraftMap);
                    }
                    if ((aircraftRow = (Aircraft)aircraftMap.get(resourceName)) == null) {
                        aircraftRow = new Aircraft(row);
                        aircraftMap.put(resourceName, aircraftRow);
                    }
                    Flight flight = new Flight(row);
                    ArrayList<Flight> flightList = (ArrayList<Flight>)flights.get(resourceName);
                    if (flightList == null) {
                        flightList = new ArrayList<Flight>();
                        flights.put(resourceName, flightList);
                    }
                    if (!flight.isInvalid()) {
                        flightList.add(flight);
                    }
                    Instant startTime = flight.getStartTime();
                    Instant endTime = flight.getStartTime();
                    if (DataModel.this.start == null || Instant.from(startTime).isBefore(DataModel.this.start)) {
                        DataModel.this.start = Instant.from(startTime);
                    }
                    if (DataModel.this.end == null || Instant.from(endTime).isAfter(DataModel.this.end)) {
                        DataModel.this.end = Instant.from(endTime);
                    }
                } else if (target instanceof ROWDATA) {
                    LOGGER.info("done parsing xml file");
                    LOGGER.info("setting start time to " + this.startTime);
                }
                ++this.counter;
                Platform.runLater(() -> DataModel.this.statusBar.setProgress((double)this.counter / (double)numberOfFlightsInFile));
            }
        });
        unmarshaller.unmarshal((Reader)reader);
        reader.close();
        LOGGER.info("horizon: " + this.start + " to " + this.end);
        for (Group group : this.keySet()) {
            Map map = (Map)this.get(group);
            for (Aircraft aircraft : map.values()) {
                LOGGER.info("looking up flights for aircraft " + aircraft.getName());
                List flightList = (List)flights.get(aircraft.getName());
                if (flightList == null) continue;
                for (Flight flight : flightList) {
                    Layer layer = this.layerMap.get((Object)flight.getServiceType());
                    if (layer == null) {
                        layer = new Layer(flight.getServiceType().toString());
                        this.layerMap.put(flight.getServiceType(), layer);
                    }
                    aircraft.addActivity(layer, flight);
                }
                aircraft.updateInnerLines();
            }
        }
        LOGGER.info("done unmarshallling");
    }

    public Set<Group> getGroups() {
        return this.keySet();
    }

    public List<ModelObject<?, ?, ?>> getRows() {
        return this.rows;
    }

    public Collection<Aircraft> getAircrafts(Group group) {
        Map map = (Map)this.get(group);
        return map.values();
    }

    public Instant getStartTime() {
        return this.start;
    }

    public Instant getEndTime() {
        return this.end;
    }

    public Layer getCapacityLayer() {
        return this.capacityLayer;
    }

    public static enum DataSet {
        SMALL("Small Data Set"),
        MEDIUM("Medium Data Set"),
        LARGE("Large Data Set");

        private String displayName;

        private DataSet(String name) {
            this.displayName = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

