/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.model;

import com.flexganttfx.emirates.model.AircraftLineManager;
import com.flexganttfx.emirates.model.Flight;
import com.flexganttfx.emirates.model.Group;
import com.flexganttfx.emirates.model.ModelObject;
import com.flexganttfx.emirates.model.ROW;
import com.flexganttfx.model.Row;
import com.flexganttfx.model.repository.IntervalTreeActivityRepository;
import com.flexganttfx.model.util.ActivityHelper;
import java.util.List;

public class Aircraft
extends ModelObject<Group, Row<?, ?, ?>, Flight> {
    public Aircraft(ROW row) {
        this.setName(row != null ? row.getResource() : "ROOT");
        this.setLinesManager(new AircraftLineManager(this));
    }

    public void updateInnerLines() {
        int i;
        IntervalTreeActivityRepository repository = (IntervalTreeActivityRepository)this.getRepository();
        List flights = repository.getAllActivities();
        int lineCount = 0;
        if (flights.size() > 1) {
            for (i = 0; i < flights.size(); ++i) {
                Flight checkedFlight = (Flight)flights.get(i);
                checkedFlight.setLineIndex(0);
                if (i <= 0) continue;
                int j = i - 1;
                do {
                    Flight flight;
                    if (!ActivityHelper.intersect(flight = (Flight)flights.get(j), checkedFlight)) continue;
                    checkedFlight.setLineIndex(Math.max(checkedFlight.getLineIndex(), flight.getLineIndex() + 1));
                } while (--j > -1);
            }
        }
        for (i = 0; i < flights.size(); ++i) {
            lineCount = Math.max(lineCount, ((Flight)flights.get(i)).getLineIndex() + 1);
        }
        if (lineCount > 1) {
            this.setLineCount(lineCount);
            this.setHeight((double)lineCount * 24.0);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

