/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates.map;

import au.com.bytecode.opencsv.CSVReader;
import com.flexganttfx.emirates.model.Aircraft;
import com.flexganttfx.emirates.model.Flight;
import com.flexganttfx.model.repository.IntervalTreeActivityRepository;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class MapComponent
extends JPanel
implements DropTargetListener {
    private static final long serialVersionUID = -3601701760102617385L;
    private static Image departureImage;
    private static Image arrivalImage;
    private static Map<String, Location> airportMap;
    private static List<String[]> data;
    private JMapViewer viewer = new JMapViewer();
    private boolean linked;

    public MapComponent() {
        this.viewer.setZoomContolsVisible(false);
        this.viewer.setScrollWrapEnabled(false);
        JPanel header = new JPanel();
        header.setLayout(new FlowLayout(2));
        JComboBox<TileSource> tileSourceBox = new JComboBox<TileSource>(new TileSource[]{new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource(), new BingAerialTileSource(), new OsmTileSource.CycleMap(), new OsmTileSource.Mapnik()});
        tileSourceBox.setSelectedItem(this.viewer.getTileController().getTileSource());
        tileSourceBox.addActionListener(evt -> {
            TileSource ts = (TileSource)tileSourceBox.getSelectedItem();
            this.viewer.setTileSource(ts);
        });
        header.add(tileSourceBox);
        JToggleButton linkViews = new JToggleButton("Link Views", this.linked);
        linkViews.addActionListener(evt -> this.setLinked(linkViews.isSelected()));
        header.add(linkViews);
        this.setLayout(new MigLayout("insets 0 0 0 0, wrap 1, gapy 0", "[grow]", "[][grow]"));
        this.add((Component)this.viewer, "grow");
        new DropTarget(this, this);
    }

    protected void setLinked(boolean linked) {
        this.linked = linked;
        if (linked) {
            this.populateMapBasedOnTreeSelections();
        } else {
            this.clearMap();
        }
    }

    private void populateMapBasedOnTreeSelections() {
    }

    public void display(Aircraft aircraft) {
        this.clearMap();
        IntervalTreeActivityRepository repository = (IntervalTreeActivityRepository)aircraft.getRepository();
        List activities = repository.getAllActivities();
        for (Flight flight : activities) {
            this.display(flight);
        }
    }

    public void display(List<Flight> flights) {
        this.clearMap();
        for (Flight flight : flights) {
            this.display(flight);
        }
        this.viewer.setDisplayToFitMapMarkers();
    }

    public void display(Flight flight) {
        String departureStation = flight.getDepartureAirport();
        String arrivalStation = flight.getArrivalAirport();
        Location departureLocation = airportMap.get(departureStation);
        Location arrivalLocation = airportMap.get(arrivalStation);
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        if (departureLocation != null) {
            this.viewer.addMapMarker(new MapMarkerImage(departureLocation.lat, departureLocation.lon, departureImage, true));
            points.add(new Coordinate(departureLocation.lat, departureLocation.lon));
        }
        if (arrivalLocation != null) {
            this.viewer.addMapMarker(new MapMarkerImage(arrivalLocation.lat, arrivalLocation.lon, arrivalImage, false));
            points.add(new Coordinate(arrivalLocation.lat, arrivalLocation.lon));
        }
        if (departureLocation != null) {
            points.add(new Coordinate(departureLocation.lat, departureLocation.lon));
        }
        MapPolygonImpl polygon = new MapPolygonImpl(points);
        this.viewer.addMapPolygon(polygon);
    }

    private void clearMap() {
        this.viewer.removeAllMapMarkers();
        this.viewer.removeAllMapPolygons();
        this.viewer.removeAllMapRectangles();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    static {
        try {
            departureImage = ImageIO.read(MapComponent.class.getResource("bullet_ball_glass_yellow.png"));
            arrivalImage = ImageIO.read(MapComponent.class.getResource("signal_flag_checkered.png"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try (CSVReader reader = new CSVReader(new InputStreamReader(MapComponent.class.getResourceAsStream("airports.csv")));){
            airportMap = new HashMap<String, Location>();
            data = reader.readAll();
            for (String[] str : data) {
                String code = str[0];
                Location loc = new Location();
                loc.lat = Double.valueOf(str[5]);
                loc.lon = Double.valueOf(str[6]);
                airportMap.put(code, loc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class MapMarkerImage
    extends MapMarkerDot {
        private Image image;
        private boolean center;

        public MapMarkerImage(double lat, double lon, Image image, boolean center) {
            super(lat, lon);
            this.image = image;
            this.center = center;
        }

        @Override
        public void paint(Graphics g, Point p, int i) {
            int w = this.image.getWidth(MapComponent.this.viewer);
            int h = this.image.getHeight(MapComponent.this.viewer);
            if (this.center) {
                g.drawImage(this.image, p.x - 8, p.y - 8, w, h, MapComponent.this.viewer);
            } else {
                g.drawImage(this.image, p.x - 4, p.y - h, w, h, MapComponent.this.viewer);
            }
        }
    }

    static class Location {
        double lat;
        double lon;

        Location() {
        }
    }
}

