/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.emirates;

import com.flexganttfx.core.FlexGanttFX;
import com.flexganttfx.emirates.model.DataModel;
import com.flexganttfx.emirates.view.EmiratesAircraftGanttChart;
import com.flexganttfx.emirates.view.IntroPane;
import com.flexganttfx.extras.GanttChartStatusBar;
import com.flexganttfx.extras.GanttChartToolBar;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;

public class EmiratesApp
extends Application {
    private EmiratesAircraftGanttChart gantt;
    private Stage stage;
    private Node ganttNode;
    private Node introNode;
    private GanttChartStatusBar<?> statusBar;

    public void start(Stage stage) throws Exception {
        FlexGanttFX.setLicenseKey("LIC=DLSCDemos;VEN=DLSC;VER=1;PRO=STANDARD;RUN=no;CTR=1;SignCode=3F;Signature=302D02147A182E2D6FBFE9DDDC1018CAB639471975DEAFC002150093EE7CA750A1FF7B50972D6C01C17416E89A8CA2");
        this.stage = stage;
        this.stage.setTitle("Emirates Aircraft Scheduling");
        StackPane stack = new StackPane();
        this.ganttNode = this.createGanttChart();
        stack.getChildren().add((Object)this.ganttNode);
        this.introNode = this.createIntro();
        stack.getChildren().add((Object)this.introNode);
        Scene scene = new Scene((Parent)stack);
        scene.getStylesheets().add((Object)EmiratesApp.class.getResource("emirates.css").toExternalForm());
        stage.setScene(scene);
        stage.setWidth(1400.0);
        stage.setHeight(900.0);
        stage.centerOnScreen();
        stage.show();
    }

    public void load(final DataModel.DataSet dataSet) {
        KeyValue keyValue = new KeyValue((WritableValue)this.introNode.opacityProperty(), (Object)0);
        KeyFrame keyFrame = new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{keyValue});
        Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
        timeline.setOnFinished(finishedEvent -> {
            this.ganttNode.toFront();
            this.gantt.getTimeline().showTemporalUnit(ChronoUnit.DAYS, 25.0);
            Task<DataModel> task = new Task<DataModel>(){

                protected DataModel call() throws Exception {
                    return new DataModel(dataSet, EmiratesApp.this.statusBar);
                }
            };
            task.setOnSucceeded(arg_0 -> this.lambda$null$2((Task)task, arg_0));
            Thread thread = new Thread((Runnable)task);
            thread.start();
        });
        timeline.play();
    }

    private Region createIntro() {
        HBox placeholder = new HBox();
        placeholder.getStyleClass().add((Object)"cover");
        IntroPane introPane = new IntroPane(this);
        HBox.setMargin((Node)introPane, (Insets)new Insets(0.0, 0.0, 40.0, 40.0));
        placeholder.getChildren().add((Object)introPane);
        return placeholder;
    }

    private Region createGanttChart() {
        this.gantt = new EmiratesAircraftGanttChart();
        this.gantt.setPrefSize(1300.0, 1100.0);
        VBox.setVgrow((Node)this.gantt, (Priority)Priority.ALWAYS);
        VBox vbox = new VBox(0.0);
        MenuBar menuBar = this.createMenuBar();
        vbox.getChildren().add((Object)menuBar);
        GanttChartToolBar toolBar = new GanttChartToolBar(this.gantt);
        vbox.getChildren().add(toolBar);
        vbox.getChildren().add((Object)this.gantt);
        this.statusBar = new GanttChartStatusBar(this.gantt);
        vbox.getChildren().add(this.statusBar);
        return vbox;
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        Menu loadMenu = new Menu("Load");
        for (DataModel.DataSet data : DataModel.DataSet.values()) {
            MenuItem openDataSetItem = new MenuItem(data.getDisplayName());
            openDataSetItem.setOnAction(event -> this.load(data));
            loadMenu.getItems().add((Object)openDataSetItem);
        }
        fileMenu.getItems().add((Object)loadMenu);
        MenuItem redraw = new MenuItem("Redraw");
        redraw.setOnAction(evt -> {
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < 10000; ++i) {
                if (i % 1000 == 0) {
                    System.out.println("repaints done: " + i);
                }
                this.gantt.getGraphics().redraw();
            }
            System.out.println("time in ms: " + (System.currentTimeMillis() - startTime));
        });
        fileMenu.getItems().add((Object)redraw);
        CheckMenuItem safeItem = new CheckMenuItem("Safe Rendering");
        safeItem.selectedProperty().bindBidirectional((Property)this.gantt.getGraphics().safeRenderingProperty());
        fileMenu.getItems().add((Object)safeItem);
        menuBar.getMenus().add((Object)fileMenu);
        return menuBar;
    }

    public static void main(String[] args) {
        EmiratesApp.launch((String[])args);
    }

    private /* synthetic */ void lambda$null$2(Task task, WorkerStateEvent succeededEvent) {
        Platform.runLater(() -> {
            try {
                this.statusBar.setProgress(0.0);
                DataModel model = (DataModel)task.get();
                this.gantt.getRows().setAll(model.getRows());
                this.gantt.getLayers().setAll(model.getLayers());
                Platform.runLater(() -> this.gantt.getGraphics().showEarliestActivities());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

