/*
 * Decompiled with CFR 0.152.
 */
package com.flexganttfx.core;

import com.flexganttfx.core.LoggingDomain;
import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FlexGanttFX {
    private static String version;
    public static final String FEATURE_LICENSEE = "LIC";
    public static final String FEATURE_PRODUCT = "PRO";
    public static final String FEATURE_RUNTIME = "RUN";
    public static final String FEATURE_VENDOR = "VEN";
    public static final String FEATURE_VERSION = "VER";
    private static boolean keySet;
    private static License license;
    private static final Logger LOGGER;
    private static String publicKey;
    private static final int SYSTEM_EXIT_CODE = -1603;

    public static String getVersion() {
        if (version == null) {
            InputStream stream = FlexGanttFX.class.getResourceAsStream("version.properties");
            Properties props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException ex) {
                LoggingDomain.CONFIG.throwing(FlexGanttFX.class.getName(), "getVersion()", ex);
            }
            version = props.getProperty("flexganttfx.version", "1.0.0");
            LoggingDomain.CONFIG.info("FlexGanttFX Version: " + version);
        }
        return version;
    }

    public static String getLicensee() {
        if (FlexGanttFX.getLicense() != null) {
            return (String)FlexGanttFX.getLicense().getFeature(FEATURE_LICENSEE);
        }
        return "---";
    }

    public static String getProduct() {
        if (FlexGanttFX.getLicense() != null) {
            String licensee = (String)FlexGanttFX.getLicense().getFeature(FEATURE_PRODUCT);
            return licensee;
        }
        return "---";
    }

    public static String getPublicKey() {
        return publicKey;
    }

    public static String getVendor() {
        if (FlexGanttFX.getLicense() != null) {
            return (String)FlexGanttFX.getLicense().getFeature(FEATURE_VENDOR);
        }
        return "---";
    }

    public static String getLicensedVersion() {
        if (FlexGanttFX.getLicense() != null) {
            return (String)FlexGanttFX.getLicense().getFeature(FEATURE_VERSION);
        }
        return "---";
    }

    public static boolean isDevelopmentLicense() {
        return !FlexGanttFX.isTrialLicense() && !FlexGanttFX.isRuntimeLicense();
    }

    public static boolean isRuntimeLicense() {
        if (FlexGanttFX.getLicense() != null) {
            String runtime = (String)FlexGanttFX.getLicense().getFeature(FEATURE_RUNTIME);
            return runtime != null && runtime.equals("yes");
        }
        return false;
    }

    public static boolean isTrialLicense() {
        return FlexGanttFX.getLicense() == null;
    }

    public static boolean isLicenseKeySet() {
        return keySet;
    }

    public static void setLicenseKey(String key) {
        if (keySet) {
            throw new IllegalStateException("licensing key can only be set once");
        }
        keySet = true;
        LOGGER.fine("found properties file");
        try {
            key = key.replace(';', '\n');
            ByteArrayInputStream stream = new ByteArrayInputStream(key.getBytes());
            license = LicenseManager.loadLicense(stream);
            if (!LicenseManager.isValid(license)) {
                System.err.println();
                System.err.println("#####################################");
                System.err.println("# Invalid FlexGanttFX license key!  #");
                System.err.println("# Exiting application...            #");
                System.err.println("#####################################");
                System.err.println();
                System.exit(-1603);
            }
            List featureNames = license.getFeatureList();
            LOGGER.fine("License Features:");
            for (String featureName : featureNames) {
                Object featureValue = license.getFeature(featureName);
                LOGGER.fine("   " + featureName + " = " + featureValue);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "unable to process FlexGanttFX properties file", e);
            System.err.println("Unable to process FlexGanttFX license key, exiting application");
            System.exit(-1603);
        }
    }

    public static License getLicense() {
        if (license != null) {
            return license;
        }
        String key = System.getProperty("flexganttfx.license");
        if (key != null) {
            FlexGanttFX.setLicenseKey(key);
        }
        return license;
    }

    static {
        LOGGER = Logger.getLogger(FlexGanttFX.class.getName());
        Properties props = new Properties();
        try {
            props.load(FlexGanttFX.class.getResourceAsStream("public_key.properties"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to process public key property file", e);
        }
        publicKey = props.getProperty("public");
        LicenseManager.setPublicKey(publicKey);
    }
}

