/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import impl.org.controlsfx.table.ColumnFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public final class TableFilter<T> {
    private final TableView<T> tableView;
    private final ObservableList<T> backingList;
    private final FilteredList<T> filteredList;
    private final ObservableList<ColumnFilter<T, ?>> columnFilters = FXCollections.observableArrayList();

    @Deprecated
    public TableFilter(TableView<T> tableView) {
        this(tableView, false);
    }

    private TableFilter(TableView<T> tableView, boolean isLazy) {
        this.tableView = tableView;
        this.backingList = tableView.getItems();
        this.filteredList = new FilteredList((ObservableList)new SortedList(this.backingList));
        SortedList sortedControlList = new SortedList(this.filteredList);
        this.filteredList.setPredicate(v -> true);
        sortedControlList.comparatorProperty().bind((ObservableValue)tableView.comparatorProperty());
        tableView.setItems((ObservableList)sortedControlList);
        this.applyForAllColumns(isLazy);
        tableView.getStylesheets().add((Object)"/impl/org/controlsfx/table/tablefilter.css");
        if (!isLazy) {
            this.columnFilters.forEach(ColumnFilter::initialize);
        }
    }

    public void setSearchStrategy(BiPredicate<String, String> searchStrategy) {
        this.columnFilters.forEach(cf -> cf.setSearchStrategy(searchStrategy));
    }

    public ObservableList<T> getBackingList() {
        return this.backingList;
    }

    public FilteredList<T> getFilteredList() {
        return this.filteredList;
    }

    private void applyForAllColumns(boolean isLazy) {
        this.columnFilters.setAll((Collection)this.tableView.getColumns().stream().flatMap(this::extractNestedColumns).map(c2 -> new ColumnFilter(this, c2)).collect(Collectors.toList()));
    }

    private <S> Stream<TableColumn<T, ?>> extractNestedColumns(TableColumn<T, S> tableColumn) {
        if (tableColumn.getColumns().size() == 0) {
            return Stream.of(tableColumn);
        }
        return tableColumn.getColumns().stream().flatMap(this::extractNestedColumns);
    }

    public void selectValue(TableColumn<?, ?> column, Object value) {
        this.columnFilters.stream().filter(c2 -> c2.getTableColumn() == column).forEach(c2 -> c2.selectValue(value));
    }

    public void unselectValue(TableColumn<?, ?> column, Object value) {
        this.columnFilters.stream().filter(c2 -> c2.getTableColumn() == column).forEach(c2 -> c2.unselectValue(value));
    }

    public void selectAllValues(TableColumn<?, ?> column) {
        this.columnFilters.stream().filter(c2 -> c2.getTableColumn() == column).forEach(ColumnFilter::selectAllValues);
    }

    public void unSelectAllValues(TableColumn<?, ?> column) {
        this.columnFilters.stream().filter(c2 -> c2.getTableColumn() == column).forEach(ColumnFilter::unSelectAllValues);
    }

    public void executeFilter() {
        if (this.columnFilters.stream().filter(ColumnFilter::isFiltered).findAny().isPresent()) {
            this.filteredList.setPredicate(item -> !this.columnFilters.stream().filter(cf -> !cf.evaluate(item)).findAny().isPresent());
        } else {
            this.resetFilter();
        }
    }

    public void resetFilter() {
        this.filteredList.setPredicate(item -> true);
    }

    public TableView<T> getTableView() {
        return this.tableView;
    }

    public ObservableList<ColumnFilter<T, ?>> getColumnFilters() {
        return this.columnFilters;
    }

    public Optional<ColumnFilter<T, ?>> getColumnFilter(TableColumn<T, ?> tableColumn) {
        return this.columnFilters.stream().filter(f -> f.getTableColumn().equals(tableColumn)).findAny();
    }

    public boolean isDirty() {
        return this.columnFilters.stream().filter(ColumnFilter::isFiltered).findAny().isPresent();
    }

    public static <T> Builder<T> forTableView(TableView<T> tableView) {
        return new Builder(tableView);
    }

    public static final class Builder<T> {
        private final TableView<T> tableView;
        private volatile boolean lazyInd = false;

        private Builder(TableView<T> tableView) {
            this.tableView = tableView;
        }

        public Builder<T> lazy(boolean isLazy) {
            this.lazyInd = isLazy;
            return this;
        }

        public TableFilter<T> apply() {
            return new TableFilter(this.tableView, this.lazyInd);
        }
    }
}

