/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.reflect.Method;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.ActionCheck;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.AnnotatedAction;
import org.controlsfx.control.action.AnnotatedActionFactory;
import org.controlsfx.control.action.AnnotatedCheckAction;
import org.controlsfx.glyphfont.Glyph;

public class DefaultActionFactory
implements AnnotatedActionFactory {
    @Override
    public AnnotatedAction createAction(ActionProxy annotation, Method method, Object target) {
        ActionCheck[] checkAnnotations = (ActionCheck[])method.getAnnotationsByType(ActionCheck.class);
        AnnotatedAction action = checkAnnotations != null && checkAnnotations.length > 0 ? new AnnotatedCheckAction(annotation.text(), method, target) : new AnnotatedAction(annotation.text(), method, target);
        this.configureAction(annotation, action);
        return action;
    }

    protected void configureAction(ActionProxy annotation, AnnotatedAction action) {
        String acceleratorText;
        Node graphic = this.resolveGraphic(annotation);
        action.setGraphic(graphic);
        String longText = annotation.longText().trim();
        if (graphic != null) {
            action.setLongText(longText);
        }
        if (!(acceleratorText = annotation.accelerator().trim()).isEmpty()) {
            action.setAccelerator(KeyCombination.keyCombination((String)acceleratorText));
        }
    }

    protected Node resolveGraphic(ActionProxy annotation) {
        String graphicDef = annotation.graphic().trim();
        if (!graphicDef.isEmpty()) {
            String[] def = graphicDef.split("\\>");
            if (def.length == 1) {
                return new ImageView(new Image(def[0]));
            }
            switch (def[0]) {
                case "font": {
                    return Glyph.create(def[1]);
                }
                case "image": {
                    return new ImageView(new Image(def[1]));
                }
            }
            throw new IllegalArgumentException(String.format("Unknown ActionProxy graphic protocol: %s", def[0]));
        }
        return null;
    }
}

