/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.TaskProgressViewSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;

public class TaskProgressView<T extends Task<?>>
extends ControlsFXControl {
    private final ObservableList<T> tasks = FXCollections.observableArrayList();
    private ObjectProperty<Callback<T, Node>> graphicFactory;

    public TaskProgressView() {
        this.getStyleClass().add((Object)"task-progress-view");
        final EventHandler taskHandler = evt -> {
            if (evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED) || evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_CANCELLED) || evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_FAILED)) {
                this.getTasks().remove((Object)evt.getSource());
            }
        };
        this.getTasks().addListener(new ListChangeListener<Task<?>>(){

            public void onChanged(ListChangeListener.Change<? extends Task<?>> c2) {
                while (c2.next()) {
                    if (c2.wasAdded()) {
                        for (Task task : c2.getAddedSubList()) {
                            task.addEventHandler(WorkerStateEvent.ANY, taskHandler);
                        }
                        continue;
                    }
                    if (!c2.wasRemoved()) continue;
                    for (Task task : c2.getRemoved()) {
                        task.removeEventHandler(WorkerStateEvent.ANY, taskHandler);
                    }
                }
            }
        });
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(TaskProgressView.class, "taskprogressview.css");
    }

    protected Skin<?> createDefaultSkin() {
        return new TaskProgressViewSkin(this);
    }

    public final ObservableList<T> getTasks() {
        return this.tasks;
    }

    public final ObjectProperty<Callback<T, Node>> graphicFactoryProperty() {
        if (this.graphicFactory == null) {
            this.graphicFactory = new SimpleObjectProperty((Object)this, "graphicFactory");
        }
        return this.graphicFactory;
    }

    public final Callback<T, Node> getGraphicFactory() {
        return this.graphicFactory == null ? null : (Callback)this.graphicFactory.get();
    }

    public final void setGraphicFactory(Callback<T, Node> factory) {
        this.graphicFactoryProperty().set(factory);
    }
}

