/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.WbsRowComparator;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.InputStreamTokenizer;
import net.sf.mpxj.utility.MPXJNumberFormat;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraXERFileReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    boolean m_skipTable;
    private Map<String, List<Row>> m_tables;
    private String m_currentTableName;
    private List<Row> m_currentTable;
    private String[] m_currentFieldNames;
    private String m_defaultCurrencyName;
    private Map<String, MPXJNumberFormat> m_currencyMap = new HashMap<String, MPXJNumberFormat>();
    private MPXJNumberFormat m_numberFormat;
    private Row m_defaultCurrencyData;
    private DateFormat m_df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final List<Row> EMPTY_TABLE = new LinkedList<Row>();
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, RecordType> RECORD_TYPE_MAP = new HashMap<String, RecordType>();
    private static final Map<String, FieldType> FIELD_TYPE_MAP;
    private static final Set<String> REQUIRED_TABLES;
    private static final WbsRowComparator WBS_ROW_COMPARATOR;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new MPXJNumberFormat();
            this.processFile(is);
            this.m_reader = new PrimaveraReader();
            ProjectFile project = this.m_reader.getProject();
            project.addProjectListeners(this.m_projectListeners);
            this.processProjectID();
            this.processProjectHeader();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            project.updateStructure();
            ProjectFile projectFile = project;
            Object var5_4 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            return projectFile;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectFile> readAll(InputStream is) throws MPXJException {
        try {
            LinkedList<ProjectFile> result = new LinkedList<ProjectFile>();
            this.m_tables = new HashMap<String, List<Row>>();
            this.m_numberFormat = new MPXJNumberFormat();
            this.processFile(is);
            List<Row> rows = this.getRows("project", null, null);
            for (Row row : rows) {
                this.setProjectID(row.getInt("proj_id"));
                this.m_reader = new PrimaveraReader();
                ProjectFile project = this.m_reader.getProject();
                project.addProjectListeners(this.m_projectListeners);
                this.processProjectHeader();
                this.processCalendars();
                this.processResources();
                this.processTasks();
                this.processPredecessors();
                this.processAssignments();
                this.m_reader = null;
                project.updateStructure();
                result.add(project);
            }
            LinkedList<ProjectFile> linkedList = result;
            Object var8_7 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_reader = null;
            this.m_tables = null;
            this.m_currentTableName = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            this.m_defaultCurrencyName = null;
            this.m_currencyMap.clear();
            this.m_numberFormat = null;
            this.m_defaultCurrencyData = null;
            throw throwable;
        }
    }

    private void processFile(InputStream is) throws MPXJException {
        int line = 1;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] data = new byte[6];
            data[0] = (byte)bis.read();
            bis.mark(1024);
            bis.read(data, 1, 5);
            if (!new String(data).equals("ERMHDR")) {
                throw new MPXJException("Invalid file format");
            }
            bis.reset();
            InputStreamTokenizer tk = new InputStreamTokenizer(bis);
            tk.setDelimiter('\t');
            ArrayList<String> record = new ArrayList<String>();
            while (tk.getType() != -1) {
                this.readRecord(tk, record);
                if (!this.processRecord(record)) {
                    ++line;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file (failed at line " + line + ")", ex);
        }
    }

    private void processProjectID() {
        List<Row> rows;
        if (this.m_projectID == null && !(rows = this.getRows("project", null, null)).isEmpty()) {
            Row row = rows.get(0);
            this.m_projectID = row.getInteger("proj_id");
        }
    }

    private void processCurrency(Row row) {
        String currencyName = row.getString("curr_short_name");
        MPXJNumberFormat nf = new MPXJNumberFormat();
        nf.applyPattern("#.#", null, row.getString("decimal_symbol").charAt(0), row.getString("digit_group_symbol").charAt(0));
        this.m_currencyMap.put(currencyName, nf);
        if (currencyName.equalsIgnoreCase(this.m_defaultCurrencyName)) {
            this.m_numberFormat = nf;
            this.m_defaultCurrencyData = row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> listProjects(InputStream is) throws MPXJException {
        try {
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(is);
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("project", null, null);
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            HashMap<Integer, String> hashMap = result;
            Object var9_8 = null;
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.m_tables = null;
            this.m_currentTable = null;
            this.m_currentFieldNames = null;
            throw throwable;
        }
    }

    private void processProjectHeader() {
        List<Row> rows = this.getRows("project", "proj_id", this.m_projectID);
        this.m_reader.processProjectHeader(rows);
        if (this.m_defaultCurrencyData != null) {
            this.m_reader.processDefaultCurrency(this.m_defaultCurrencyData);
        }
    }

    private void processCalendars() {
        List<Row> rows = this.getRows("calendar", null, null);
        this.m_reader.processCalendars(rows);
    }

    private void processResources() {
        List<Row> rows = this.getRows("rsrc", null, null);
        this.m_reader.processResources(rows);
    }

    private void processTasks() {
        List<Row> wbs = this.getRows("projwbs", "proj_id", this.m_projectID);
        List<Row> tasks = this.getRows("task", "proj_id", this.m_projectID);
        Collections.sort(wbs, WBS_ROW_COMPARATOR);
        this.m_reader.processTasks(wbs, tasks);
    }

    private void processPredecessors() {
        List<Row> rows = this.getRows("taskpred", "proj_id", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() {
        List<Row> rows = this.getRows("taskrsrc", "proj_id", this.m_projectID);
        this.m_reader.processAssignments(rows);
    }

    private void readRecord(Tokenizer tk, List<String> record) throws IOException {
        record.clear();
        while (tk.nextToken() == -3) {
            record.add(tk.getToken());
        }
    }

    private boolean processRecord(List<String> record) throws MPXJException {
        boolean done = false;
        RecordType type = RECORD_TYPE_MAP.get(record.get(0));
        if (type == null) {
            throw new MPXJException("Invalid format");
        }
        switch (type) {
            case HEADER: {
                this.processHeader(record);
                break;
            }
            case TABLE: {
                this.m_currentTableName = record.get(1).toLowerCase();
                boolean bl = this.m_skipTable = !REQUIRED_TABLES.contains(this.m_currentTableName);
                if (this.m_skipTable) {
                    this.m_currentTable = null;
                    break;
                }
                this.m_currentTable = new LinkedList<Row>();
                this.m_tables.put(this.m_currentTableName, this.m_currentTable);
                break;
            }
            case FIELDS: {
                if (this.m_skipTable) {
                    this.m_currentFieldNames = null;
                    break;
                }
                this.m_currentFieldNames = record.toArray(new String[record.size()]);
                for (int loop = 0; loop < this.m_currentFieldNames.length; ++loop) {
                    this.m_currentFieldNames[loop] = this.m_currentFieldNames[loop].toLowerCase();
                }
                break;
            }
            case DATA: {
                if (this.m_skipTable) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int loop = 1; loop < record.size(); ++loop) {
                    Object objectValue;
                    String fieldName = this.m_currentFieldNames[loop];
                    String fieldValue = record.get(loop);
                    FieldType fieldType = FIELD_TYPE_MAP.get(fieldName);
                    if (fieldType == null) {
                        fieldType = FieldType.STRING;
                    }
                    if (fieldValue.length() == 0) {
                        objectValue = null;
                    } else {
                        switch (fieldType) {
                            case DATE: {
                                try {
                                    objectValue = this.m_df.parseObject(fieldValue);
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new MPXJException("Invalid date", ex);
                                }
                            }
                            case CURRENCY: {
                                try {
                                    objectValue = this.m_numberFormat.parse(fieldValue).doubleValue();
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new MPXJException("Invalid number or number format", ex);
                                }
                            }
                            case DOUBLE: {
                                try {
                                    objectValue = this.m_numberFormat.parse(fieldValue).doubleValue();
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new MPXJException("Invalid number or number format", ex);
                                }
                            }
                            case DURATION: {
                                try {
                                    objectValue = this.m_numberFormat.parse(fieldValue).doubleValue();
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new MPXJException("Invalid number or number format", ex);
                                }
                            }
                            case INTEGER: {
                                objectValue = Integer.valueOf(fieldValue);
                                break;
                            }
                            default: {
                                objectValue = fieldValue;
                            }
                        }
                    }
                    map.put(fieldName, objectValue);
                }
                MapRow currentRow = new MapRow(map);
                this.m_currentTable.add(currentRow);
                if (!this.m_currentTableName.equals("currtype")) break;
                this.processCurrency(currentRow);
                break;
            }
            case END: {
                done = true;
                break;
            }
        }
        return done;
    }

    private void processHeader(List<String> record) {
        this.m_defaultCurrencyName = record.get(8);
    }

    private List<Row> getRows(String tableName, String columnName, Integer id) {
        List<Row> result;
        List<Row> table = this.m_tables.get(tableName);
        if (table == null) {
            result = EMPTY_TABLE;
        } else if (columnName == null) {
            result = table;
        } else {
            result = new LinkedList<Row>();
            for (Row row : table) {
                if (!NumberUtility.equals(id, row.getInteger(columnName))) continue;
                result.add(row);
            }
        }
        return result;
    }

    static {
        RECORD_TYPE_MAP.put("RMHDR", RecordType.HEADER);
        RECORD_TYPE_MAP.put("%T", RecordType.TABLE);
        RECORD_TYPE_MAP.put("%F", RecordType.FIELDS);
        RECORD_TYPE_MAP.put("%R", RecordType.DATA);
        RECORD_TYPE_MAP.put("%E", RecordType.END);
        FIELD_TYPE_MAP = new HashMap<String, FieldType>();
        FIELD_TYPE_MAP.put("proj_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("plan_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("plan_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("rsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("wbs_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("orig_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_total_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("indep_remain_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("anticip_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("anticip_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("parent_wbs_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("task_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("phys_complete_pct", FieldType.DOUBLE);
        FIELD_TYPE_MAP.put("remain_drtn_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("act_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_work_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_drtn_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("cstr_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("late_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("late_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("expect_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("early_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("early_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("create_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("pred_task_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("lag_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("remain_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("act_reg_qty", FieldType.DURATION);
        FIELD_TYPE_MAP.put("target_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_reg_cost", FieldType.CURRENCY);
        FIELD_TYPE_MAP.put("act_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("act_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_start_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("target_end_date", FieldType.DATE);
        FIELD_TYPE_MAP.put("clndr_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("default_flag", FieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_name", FieldType.STRING);
        FIELD_TYPE_MAP.put("proj_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("base_clndr_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("last_chng_date", FieldType.STRING);
        FIELD_TYPE_MAP.put("clndr_type", FieldType.STRING);
        FIELD_TYPE_MAP.put("day_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("week_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("month_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("year_hr_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("clndr_data", FieldType.STRING);
        FIELD_TYPE_MAP.put("seq_num", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("taskrsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("parent_rsrc_id", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("free_float_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("total_float_hr_cnt", FieldType.DURATION);
        FIELD_TYPE_MAP.put("decimal_digit_cnt", FieldType.INTEGER);
        FIELD_TYPE_MAP.put("target_qty_per_hr", FieldType.DOUBLE);
        FIELD_TYPE_MAP.put("target_lag_drtn_hr_cnt", FieldType.DURATION);
        REQUIRED_TABLES = new HashSet<String>();
        REQUIRED_TABLES.add("project");
        REQUIRED_TABLES.add("calendar");
        REQUIRED_TABLES.add("rsrc");
        REQUIRED_TABLES.add("projwbs");
        REQUIRED_TABLES.add("task");
        REQUIRED_TABLES.add("taskpred");
        REQUIRED_TABLES.add("taskrsrc");
        REQUIRED_TABLES.add("currtype");
        WBS_ROW_COMPARATOR = new WbsRowComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FieldType {
        STRING,
        INTEGER,
        DOUBLE,
        DATE,
        DURATION,
        CURRENCY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecordType {
        HEADER,
        TABLE,
        FIELDS,
        DATA,
        END;

    }
}

