/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CompObj;
import net.sf.mpxj.mpp.MPP12Reader;
import net.sf.mpxj.mpp.MPP14Reader;
import net.sf.mpxj.mpp.MPP8Reader;
import net.sf.mpxj.mpp.MPP9Reader;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class MPPReader
extends AbstractProjectReader {
    private boolean m_preserveNoteFormatting;
    private boolean m_useRawTimephasedData;
    private boolean m_readPresentationData = true;
    private String m_readPassword;
    private String m_writePassword;
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, Class<? extends MPPVariantReader>> FILE_CLASS_MAP = new HashMap<String, Class<? extends MPPVariantReader>>();

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            return this.read(fs);
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read(POIFSFileSystem fs) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            projectFile.addProjectListeners(this.m_projectListeners);
            projectFile.setAutoTaskID(false);
            projectFile.setAutoTaskUniqueID(false);
            projectFile.setAutoResourceID(false);
            projectFile.setAutoResourceUniqueID(false);
            projectFile.setAutoOutlineLevel(false);
            projectFile.setAutoOutlineNumber(false);
            projectFile.setAutoWBS(false);
            projectFile.setAutoCalendarUniqueID(false);
            projectFile.setAutoAssignmentUniqueID(false);
            DirectoryNode root = fs.getRoot();
            CompObj compObj = new CompObj(new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            String format = compObj.getFileFormat();
            Class<? extends MPPVariantReader> readerClass = FILE_CLASS_MAP.get(format);
            if (readerClass == null) {
                throw new MPXJException("Invalid file format: " + format);
            }
            MPPVariantReader reader = readerClass.newInstance();
            reader.process(this, projectFile, root);
            projectFile.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            projectFile.setAutoOutlineNumber(false);
            for (Task task : projectFile.getAllTasks()) {
                task.setSummary(task.getChildTasks().size() != 0);
                List<DateRange> splits = task.getSplits();
                if (splits != null && splits.isEmpty()) {
                    task.setSplits(null);
                }
                this.validationRelations(task);
            }
            projectFile.updateUniqueCounters();
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (InstantiationException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void validationRelations(Task task) {
        List<Relation> predecessors = task.getPredecessors();
        if (predecessors != null) {
            ArrayList<Relation> invalid = new ArrayList<Relation>();
            for (Relation relation : predecessors) {
                Task sourceTask = relation.getSourceTask();
                Task targetTask = relation.getTargetTask();
                String sourceOutlineNumber = sourceTask.getOutlineNumber();
                String targetOutlineNumber = targetTask.getOutlineNumber();
                if (sourceOutlineNumber == null || targetOutlineNumber == null || !sourceOutlineNumber.startsWith(targetOutlineNumber + '.')) continue;
                invalid.add(relation);
            }
            for (Relation relation : invalid) {
                relation.getSourceTask().removePredecessor(relation.getTargetTask(), relation.getType(), relation.getLag());
            }
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public boolean getUseRawTimephasedData() {
        return this.m_useRawTimephasedData;
    }

    public void setUseRawTimephasedData(boolean useRawTimephasedData) {
        this.m_useRawTimephasedData = useRawTimephasedData;
    }

    public boolean getReadPresentationData() {
        return this.m_readPresentationData;
    }

    public void setReadPresentationData(boolean readPresentationData) {
        this.m_readPresentationData = readPresentationData;
    }

    public void setReadPassword(String password) {
        this.m_readPassword = password;
    }

    public String getReadPassword() {
        return this.m_readPassword;
    }

    public void setWritePassword(String password) {
        this.m_writePassword = password;
    }

    public String getWritePassword() {
        return this.m_writePassword;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL14", MPP14Reader.class);
    }
}

