/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.EncryptedDocumentInputStream;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap9;
import net.sf.mpxj.mpp.FilterReader9;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader9;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectHeaderReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.PropsBlock;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import net.sf.mpxj.mpp.ViewFactory9;
import net.sf.mpxj.mpp.ViewStateReader9;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP9Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private Props9 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private int m_highestEmptyTaskID;
    private static final int SUBPROJECT_LISTEND = 771;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 49741824;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 0x7010000;
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 1;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 2;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = null;
    private static final Integer OUTLINECODE_DATA = 1;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};

    MPP9Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader reader, ProjectFile file, DirectoryEntry root) throws MPXJException, IOException {
        try {
            String readPassword;
            Props9 props9 = new Props9(new DocumentInputStream((DocumentEntry)root.getEntry("Props9")));
            file.setProjectFilePath(props9.getUnicodeString(Props.PROJECT_FILE_PATH));
            file.setEncoded(props9.getByte(Props.PASSWORD_FLAG) != 0);
            file.setEncryptionCode(props9.getByte(Props.ENCRYPTION_CODE));
            if (!((props9.getByte(Props.PASSWORD_FLAG) & 1) == 0 || (readPassword = MPPUtility.decodePassword(props9.getByteArray(Props.PROTECTION_PASSWORD_HASH), file.getEncryptionCode())) == null || readPassword.length() <= 0 || reader.getReadPassword() != null && reader.getReadPassword().matches(readPassword))) {
                throw new MPXJException("File is password protected. Please enter password.");
            }
            this.m_reader = reader;
            this.m_file = file;
            this.m_root = root;
            this.m_resourceMap = new HashMap();
            this.m_projectDir = (DirectoryEntry)root.getEntry("   19");
            this.m_viewDir = (DirectoryEntry)root.getEntry("   29");
            DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
            VarMeta9 outlineCodeVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
            this.m_outlineCodeVarData = new Var2Data(outlineCodeVarMeta, new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
            this.m_projectProps = new Props9(this.getEncryptableInputStream(this.m_projectDir, "Props"));
            this.m_fontBases = new HashMap<Integer, FontBase>();
            this.m_taskSubProjects = new HashMap<Integer, SubProject>();
            this.m_file.setMppFileType(9);
            this.m_file.setAutoFilter(props9.getBoolean(Props.AUTO_FILTER));
            this.processPropertyData();
            this.processCalendarData();
            this.processResourceData();
            this.processTaskData();
            this.processConstraintData();
            this.processAssignmentData();
            this.validateTaskIDs();
            if (reader.getReadPresentationData()) {
                this.processViewPropertyData();
                this.processTableData();
                this.processViewData();
                this.processFilterData();
                this.processGroupData();
                this.processSavedViewState();
            }
        }
        finally {
            this.m_reader = null;
            this.m_file = null;
            this.m_root = null;
            this.m_resourceMap = null;
            this.m_projectDir = null;
            this.m_viewDir = null;
            this.m_outlineCodeVarData = null;
            this.m_fontBases = null;
            this.m_taskSubProjects = null;
        }
    }

    private void processPropertyData() throws IOException, MPXJException {
        ProjectHeaderReader projectHeaderReader = new ProjectHeaderReader();
        projectHeaderReader.process(this.m_file, this.m_projectProps, this.m_root);
        this.processTaskFieldNameAliases(this.m_projectProps.getByteArray(Props.TASK_FIELD_NAME_ALIASES));
        this.processResourceFieldNameAliases(this.m_projectProps.getByteArray(Props.RESOURCE_FIELD_NAME_ALIASES));
        this.processTaskFieldCustomValueLists(this.m_file, this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES));
        this.processSubProjectData();
        GraphicalIndicatorReader reader = new GraphicalIndicatorReader();
        reader.process(this.m_file, this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] subProjData = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (subProjData != null) {
            int index = 0;
            int offset = 0;
            byte[] itemHeader = new byte[20];
            offset += 4;
            int itemCountOffset = MPPUtility.getInt(subProjData, offset += 4);
            offset += 4;
            block17: while (offset < itemCountOffset) {
                ++index;
                int itemHeaderOffset = MPPUtility.getShort(subProjData, offset);
                offset += 4;
                MPPUtility.getByteArray(subProjData, itemHeaderOffset, itemHeader.length, itemHeader, 0);
                byte subProjectType = itemHeader[16];
                switch (subProjectType) {
                    case 0: {
                        offset += 8;
                        continue block17;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case -111: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case 3: 
                    case 17: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case -127: 
                    case 65: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case 1: 
                    case 8: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case -64: {
                        int uniqueIDOffset = itemHeaderOffset;
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case 5: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        this.m_file.setResourceSubProject(sp);
                        continue block17;
                    }
                    case 69: {
                        int uniqueIDOffset = MPPUtility.getInt(subProjData, offset) & 0x1FFFF;
                        int filePathOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        int fileNameOffset = MPPUtility.getInt(subProjData, offset += 4) & 0x1FFFF;
                        offset += 4;
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        this.m_file.setResourceSubProject(sp);
                        continue block17;
                    }
                    case 2: 
                    case 4: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        if (subProjectType != 4) continue block17;
                        this.m_file.setResourceSubProject(sp);
                        continue block17;
                    }
                    case -115: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 8);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 8);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case 10: {
                        int uniqueIDOffset = MPPUtility.getShort(subProjData, offset);
                        int filePathOffset = MPPUtility.getShort(subProjData, offset += 4);
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, uniqueIDOffset, filePathOffset, fileNameOffset, index);
                        continue block17;
                    }
                    case -128: {
                        offset += 12;
                        continue block17;
                    }
                    case 16: {
                        offset += 8;
                        continue block17;
                    }
                    case 68: {
                        int filePathOffset = MPPUtility.getShort(subProjData, offset);
                        offset += 4;
                        int fileNameOffset = MPPUtility.getShort(subProjData, offset += 4);
                        offset += 4;
                        SubProject sp = this.readSubProject(subProjData, -1, filePathOffset, fileNameOffset, index);
                        this.m_file.setResourceSubProject(sp);
                        continue block17;
                    }
                }
                offset += 12;
            }
        }
    }

    private SubProject readSubProject(byte[] data, int uniqueIDOffset, int filePathOffset, int fileNameOffset, int subprojectIndex) {
        try {
            SubProject sp = new SubProject();
            if (uniqueIDOffset != -1) {
                int prev = 0;
                int value = MPPUtility.getInt(data, uniqueIDOffset);
                while (value != 771) {
                    switch (value) {
                        case 0: 
                        case 49741824: 
                        case 94437376: 
                        case 0x7010000: 
                        case 0xABB0000: 
                        case 187957248: {
                            sp.setTaskUniqueID(prev);
                            this.m_taskSubProjects.put(sp.getTaskUniqueID(), sp);
                            prev = 0;
                            break;
                        }
                        default: {
                            if (prev != 0) {
                                sp.addExternalTaskUniqueID(prev);
                                this.m_taskSubProjects.put(prev, sp);
                            }
                            prev = value;
                        }
                    }
                    value = MPPUtility.getInt(data, uniqueIDOffset += 4);
                }
                if (prev != 0) {
                    sp.addExternalTaskUniqueID(prev);
                    this.m_taskSubProjects.put(prev, sp);
                }
                value = 0x800000 + (subprojectIndex - 1) * 0x400000;
                sp.setUniqueIDOffset(value);
            }
            filePathOffset += 18;
            sp.setDosFullPath(MPPUtility.getString(data, filePathOffset += 4));
            filePathOffset += sp.getDosFullPath().length() + 1;
            int size = MPPUtility.getInt(data, filePathOffset += 24);
            filePathOffset += 4;
            if (size == 0) {
                sp.setFullPath(sp.getDosFullPath());
            } else {
                size = MPPUtility.getInt(data, filePathOffset);
                filePathOffset += 4;
                sp.setFullPath(MPPUtility.getUnicodeString(data, filePathOffset += 2, size));
            }
            fileNameOffset += 18;
            sp.setDosFileName(MPPUtility.getString(data, fileNameOffset += 4));
            fileNameOffset += sp.getDosFileName().length() + 1;
            size = MPPUtility.getInt(data, fileNameOffset += 24);
            fileNameOffset += 4;
            if (size == 0) {
                sp.setFileName(sp.getDosFileName());
            } else {
                size = MPPUtility.getInt(data, fileNameOffset);
                fileNameOffset += 4;
                sp.setFileName(MPPUtility.getUnicodeString(data, fileNameOffset += 2, size));
            }
            this.m_file.addSubProject(sp);
            return sp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props9 props = new Props9(this.getEncryptableInputStream(this.m_viewDir, "Props"));
        byte[] data = props.getByteArray(Props.FONT_BASES);
        if (data != null) {
            this.processBaseFonts(data);
        }
        ProjectHeader header = this.m_file.getProjectHeader();
        header.setShowProjectSummaryTask(props.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] data) {
        int offset = 0;
        int blockCount = MPPUtility.getShort(data, 0);
        offset += 2;
        for (int loop = 0; loop < blockCount; ++loop) {
            int size = MPPUtility.getShort(data, offset += 2);
            String name = MPPUtility.getUnicodeString(data, offset += 2);
            offset += 64;
            if (name.length() == 0) continue;
            FontBase fontBase = new FontBase(loop, name, size);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private void processTaskFieldNameAliases(byte[] data) {
        if (data != null) {
            String alias;
            ArrayList<String> aliases = new ArrayList<String>(300);
            for (int offset = 0; offset < data.length; offset += (alias.length() + 1) * 2) {
                alias = MPPUtility.getUnicodeString(data, offset);
                aliases.add(alias);
            }
            this.m_file.setTaskFieldAlias(TaskField.TEXT1, (String)aliases.get(118));
            this.m_file.setTaskFieldAlias(TaskField.TEXT2, (String)aliases.get(119));
            this.m_file.setTaskFieldAlias(TaskField.TEXT3, (String)aliases.get(120));
            this.m_file.setTaskFieldAlias(TaskField.TEXT4, (String)aliases.get(121));
            this.m_file.setTaskFieldAlias(TaskField.TEXT5, (String)aliases.get(122));
            this.m_file.setTaskFieldAlias(TaskField.TEXT6, (String)aliases.get(123));
            this.m_file.setTaskFieldAlias(TaskField.TEXT7, (String)aliases.get(124));
            this.m_file.setTaskFieldAlias(TaskField.TEXT8, (String)aliases.get(125));
            this.m_file.setTaskFieldAlias(TaskField.TEXT9, (String)aliases.get(126));
            this.m_file.setTaskFieldAlias(TaskField.TEXT10, (String)aliases.get(127));
            this.m_file.setTaskFieldAlias(TaskField.START1, (String)aliases.get(128));
            this.m_file.setTaskFieldAlias(TaskField.FINISH1, (String)aliases.get(129));
            this.m_file.setTaskFieldAlias(TaskField.START2, (String)aliases.get(130));
            this.m_file.setTaskFieldAlias(TaskField.FINISH2, (String)aliases.get(131));
            this.m_file.setTaskFieldAlias(TaskField.START3, (String)aliases.get(132));
            this.m_file.setTaskFieldAlias(TaskField.FINISH3, (String)aliases.get(133));
            this.m_file.setTaskFieldAlias(TaskField.START4, (String)aliases.get(134));
            this.m_file.setTaskFieldAlias(TaskField.FINISH4, (String)aliases.get(135));
            this.m_file.setTaskFieldAlias(TaskField.START5, (String)aliases.get(136));
            this.m_file.setTaskFieldAlias(TaskField.FINISH5, (String)aliases.get(137));
            this.m_file.setTaskFieldAlias(TaskField.START6, (String)aliases.get(138));
            this.m_file.setTaskFieldAlias(TaskField.FINISH6, (String)aliases.get(139));
            this.m_file.setTaskFieldAlias(TaskField.START7, (String)aliases.get(140));
            this.m_file.setTaskFieldAlias(TaskField.FINISH7, (String)aliases.get(141));
            this.m_file.setTaskFieldAlias(TaskField.START8, (String)aliases.get(142));
            this.m_file.setTaskFieldAlias(TaskField.FINISH8, (String)aliases.get(143));
            this.m_file.setTaskFieldAlias(TaskField.START9, (String)aliases.get(144));
            this.m_file.setTaskFieldAlias(TaskField.FINISH9, (String)aliases.get(145));
            this.m_file.setTaskFieldAlias(TaskField.START10, (String)aliases.get(146));
            this.m_file.setTaskFieldAlias(TaskField.FINISH10, (String)aliases.get(147));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER1, (String)aliases.get(149));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER2, (String)aliases.get(150));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER3, (String)aliases.get(151));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER4, (String)aliases.get(152));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER5, (String)aliases.get(153));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER6, (String)aliases.get(154));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER7, (String)aliases.get(155));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER8, (String)aliases.get(156));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER9, (String)aliases.get(157));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER10, (String)aliases.get(158));
            this.m_file.setTaskFieldAlias(TaskField.DURATION1, (String)aliases.get(159));
            this.m_file.setTaskFieldAlias(TaskField.DURATION2, (String)aliases.get(161));
            this.m_file.setTaskFieldAlias(TaskField.DURATION3, (String)aliases.get(163));
            this.m_file.setTaskFieldAlias(TaskField.DURATION4, (String)aliases.get(165));
            this.m_file.setTaskFieldAlias(TaskField.DURATION5, (String)aliases.get(167));
            this.m_file.setTaskFieldAlias(TaskField.DURATION6, (String)aliases.get(169));
            this.m_file.setTaskFieldAlias(TaskField.DURATION7, (String)aliases.get(171));
            this.m_file.setTaskFieldAlias(TaskField.DURATION8, (String)aliases.get(173));
            this.m_file.setTaskFieldAlias(TaskField.DURATION9, (String)aliases.get(175));
            this.m_file.setTaskFieldAlias(TaskField.DURATION10, (String)aliases.get(177));
            this.m_file.setTaskFieldAlias(TaskField.DATE1, (String)aliases.get(184));
            this.m_file.setTaskFieldAlias(TaskField.DATE2, (String)aliases.get(185));
            this.m_file.setTaskFieldAlias(TaskField.DATE3, (String)aliases.get(186));
            this.m_file.setTaskFieldAlias(TaskField.DATE4, (String)aliases.get(187));
            this.m_file.setTaskFieldAlias(TaskField.DATE5, (String)aliases.get(188));
            this.m_file.setTaskFieldAlias(TaskField.DATE6, (String)aliases.get(189));
            this.m_file.setTaskFieldAlias(TaskField.DATE7, (String)aliases.get(190));
            this.m_file.setTaskFieldAlias(TaskField.DATE8, (String)aliases.get(191));
            this.m_file.setTaskFieldAlias(TaskField.DATE9, (String)aliases.get(192));
            this.m_file.setTaskFieldAlias(TaskField.DATE10, (String)aliases.get(193));
            this.m_file.setTaskFieldAlias(TaskField.TEXT11, (String)aliases.get(194));
            this.m_file.setTaskFieldAlias(TaskField.TEXT12, (String)aliases.get(195));
            this.m_file.setTaskFieldAlias(TaskField.TEXT13, (String)aliases.get(196));
            this.m_file.setTaskFieldAlias(TaskField.TEXT14, (String)aliases.get(197));
            this.m_file.setTaskFieldAlias(TaskField.TEXT15, (String)aliases.get(198));
            this.m_file.setTaskFieldAlias(TaskField.TEXT16, (String)aliases.get(199));
            this.m_file.setTaskFieldAlias(TaskField.TEXT17, (String)aliases.get(200));
            this.m_file.setTaskFieldAlias(TaskField.TEXT18, (String)aliases.get(201));
            this.m_file.setTaskFieldAlias(TaskField.TEXT19, (String)aliases.get(202));
            this.m_file.setTaskFieldAlias(TaskField.TEXT20, (String)aliases.get(203));
            this.m_file.setTaskFieldAlias(TaskField.TEXT21, (String)aliases.get(204));
            this.m_file.setTaskFieldAlias(TaskField.TEXT22, (String)aliases.get(205));
            this.m_file.setTaskFieldAlias(TaskField.TEXT23, (String)aliases.get(206));
            this.m_file.setTaskFieldAlias(TaskField.TEXT24, (String)aliases.get(207));
            this.m_file.setTaskFieldAlias(TaskField.TEXT25, (String)aliases.get(208));
            this.m_file.setTaskFieldAlias(TaskField.TEXT26, (String)aliases.get(209));
            this.m_file.setTaskFieldAlias(TaskField.TEXT27, (String)aliases.get(210));
            this.m_file.setTaskFieldAlias(TaskField.TEXT28, (String)aliases.get(211));
            this.m_file.setTaskFieldAlias(TaskField.TEXT29, (String)aliases.get(212));
            this.m_file.setTaskFieldAlias(TaskField.TEXT30, (String)aliases.get(213));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER11, (String)aliases.get(214));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER12, (String)aliases.get(215));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER13, (String)aliases.get(216));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER14, (String)aliases.get(217));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER15, (String)aliases.get(218));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER16, (String)aliases.get(219));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER17, (String)aliases.get(220));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER18, (String)aliases.get(221));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER19, (String)aliases.get(222));
            this.m_file.setTaskFieldAlias(TaskField.NUMBER20, (String)aliases.get(223));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE1, (String)aliases.get(227));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE2, (String)aliases.get(228));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE3, (String)aliases.get(229));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE4, (String)aliases.get(230));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE5, (String)aliases.get(231));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE6, (String)aliases.get(232));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE7, (String)aliases.get(233));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE8, (String)aliases.get(234));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE9, (String)aliases.get(235));
            this.m_file.setTaskFieldAlias(TaskField.OUTLINE_CODE10, (String)aliases.get(236));
            this.m_file.setTaskFieldAlias(TaskField.FLAG1, (String)aliases.get(237));
            this.m_file.setTaskFieldAlias(TaskField.FLAG2, (String)aliases.get(238));
            this.m_file.setTaskFieldAlias(TaskField.FLAG3, (String)aliases.get(239));
            this.m_file.setTaskFieldAlias(TaskField.FLAG4, (String)aliases.get(240));
            this.m_file.setTaskFieldAlias(TaskField.FLAG5, (String)aliases.get(241));
            this.m_file.setTaskFieldAlias(TaskField.FLAG6, (String)aliases.get(242));
            this.m_file.setTaskFieldAlias(TaskField.FLAG7, (String)aliases.get(243));
            this.m_file.setTaskFieldAlias(TaskField.FLAG8, (String)aliases.get(244));
            this.m_file.setTaskFieldAlias(TaskField.FLAG9, (String)aliases.get(245));
            this.m_file.setTaskFieldAlias(TaskField.FLAG10, (String)aliases.get(246));
            this.m_file.setTaskFieldAlias(TaskField.FLAG11, (String)aliases.get(247));
            this.m_file.setTaskFieldAlias(TaskField.FLAG12, (String)aliases.get(248));
            this.m_file.setTaskFieldAlias(TaskField.FLAG13, (String)aliases.get(249));
            this.m_file.setTaskFieldAlias(TaskField.FLAG14, (String)aliases.get(250));
            this.m_file.setTaskFieldAlias(TaskField.FLAG15, (String)aliases.get(251));
            this.m_file.setTaskFieldAlias(TaskField.FLAG16, (String)aliases.get(252));
            this.m_file.setTaskFieldAlias(TaskField.FLAG17, (String)aliases.get(253));
            this.m_file.setTaskFieldAlias(TaskField.FLAG18, (String)aliases.get(254));
            this.m_file.setTaskFieldAlias(TaskField.FLAG19, (String)aliases.get(255));
            this.m_file.setTaskFieldAlias(TaskField.FLAG20, (String)aliases.get(256));
            this.m_file.setTaskFieldAlias(TaskField.COST1, (String)aliases.get(278));
            this.m_file.setTaskFieldAlias(TaskField.COST2, (String)aliases.get(279));
            this.m_file.setTaskFieldAlias(TaskField.COST3, (String)aliases.get(280));
            this.m_file.setTaskFieldAlias(TaskField.COST4, (String)aliases.get(281));
            this.m_file.setTaskFieldAlias(TaskField.COST5, (String)aliases.get(282));
            this.m_file.setTaskFieldAlias(TaskField.COST6, (String)aliases.get(283));
            this.m_file.setTaskFieldAlias(TaskField.COST7, (String)aliases.get(284));
            this.m_file.setTaskFieldAlias(TaskField.COST8, (String)aliases.get(285));
            this.m_file.setTaskFieldAlias(TaskField.COST9, (String)aliases.get(286));
            this.m_file.setTaskFieldAlias(TaskField.COST10, (String)aliases.get(287));
        }
    }

    private void processTaskFieldCustomValueLists(ProjectFile file, byte[] data) {
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfValueLists = MPPUtility.getInt(data, offset += 4);
            offset += 4;
            int valueListOffset = 0;
            for (int index = 0; index < numberOfValueLists && offset < length; ++index) {
                TaskField field = MPPTaskField.getInstance(MPPUtility.getShort(data, offset));
                offset += 2;
                valueListOffset = MPPUtility.getInt(data, offset += 2);
                offset += 4;
                if (valueListOffset >= data.length) continue;
                int tempOffset = valueListOffset;
                int dataOffset = MPPUtility.getInt(data, tempOffset += 8) + valueListOffset;
                int endDataOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int endDescriptionOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int valuesLength = endDataOffset - dataOffset;
                byte[] values = new byte[valuesLength];
                MPPUtility.getByteArray(data, dataOffset, valuesLength, values, 0);
                file.setTaskFieldValueList(field, this.getTaskFieldValues(file, field, values));
                int descriptionsLength = endDescriptionOffset - endDataOffset;
                byte[] descriptions = new byte[descriptionsLength];
                MPPUtility.getByteArray(data, endDataOffset, descriptionsLength, descriptions, 0);
                file.setTaskFieldDescriptionList(field, this.getTaskFieldDescriptions(descriptions));
            }
        }
    }

    public List<String> getTaskFieldDescriptions(byte[] data) {
        String description;
        if (data == null || data.length == 0) {
            return null;
        }
        LinkedList<String> descriptions = new LinkedList<String>();
        for (int offset = 0; offset < data.length; offset += description.length() * 2 + 2) {
            description = MPPUtility.getUnicodeString(data, offset);
            descriptions.add(description);
        }
        return descriptions;
    }

    public List<Object> getTaskFieldValues(ProjectFile file, TaskField field, byte[] data) {
        if (field == null || data == null || data.length == 0) {
            return null;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        switch (field.getDataType()) {
            case DATE: {
                int offset;
                while (offset + 4 <= data.length) {
                    Date date = MPPUtility.getTimestamp(data, offset);
                    list.add(date);
                    offset += 4;
                }
                break;
            }
            case CURRENCY: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberUtility.getDouble(MPPUtility.getDouble(data, offset) / 100.0);
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case NUMERIC: {
                int offset;
                while (offset + 8 <= data.length) {
                    Double number = NumberUtility.getDouble(MPPUtility.getDouble(data, offset));
                    list.add(number);
                    offset += 8;
                }
                break;
            }
            case DURATION: {
                int offset;
                while (offset + 6 <= data.length) {
                    Duration duration = MPPUtility.getAdjustedDuration(file, MPPUtility.getInt(data, offset), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, offset + 4)));
                    list.add(duration);
                    offset += 6;
                }
                break;
            }
            case STRING: {
                String s;
                int offset;
                for (offset = 0; offset < data.length; offset += s.length() * 2 + 2) {
                    s = MPPUtility.getUnicodeString(data, offset);
                    list.add(s);
                }
                break;
            }
            case BOOLEAN: {
                int offset;
                while (offset + 2 <= data.length) {
                    boolean b2 = MPPUtility.getShort(data, offset) == 1;
                    list.add(b2);
                    offset += 2;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return list;
    }

    private void processResourceFieldNameAliases(byte[] data) {
        if (data != null) {
            String alias;
            ArrayList<String> aliases = new ArrayList<String>(250);
            for (int offset = 0; offset < data.length; offset += (alias.length() + 1) * 2) {
                alias = MPPUtility.getUnicodeString(data, offset);
                aliases.add(alias);
            }
            this.m_file.setResourceFieldAlias(ResourceField.TEXT1, (String)aliases.get(52));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT2, (String)aliases.get(53));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT3, (String)aliases.get(54));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT4, (String)aliases.get(55));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT5, (String)aliases.get(56));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT6, (String)aliases.get(57));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT7, (String)aliases.get(58));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT8, (String)aliases.get(59));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT9, (String)aliases.get(60));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT10, (String)aliases.get(61));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT11, (String)aliases.get(62));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT12, (String)aliases.get(63));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT13, (String)aliases.get(64));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT14, (String)aliases.get(65));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT15, (String)aliases.get(66));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT16, (String)aliases.get(67));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT17, (String)aliases.get(68));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT18, (String)aliases.get(69));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT19, (String)aliases.get(70));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT20, (String)aliases.get(71));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT21, (String)aliases.get(72));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT22, (String)aliases.get(73));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT23, (String)aliases.get(74));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT24, (String)aliases.get(75));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT25, (String)aliases.get(76));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT26, (String)aliases.get(77));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT27, (String)aliases.get(78));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT28, (String)aliases.get(79));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT29, (String)aliases.get(80));
            this.m_file.setResourceFieldAlias(ResourceField.TEXT30, (String)aliases.get(81));
            this.m_file.setResourceFieldAlias(ResourceField.START1, (String)aliases.get(82));
            this.m_file.setResourceFieldAlias(ResourceField.START2, (String)aliases.get(83));
            this.m_file.setResourceFieldAlias(ResourceField.START3, (String)aliases.get(84));
            this.m_file.setResourceFieldAlias(ResourceField.START4, (String)aliases.get(85));
            this.m_file.setResourceFieldAlias(ResourceField.START5, (String)aliases.get(86));
            this.m_file.setResourceFieldAlias(ResourceField.START6, (String)aliases.get(87));
            this.m_file.setResourceFieldAlias(ResourceField.START7, (String)aliases.get(88));
            this.m_file.setResourceFieldAlias(ResourceField.START8, (String)aliases.get(89));
            this.m_file.setResourceFieldAlias(ResourceField.START9, (String)aliases.get(90));
            this.m_file.setResourceFieldAlias(ResourceField.START10, (String)aliases.get(91));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH1, (String)aliases.get(92));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH2, (String)aliases.get(93));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH3, (String)aliases.get(94));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH4, (String)aliases.get(95));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH5, (String)aliases.get(96));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH6, (String)aliases.get(97));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH7, (String)aliases.get(98));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH8, (String)aliases.get(99));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH9, (String)aliases.get(100));
            this.m_file.setResourceFieldAlias(ResourceField.FINISH10, (String)aliases.get(101));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER1, (String)aliases.get(102));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER2, (String)aliases.get(103));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER3, (String)aliases.get(104));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER4, (String)aliases.get(105));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER5, (String)aliases.get(106));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER6, (String)aliases.get(107));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER7, (String)aliases.get(108));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER8, (String)aliases.get(109));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER9, (String)aliases.get(110));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER10, (String)aliases.get(111));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER11, (String)aliases.get(112));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER12, (String)aliases.get(113));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER13, (String)aliases.get(114));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER14, (String)aliases.get(115));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER15, (String)aliases.get(116));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER16, (String)aliases.get(117));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER17, (String)aliases.get(118));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER18, (String)aliases.get(119));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER19, (String)aliases.get(120));
            this.m_file.setResourceFieldAlias(ResourceField.NUMBER20, (String)aliases.get(121));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION1, (String)aliases.get(122));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION2, (String)aliases.get(123));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION3, (String)aliases.get(124));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION4, (String)aliases.get(125));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION5, (String)aliases.get(126));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION6, (String)aliases.get(127));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION7, (String)aliases.get(128));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION8, (String)aliases.get(129));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION9, (String)aliases.get(130));
            this.m_file.setResourceFieldAlias(ResourceField.DURATION10, (String)aliases.get(131));
            this.m_file.setResourceFieldAlias(ResourceField.DATE1, (String)aliases.get(145));
            this.m_file.setResourceFieldAlias(ResourceField.DATE2, (String)aliases.get(146));
            this.m_file.setResourceFieldAlias(ResourceField.DATE3, (String)aliases.get(147));
            this.m_file.setResourceFieldAlias(ResourceField.DATE4, (String)aliases.get(148));
            this.m_file.setResourceFieldAlias(ResourceField.DATE5, (String)aliases.get(149));
            this.m_file.setResourceFieldAlias(ResourceField.DATE6, (String)aliases.get(150));
            this.m_file.setResourceFieldAlias(ResourceField.DATE7, (String)aliases.get(151));
            this.m_file.setResourceFieldAlias(ResourceField.DATE8, (String)aliases.get(152));
            this.m_file.setResourceFieldAlias(ResourceField.DATE9, (String)aliases.get(153));
            this.m_file.setResourceFieldAlias(ResourceField.DATE10, (String)aliases.get(154));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE1, (String)aliases.get(155));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE2, (String)aliases.get(156));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE3, (String)aliases.get(157));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE4, (String)aliases.get(158));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE5, (String)aliases.get(159));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE6, (String)aliases.get(160));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE7, (String)aliases.get(161));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE8, (String)aliases.get(162));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE9, (String)aliases.get(163));
            this.m_file.setResourceFieldAlias(ResourceField.OUTLINE_CODE10, (String)aliases.get(164));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG10, (String)aliases.get(165));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG1, (String)aliases.get(166));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG2, (String)aliases.get(167));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG3, (String)aliases.get(168));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG4, (String)aliases.get(169));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG5, (String)aliases.get(170));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG6, (String)aliases.get(171));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG7, (String)aliases.get(172));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG8, (String)aliases.get(173));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG9, (String)aliases.get(174));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG11, (String)aliases.get(175));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG12, (String)aliases.get(176));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG13, (String)aliases.get(177));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG14, (String)aliases.get(178));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG15, (String)aliases.get(179));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG16, (String)aliases.get(180));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG17, (String)aliases.get(181));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG18, (String)aliases.get(182));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG19, (String)aliases.get(183));
            this.m_file.setResourceFieldAlias(ResourceField.FLAG20, (String)aliases.get(184));
            this.m_file.setResourceFieldAlias(ResourceField.COST1, (String)aliases.get(207));
            this.m_file.setResourceFieldAlias(ResourceField.COST2, (String)aliases.get(208));
            this.m_file.setResourceFieldAlias(ResourceField.COST3, (String)aliases.get(209));
            this.m_file.setResourceFieldAlias(ResourceField.COST4, (String)aliases.get(210));
            this.m_file.setResourceFieldAlias(ResourceField.COST5, (String)aliases.get(211));
            this.m_file.setResourceFieldAlias(ResourceField.COST6, (String)aliases.get(212));
            this.m_file.setResourceFieldAlias(ResourceField.COST7, (String)aliases.get(213));
            this.m_file.setResourceFieldAlias(ResourceField.COST8, (String)aliases.get(214));
            this.m_file.setResourceFieldAlias(ResourceField.COST9, (String)aliases.get(215));
            this.m_file.setResourceFieldAlias(ResourceField.COST10, (String)aliases.get(216));
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta taskFixedMeta, FixedData taskFixedData) {
        TreeMap<Integer, Integer> taskMap = new TreeMap<Integer, Integer>();
        int itemCount = taskFixedMeta.getItemCount();
        this.m_highestEmptyTaskID = -1;
        int emptyTaskID = -1;
        for (int loop = 3; loop < itemCount; ++loop) {
            Integer key;
            int uniqueID;
            byte[] data = taskFixedData.getByteArrayValue(loop);
            if (data == null) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(loop);
            int metaDataItemSize = MPPUtility.getInt(metaData, 0);
            if (metaDataItemSize == 2 || metaDataItemSize == 6) {
                uniqueID = MPPUtility.getShort(data, 0);
                key = uniqueID;
                if (taskMap.containsKey(key)) continue;
                taskMap.put(key, null);
                continue;
            }
            if (metaDataItemSize == 4) {
                emptyTaskID = MPPUtility.getInt(data, 4);
                if (this.m_highestEmptyTaskID >= emptyTaskID) continue;
                this.m_highestEmptyTaskID = emptyTaskID;
                continue;
            }
            if (data.length != 8 && data.length <= fieldMap.getMaxFixedDataOffset(0) || taskMap.containsKey(key = Integer.valueOf(uniqueID = MPPUtility.getInt(data, 0)))) continue;
            taskMap.put(key, loop);
        }
        return taskMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta rscFixedMeta, FixedData rscFixedData) {
        TreeMap<Integer, Integer> resourceMap = new TreeMap<Integer, Integer>();
        int itemCount = rscFixedMeta.getItemCount();
        for (int loop = 0; loop < itemCount; ++loop) {
            byte[] data = rscFixedData.getByteArrayValue(loop);
            if (data == null || data.length <= fieldMap.getMaxFixedDataOffset(0)) continue;
            Integer uniqueID = MPPUtility.getShort(data, 0);
            resourceMap.put(uniqueID, loop);
        }
        return resourceMap;
    }

    private void processCalendarData() throws IOException {
        DirectoryEntry calDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        VarMeta9 calVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)calDir.getEntry("VarMeta")));
        Var2Data calVarData = new Var2Data(calVarMeta, new DocumentInputStream((DocumentEntry)calDir.getEntry("Var2Data")));
        FixedMeta calFixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)calDir.getEntry("FixedMeta")), 10);
        FixedData calFixedData = new FixedData(calFixedMeta, this.getEncryptableInputStream(calDir, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> calendarMap = new HashMap<Integer, ProjectCalendar>();
        int items = calFixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> baseCalendars = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] defaultCalendarData = this.m_projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar defaultCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(defaultCalendarData, null, defaultCalendar, true);
        for (int loop = 0; loop < items; ++loop) {
            byte[] fixedData = calFixedData.getByteArrayValue(loop);
            if (fixedData == null || fixedData.length < 8) continue;
            int offset = 0;
            while (offset + 12 <= fixedData.length) {
                Integer calendarID = MPPUtility.getInt(fixedData, offset + 0);
                int baseCalendarID = MPPUtility.getInt(fixedData, offset + 4);
                if (calendarID != -1 && calendarID != 0 && baseCalendarID != 0 && !calendarMap.containsKey(calendarID)) {
                    ProjectCalendar cal;
                    byte[] varData = calVarData.getByteArray(calendarID, CALENDAR_DATA);
                    if (baseCalendarID == -1) {
                        if (varData != null || defaultCalendarData != null) {
                            cal = this.m_file.addBaseCalendar();
                            if (varData == null) {
                                varData = defaultCalendarData;
                            }
                        } else {
                            cal = this.m_file.addDefaultBaseCalendar();
                        }
                        cal.setName(calVarData.getUnicodeString(calendarID, CALENDAR_NAME));
                    } else {
                        cal = varData != null ? this.m_file.addResourceCalendar() : this.m_file.getDefaultResourceCalendar();
                        baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                        Integer resourceID = MPPUtility.getInt(fixedData, offset + 8);
                        this.m_resourceMap.put(resourceID, cal);
                    }
                    cal.setUniqueID(calendarID);
                    if (varData != null) {
                        this.processCalendarHours(varData, defaultCalendar, cal, baseCalendarID == -1);
                        this.processCalendarExceptions(varData, cal);
                    }
                    calendarMap.put(calendarID, cal);
                    this.m_file.fireCalendarReadEvent(cal);
                }
                offset += 12;
            }
        }
        this.updateBaseCalendarNames(baseCalendars, calendarMap);
    }

    private void processCalendarHours(byte[] data, ProjectCalendar defaultCalendar, ProjectCalendar cal, boolean isBaseCalendar) {
        for (int index = 0; index < 7; ++index) {
            ProjectCalendarHours hours;
            int offset = 4 + 60 * index;
            int defaultFlag = data == null ? 1 : MPPUtility.getShort(data, offset);
            Day day = Day.getInstance(index + 1);
            if (defaultFlag == 1) {
                if (isBaseCalendar) {
                    if (defaultCalendar == null) {
                        cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                        if (!cal.isWorkingDay(day)) continue;
                        hours = cal.addCalendarHours(Day.getInstance(index + 1));
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    boolean workingDay = defaultCalendar.isWorkingDay(day);
                    cal.setWorkingDay(day, workingDay);
                    if (!workingDay) continue;
                    hours = cal.addCalendarHours(Day.getInstance(index + 1));
                    for (DateRange range : defaultCalendar.getHours(day)) {
                        hours.addRange(range);
                    }
                    continue;
                }
                cal.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            int periodCount = MPPUtility.getShort(data, offset + 2);
            if (periodCount == 0) {
                cal.setWorkingDay(day, false);
                continue;
            }
            cal.setWorkingDay(day, true);
            hours = cal.addCalendarHours(Day.getInstance(index + 1));
            for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                Date start = MPPUtility.getTime(data, offset + 8 + periodIndex * 2);
                long duration = MPPUtility.getDuration(data, offset + 20 + periodIndex * 4);
                hours.addRange(new DateRange(start, new Date(start.getTime() + duration)));
            }
        }
    }

    private void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        int exceptionCount = MPPUtility.getShort(data, 0);
        if (exceptionCount != 0) {
            for (int index = 0; index < exceptionCount; ++index) {
                int offset = 424 + index * 64;
                Date fromDate = MPPUtility.getDate(data, offset);
                Date toDate = MPPUtility.getDate(data, offset + 2);
                ProjectCalendarException exception = cal.addCalendarException(fromDate, toDate);
                int periodCount = MPPUtility.getShort(data, offset + 6);
                if (periodCount == 0) continue;
                for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                    Date start = MPPUtility.getTime(data, offset + 12 + exceptionPeriodIndex * 2);
                    long duration = MPPUtility.getDuration(data, offset + 24 + exceptionPeriodIndex * 4);
                    exception.addRange(new DateRange(start, new Date(start.getTime() + duration)));
                }
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars, HashMap<Integer, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal != null && baseCal.getName() != null) {
                cal.setParent(baseCal);
                continue;
            }
            this.m_file.removeCalendar(cal);
        }
    }

    private void processTaskData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file);
        fieldMap.createTaskFieldMap(this.m_projectProps);
        DirectoryEntry taskDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta9 taskVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)taskDir.getEntry("VarMeta")));
        Var2Data taskVarData = new Var2Data(taskVarMeta, new DocumentInputStream((DocumentEntry)taskDir.getEntry("Var2Data")));
        FixedMeta taskFixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)taskDir.getEntry("FixedMeta")), 47);
        FixedData taskFixedData = new FixedData(taskFixedMeta, this.getEncryptableInputStream(taskDir, "FixedData"), 768, fieldMap.getMaxFixedDataOffset(0));
        TreeMap<Integer, Integer> taskMap = this.createTaskMap(fieldMap, taskFixedMeta, taskFixedData);
        Object[] uniqueid = taskMap.keySet().toArray();
        boolean autoWBS = true;
        LinkedList<Task> externalTasks = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        RTFUtility rtf = new RTFUtility();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            ProjectCalendar calendar;
            Integer calendarID;
            String notes;
            Task task;
            Integer id = (Integer)uniqueid[loop];
            Integer offset = taskMap.get(id);
            if (!taskFixedData.isValidOffset(offset)) continue;
            byte[] data = taskFixedData.getByteArrayValue(offset);
            if (data.length == 8) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(MPPUtility.getInt(data, 4));
                continue;
            }
            if (data.length < fieldMap.getMaxFixedDataOffset(0) || id != 0 && !taskVarMeta.containsKey(id)) continue;
            byte[] metaData = taskFixedMeta.getByteArrayValue(offset);
            byte[] recurringData = taskVarData.getByteArray(id, fieldMap.getVarDataKey(TaskField.RECURRING_DATA));
            Task temp = this.m_file.getTaskByID(MPPUtility.getInt(data, 4));
            if (temp != null) {
                if (!taskVarMeta.getUniqueIdentifierSet().contains(id)) continue;
                if (temp.getName() == null) {
                    this.m_file.removeTask(temp);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap.populateContainer(task, id, new byte[][]{data}, taskVarData);
            task.enableEvents();
            task.setEffortDriven((metaData[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(data, fieldMap.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            task.setExpanded((metaData[12] & 2) == 0);
            Integer externalTaskID = task.getSubprojectTaskID();
            if (externalTaskID != null && externalTaskID != 0) {
                task.setSubprojectTaskID(externalTaskID);
                task.setExternalTask(true);
                externalTasks.add(task);
            }
            task.setFlag1((metaData[37] & 0x20) != 0);
            task.setFlag2((metaData[37] & 0x40) != 0);
            task.setFlag3((metaData[37] & 0x80) != 0);
            task.setFlag4((metaData[38] & 1) != 0);
            task.setFlag5((metaData[38] & 2) != 0);
            task.setFlag6((metaData[38] & 4) != 0);
            task.setFlag7((metaData[38] & 8) != 0);
            task.setFlag8((metaData[38] & 0x10) != 0);
            task.setFlag9((metaData[38] & 0x20) != 0);
            task.setFlag10((metaData[38] & 0x40) != 0);
            task.setFlag11((metaData[38] & 0x80) != 0);
            task.setFlag12((metaData[39] & 1) != 0);
            task.setFlag13((metaData[39] & 2) != 0);
            task.setFlag14((metaData[39] & 4) != 0);
            task.setFlag15((metaData[39] & 8) != 0);
            task.setFlag16((metaData[39] & 0x10) != 0);
            task.setFlag17((metaData[39] & 0x20) != 0);
            task.setFlag18((metaData[39] & 0x40) != 0);
            task.setFlag19((metaData[39] & 0x80) != 0);
            task.setFlag20((metaData[40] & 1) != 0);
            task.setHideBar((metaData[10] & 0x80) != 0);
            this.processHyperlinkData(task, taskVarData.getByteArray(id, fieldMap.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(MPPUtility.getInt(data, 4));
            task.setIgnoreResourceCalendar((metaData[10] & 2) != 0);
            task.setLevelAssignments((metaData[13] & 4) != 0);
            task.setLevelingCanSplit((metaData[13] & 2) != 0);
            task.setMarked((metaData[9] & 0x40) != 0);
            task.setMilestone((metaData[8] & 0x20) != 0);
            task.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            task.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)task.getCachedValue(TaskField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            task.setRollup((metaData[10] & 8) != 0);
            task.setUniqueID(id);
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateUtility.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateUtility.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateUtility.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (recurringData != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file);
                }
                recurringTaskReader.processRecurringTask(task, recurringData);
                task.setRecurring(true);
            }
            if ((notes = task.getNotes()) != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = rtf.strip(notes);
                }
                task.setNotes(notes);
            }
            if ((calendarID = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID)) != null && calendarID != -1 && (calendar = this.m_file.getBaseCalendarByUniqueID(calendarID)) != null) {
                task.setCalendar(calendar);
            }
            SubProject sp = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject(sp);
            if (sp != null) {
                task.setExternalTask(sp.isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(sp.getFullPath());
                }
            }
            if (task.getWBS() != null) {
                autoWBS = false;
            }
            if ((metaData[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(id);
                task.setID(MPPUtility.getInt(data, 4));
                continue;
            }
            this.processTaskEnterpriseColumns(fieldMap, task, taskVarData);
            this.m_file.fireTaskReadEvent(task);
        }
        this.m_file.setAutoWBS(autoWBS);
        if (!externalTasks.isEmpty()) {
            this.processExternalTasks(externalTasks);
        }
    }

    private void processTaskEnterpriseColumns(FieldMap fieldMap, Task task, Var2Data taskVarData) {
        byte[] data = null;
        Integer varDataKey = fieldMap.getVarDataKey(TaskField.ENTERPRISE_DATA);
        if (varDataKey != null) {
            data = taskVarData.getByteArray(task.getUniqueID(), varDataKey);
        }
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xB400000;
                TaskField field = MPPTaskField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case WORK: {
                        double durationValueInHours = MPPUtility.getDouble(props.getByteArray(key)) / 60000.0;
                        value = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        break;
                    }
                    case DURATION: {
                        byte[] durationData = props.getByteArray(key);
                        double durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = durationData.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        field = null;
                        int bits = props.getInt(key);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                        task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                    case PERCENTAGE: {
                        value = props.getShort(key);
                        break;
                    }
                }
                task.set((FieldType)field, value);
            }
        }
    }

    private void processResourceEnterpriseColumns(FieldMap fieldMap, Resource resource, Var2Data resourceVarData) {
        byte[] data = null;
        Integer varDataKey = fieldMap.getVarDataKey(ResourceField.ENTERPRISE_DATA);
        if (varDataKey != null) {
            data = resourceVarData.getByteArray(resource.getUniqueID(), varDataKey);
        }
        if (data != null) {
            PropsBlock props = new PropsBlock(data);
            resource.setCreationDate(props.getTimestamp(Props.RESOURCE_CREATION_DATE));
            for (Integer key : props.keySet()) {
                int keyValue = key - 0xC400000;
                ResourceField field = MPPResourceField.getInstance(keyValue);
                if (field == null) continue;
                Object value = null;
                switch (field.getDataType()) {
                    case CURRENCY: {
                        value = props.getDouble(key) / 100.0;
                        break;
                    }
                    case DATE: {
                        value = props.getTimestamp(key);
                        break;
                    }
                    case DURATION: {
                        byte[] durationData = props.getByteArray(key);
                        double durationValueInHours = (double)MPPUtility.getInt(durationData, 0) / 600.0;
                        TimeUnit durationUnits = durationData.length < 6 ? TimeUnit.DAYS : MPPUtility.getDurationTimeUnits(MPPUtility.getShort(durationData, 4));
                        Duration duration = Duration.getInstance(durationValueInHours, TimeUnit.HOURS);
                        value = duration.convertUnits(durationUnits, this.m_file.getProjectHeader());
                        break;
                    }
                    case BOOLEAN: {
                        field = null;
                        int bits = props.getInt(key);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (bits & 2) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (bits & 4) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (bits & 8) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (bits & 0x10) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (bits & 0x20) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (bits & 0x40) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (bits & 0x80) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (bits & 0x100) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (bits & 0x200) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (bits & 0x400) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (bits & 0x800) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (bits & 0x1000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (bits & 0x2000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (bits & 0x4000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (bits & 0x8000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (bits & 0x10000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (bits & 0x20000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (bits & 0x40000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (bits & 0x80000) != 0 ? 1 : 0);
                        resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (bits & 0x100000) != 0 ? 1 : 0);
                        break;
                    }
                    case NUMERIC: {
                        value = props.getDouble(key);
                        break;
                    }
                    case STRING: {
                        value = props.getUnicodeString(key);
                        break;
                    }
                }
                resource.set((FieldType)field, value);
            }
        }
    }

    private void processExternalTasks(List<Task> externalTasks) {
        Collections.sort(externalTasks);
        SubProject currentSubProject = null;
        for (Task currentTask : externalTasks) {
            SubProject sp = currentTask.getSubProject();
            if (sp == null) {
                currentTask.setSubProject(currentSubProject);
                if (currentSubProject != null) {
                    currentTask.setExternalTaskProject(currentSubProject.getFullPath());
                }
            } else {
                currentSubProject = sp;
            }
            if (currentSubProject == null) continue;
            currentTask.setProject(currentSubProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            task.setHyperlink(hyperlink);
            task.setHyperlinkAddress(address);
            task.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            resource.setHyperlink(hyperlink);
            resource.setHyperlinkAddress(address);
            resource.setHyperlinkSubAddress(subaddress);
        }
    }

    private void processConstraintData() throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            consDir = null;
        }
        if (consDir != null) {
            FixedMeta consFixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)consDir.getEntry("FixedMeta")), 10);
            FixedData consFixedData = new FixedData(consFixedMeta, 20, this.getEncryptableInputStream(consDir, "FixedData"));
            int count = consFixedMeta.getItemCount();
            int lastConstraintID = -1;
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                byte[] data;
                int constraintID;
                int index;
                byte[] metaData = consFixedMeta.getByteArrayValue(loop);
                if (MPPUtility.getShort(metaData, 0) != 0 || (index = consFixedData.getIndexFromOffset(MPPUtility.getInt(metaData, 4))) == -1 || (constraintID = MPPUtility.getInt(data = consFixedData.getByteArrayValue(index), 0)) <= lastConstraintID) continue;
                lastConstraintID = constraintID;
                int taskID1 = MPPUtility.getInt(data, 4);
                if (taskID1 == (taskID2 = MPPUtility.getInt(data, 8))) continue;
                Task task1 = this.m_file.getTaskByUniqueID(taskID1);
                Task task2 = this.m_file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                RelationType type = RelationType.getInstance(MPPUtility.getShort(data, 12));
                TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 14));
                Duration lag = MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(data, 16), durationUnits);
                Relation relation = task2.addPredecessor(task1, type, lag);
                this.m_file.fireRelationReadEvent(relation);
            }
        }
    }

    private void processResourceData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file);
        fieldMap.createResourceFieldMap(this.m_projectProps);
        DirectoryEntry rscDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta9 rscVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)rscDir.getEntry("VarMeta")));
        Var2Data rscVarData = new Var2Data(rscVarMeta, new DocumentInputStream((DocumentEntry)rscDir.getEntry("Var2Data")));
        FixedMeta rscFixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)rscDir.getEntry("FixedMeta")), 37);
        FixedData rscFixedData = new FixedData(rscFixedMeta, this.getEncryptableInputStream(rscDir, "FixedData"));
        TreeMap<Integer, Integer> resourceMap = this.createResourceMap(fieldMap, rscFixedMeta, rscFixedData);
        Integer[] uniqueid = rscVarMeta.getUniqueIdentifierArray();
        RTFUtility rtf = new RTFUtility();
        for (int loop = 0; loop < uniqueid.length; ++loop) {
            Integer id = uniqueid[loop];
            Integer offset = resourceMap.get(id);
            if (offset == null) continue;
            byte[] data = rscFixedData.getByteArrayValue(offset);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap.populateContainer(resource, id, new byte[][]{data}, rscVarData);
            resource.enableEvents();
            this.processHyperlinkData(resource, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(data, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE1_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE2_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE3_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE4_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE5_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE6_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE7_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE8_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE9_INDEX), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString((Integer)resource.getCachedValue(ResourceField.OUTLINE_CODE10_INDEX), OUTLINECODE_DATA));
            resource.setType(MPPUtility.getShort(data, fieldMap.getFixedDataOffset(ResourceField.WORKGROUP)) == 0 ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(id);
            byte[] metaData = rscFixedMeta.getByteArrayValue(offset);
            resource.setFlag1((metaData[28] & 0x40) != 0);
            resource.setFlag2((metaData[28] & 0x80) != 0);
            resource.setFlag3((metaData[29] & 1) != 0);
            resource.setFlag4((metaData[29] & 2) != 0);
            resource.setFlag5((metaData[29] & 4) != 0);
            resource.setFlag6((metaData[29] & 8) != 0);
            resource.setFlag7((metaData[29] & 0x10) != 0);
            resource.setFlag8((metaData[29] & 0x20) != 0);
            resource.setFlag9((metaData[29] & 0x40) != 0);
            resource.setFlag10((metaData[28] & 0x20) != 0);
            resource.setFlag11((metaData[29] & 0x20) != 0);
            resource.setFlag12((metaData[30] & 1) != 0);
            resource.setFlag13((metaData[30] & 2) != 0);
            resource.setFlag14((metaData[30] & 4) != 0);
            resource.setFlag15((metaData[30] & 8) != 0);
            resource.setFlag16((metaData[30] & 0x10) != 0);
            resource.setFlag17((metaData[30] & 0x20) != 0);
            resource.setFlag18((metaData[30] & 0x40) != 0);
            resource.setFlag19((metaData[30] & 0x80) != 0);
            resource.setFlag20((metaData[31] & 1) != 0);
            String notes = resource.getNotes();
            if (notes != null) {
                if (!this.m_reader.getPreserveNoteFormatting()) {
                    notes = rtf.strip(notes);
                }
                resource.setNotes(notes);
            }
            resource.setResourceCalendar(this.m_resourceMap.get(id));
            this.processResourceEnterpriseColumns(fieldMap, resource, rscVarData);
            CostRateTableFactory crt = new CostRateTableFactory();
            crt.process(resource, 0, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_A)));
            crt.process(resource, 1, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_B)));
            crt.process(resource, 2, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_C)));
            crt.process(resource, 3, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_D)));
            crt.process(resource, 4, rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory af = new AvailabilityFactory();
            af.process(resource.getAvailability(), rscVarData.getByteArray(id, fieldMap.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_file.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap9 fieldMap = new FieldMap9(this.m_file);
        fieldMap.createAssignmentFieldMap(this.m_projectProps);
        DirectoryEntry assnDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta9 assnVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)assnDir.getEntry("VarMeta")));
        Var2Data assnVarData = new Var2Data(assnVarMeta, new DocumentInputStream((DocumentEntry)assnDir.getEntry("Var2Data")));
        FixedMeta assnFixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)assnDir.getEntry("FixedMeta")), 34);
        FixedData assnFixedData = new FixedData(142, this.getEncryptableInputStream(assnDir, "FixedData"));
        if (assnFixedData.getItemCount() != assnFixedMeta.getItemCount()) {
            assnFixedData = new FixedData(assnFixedMeta, this.getEncryptableInputStream(assnDir, "FixedData"));
        }
        ResourceAssignmentFactory factory = new ResourceAssignmentFactory();
        factory.process(this.m_file, fieldMap, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), assnVarMeta, assnVarData, assnFixedMeta, assnFixedData, null);
    }

    private boolean getDurationEstimated(int type) {
        return (type & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta9 viewVarMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data viewVarData = new Var2Data(viewVarMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta(new DocumentInputStream((DocumentEntry)dir.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(122, this.getEncryptableInputStream(dir, "FixedData"));
        int items = fixedMeta.getItemCount();
        ViewFactory9 factory = new ViewFactory9();
        int lastOffset = -1;
        for (int loop = 0; loop < items; ++loop) {
            byte[] fm = fixedMeta.getByteArrayValue(loop);
            int offset = MPPUtility.getShort(fm, 4);
            if (offset <= lastOffset) continue;
            byte[] fd = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(offset));
            if (fd != null) {
                View view = factory.createView(this.m_file, fm, fd, viewVarData, this.m_fontBases);
                this.m_file.addView(view);
            }
            lastOffset = offset;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        TableFactory factory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int items = fixedData.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = fixedData.getByteArrayValue(loop);
            Table table = factory.createTable(this.m_file, data, varMeta, varData);
            this.m_file.addTable(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"), true);
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        FilterReader9 reader = new FilterReader9();
        reader.process(this.m_file, fixedData, varData);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedData fixedData = new FixedData(110, this.getEncryptableInputStream(dir, "FixedData"));
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        GroupReader9 reader = new GroupReader9();
        reader.process(this.m_file, fixedData, varData, this.m_fontBases);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry dir = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta9 varMeta = new VarMeta9(new DocumentInputStream((DocumentEntry)dir.getEntry("VarMeta")));
        Var2Data varData = new Var2Data(varMeta, new DocumentInputStream((DocumentEntry)dir.getEntry("Var2Data")));
        InputStream is = this.getEncryptableInputStream(dir, "FixedData");
        byte[] fixedData = new byte[is.available()];
        is.read(fixedData);
        ViewStateReader9 reader = new ViewStateReader9();
        reader.process(this.m_file, varData, fixedData);
    }

    private InputStream getEncryptableInputStream(DirectoryEntry directory, String name) throws IOException {
        DocumentEntry entry = (DocumentEntry)directory.getEntry(name);
        InputStream stream = this.m_file.getEncoded() ? new EncryptedDocumentInputStream(entry, this.m_file.getEncryptionCode()) : new DocumentInputStream(entry);
        return stream;
    }

    private void validateTaskIDs() {
        List<Task> allTasks = this.m_file.getAllTasks();
        if (allTasks.size() > 1) {
            Collections.sort(allTasks);
            int taskID = -1;
            int lastTaskID = -1;
            for (int i = 0; i < allTasks.size(); ++i) {
                Task task = allTasks.get(i);
                taskID = NumberUtility.getInt(task.getID());
                if (!task.getNull() && lastTaskID != -1 && taskID > lastTaskID + 1 && taskID > this.m_highestEmptyTaskID + 1) {
                    task.setNull(true);
                    continue;
                }
                lastTaskID = taskID;
            }
        }
    }
}

