/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.awt.Color;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GenericCriteria;
import net.sf.mpxj.MPPTaskField14;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.ChartPattern;
import net.sf.mpxj.mpp.FilterCriteriaReader14;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.GanttBarDateFormat;
import net.sf.mpxj.mpp.GanttBarStyleFactory14;
import net.sf.mpxj.mpp.GanttChartView;
import net.sf.mpxj.mpp.GridLines;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.TableFontStyle;
import net.sf.mpxj.mpp.TimescaleAlignment;
import net.sf.mpxj.mpp.TimescaleFormat;
import net.sf.mpxj.mpp.TimescaleTier;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.FieldTypeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GanttChartView14
extends GanttChartView {
    private static final Integer PROPERTIES = 6;

    @Override
    protected Integer getPropertiesID() {
        return PROPERTIES;
    }

    @Override
    protected void processDefaultBarStyles(Props props) {
        GanttBarStyleFactory14 f = new GanttBarStyleFactory14();
        this.m_barStyles = f.processDefaultStyles(props);
    }

    @Override
    protected void processExceptionBarStyles(Props props) {
        GanttBarStyleFactory14 f = new GanttBarStyleFactory14();
        this.m_barStyleExceptions = f.processExceptionStyles(props);
    }

    @Override
    protected void processAutoFilters(byte[] data) {
        int filterCount = MPPUtility.getShort(data, 8);
        int offset = 16;
        FilterCriteriaReader14 criteria = new FilterCriteriaReader14();
        for (int loop = 0; loop < filterCount; ++loop) {
            FieldType field = this.getFieldType(data, offset);
            int blockSize = MPPUtility.getShort(data, offset + 4);
            if (blockSize == 0) break;
            GenericCriteria c2 = criteria.process(this.m_parent, data, offset + 12, -1, null, null, null);
            Filter filter = new Filter();
            filter.setCriteria(c2);
            this.m_autoFilters.add(filter);
            this.m_autoFiltersByType.put(field, filter);
            offset += blockSize;
        }
    }

    private FieldType getFieldType(byte[] data, int offset) {
        int fieldIndex = MPPUtility.getInt(data, offset);
        return FieldTypeUtility.getInstance14(fieldIndex);
    }

    @Override
    protected void processViewProperties(Map<Integer, FontBase> fontBases, Props props) {
        byte[] viewPropertyData = props.getByteArray(VIEW_PROPERTIES);
        if (viewPropertyData != null) {
            this.m_highlightedTasksFontStyle = this.getFontStyle(viewPropertyData, 26, fontBases, false);
            this.m_rowAndColumnFontStyle = this.getFontStyle(viewPropertyData, 58, fontBases, false);
            this.m_nonCriticalTasksFontStyle = this.getFontStyle(viewPropertyData, 90, fontBases, false);
            this.m_criticalTasksFontStyle = this.getFontStyle(viewPropertyData, 122, fontBases, false);
            this.m_summaryTasksFontStyle = this.getFontStyle(viewPropertyData, 154, fontBases, false);
            this.m_milestoneTasksFontStyle = this.getFontStyle(viewPropertyData, 186, fontBases, false);
            this.m_middleTimescaleFontStyle = this.getFontStyle(viewPropertyData, 218, fontBases, false);
            this.m_bottomTimescaleFontStyle = this.getFontStyle(viewPropertyData, 250, fontBases, false);
            this.m_barTextLeftFontStyle = this.getFontStyle(viewPropertyData, 282, fontBases, false);
            this.m_barTextRightFontStyle = this.getFontStyle(viewPropertyData, 314, fontBases, false);
            this.m_barTextTopFontStyle = this.getFontStyle(viewPropertyData, 346, fontBases, false);
            this.m_barTextBottomFontStyle = this.getFontStyle(viewPropertyData, 378, fontBases, false);
            this.m_barTextInsideFontStyle = this.getFontStyle(viewPropertyData, 410, fontBases, false);
            this.m_markedTasksFontStyle = this.getFontStyle(viewPropertyData, 442, fontBases, false);
            this.m_projectSummaryTasksFontStyle = this.getFontStyle(viewPropertyData, 474, fontBases, false);
            this.m_externalTasksFontStyle = this.getFontStyle(viewPropertyData, 506, fontBases, false);
            this.m_topTimescaleFontStyle = this.getFontStyle(viewPropertyData, 538, fontBases, false);
            this.m_sheetRowsGridLines = this.getGridLines(viewPropertyData, 667);
            this.m_sheetColumnsGridLines = this.getGridLines(viewPropertyData, 697);
            this.m_titleVerticalGridLines = this.getGridLines(viewPropertyData, 727);
            this.m_titleHorizontalGridLines = this.getGridLines(viewPropertyData, 757);
            this.m_middleTierColumnGridLines = this.getGridLines(viewPropertyData, 787);
            this.m_bottomTierColumnGridLines = this.getGridLines(viewPropertyData, 817);
            this.m_ganttRowsGridLines = this.getGridLines(viewPropertyData, 847);
            this.m_barRowsGridLines = this.getGridLines(viewPropertyData, 877);
            this.m_currentDateGridLines = this.getGridLines(viewPropertyData, 907);
            this.m_pageBreakGridLines = this.getGridLines(viewPropertyData, 937);
            this.m_projectStartGridLines = this.getGridLines(viewPropertyData, 967);
            this.m_projectFinishGridLines = this.getGridLines(viewPropertyData, 997);
            this.m_statusDateGridLines = this.getGridLines(viewPropertyData, 1027);
            this.m_topTierColumnGridLines = this.getGridLines(viewPropertyData, 1057);
            this.m_nonWorkingDaysCalendarName = MPPUtility.getUnicodeString(viewPropertyData, 1422);
            this.m_nonWorkingColor = MPPUtility.getColor(viewPropertyData, 2223);
            this.m_nonWorkingPattern = ChartPattern.getInstance(viewPropertyData[2235]);
            this.m_nonWorkingStyle = NonWorkingTimeStyle.getInstance(viewPropertyData[2222]);
            this.m_timescaleShowTiers = viewPropertyData[41255];
            this.m_timescaleSize = viewPropertyData[1180];
            byte flags = viewPropertyData[1086];
            this.m_timescaleScaleSeparator = (flags & 4) != 0;
            this.m_timescaleTopTier = new TimescaleTier();
            this.m_timescaleTopTier.setTickLines(viewPropertyData[41349] != 0);
            this.m_timescaleTopTier.setUsesFiscalYear((viewPropertyData[41361] & 1) != 0);
            this.m_timescaleTopTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[41311]));
            this.m_timescaleTopTier.setCount(viewPropertyData[41313]);
            this.m_timescaleTopTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(viewPropertyData, 41315)));
            this.m_timescaleTopTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[41317]));
            this.m_timescaleMiddleTier = new TimescaleTier();
            this.m_timescaleMiddleTier.setTickLines((flags & 1) != 0);
            this.m_timescaleMiddleTier.setUsesFiscalYear((flags & 8) != 0);
            this.m_timescaleMiddleTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[1152]));
            this.m_timescaleMiddleTier.setCount(viewPropertyData[1156]);
            this.m_timescaleMiddleTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(viewPropertyData, 1160)));
            this.m_timescaleMiddleTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[1166]));
            this.m_timescaleBottomTier = new TimescaleTier();
            this.m_timescaleBottomTier.setTickLines((flags & 2) != 0);
            this.m_timescaleBottomTier.setUsesFiscalYear((flags & 0x10) != 0);
            this.m_timescaleBottomTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[1154]));
            this.m_timescaleBottomTier.setCount(viewPropertyData[1158]);
            this.m_timescaleBottomTier.setFormat(TimescaleFormat.getInstance(MPPUtility.getShort(viewPropertyData, 1162)));
            this.m_timescaleBottomTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[1164]));
            this.m_showDrawings = viewPropertyData[2237] != 0;
            this.m_roundBarsToWholeDays = viewPropertyData[2239] != 0;
            this.m_showBarSplits = viewPropertyData[2241] != 0;
            this.m_alwaysRollupGanttBars = viewPropertyData[2251] != 0;
            this.m_hideRollupBarsWhenSummaryExpanded = viewPropertyData[2253] != 0;
            this.m_ganttBarHeight = this.mapGanttBarHeight(MPPUtility.getByte(viewPropertyData, 2244));
            this.m_barDateFormat = GanttBarDateFormat.getInstance(viewPropertyData[2247] + 1);
            this.m_linkStyle = LinkStyle.getInstance(viewPropertyData[2236]);
        }
    }

    private GridLines getGridLines(byte[] data, int offset) {
        Color normalLineColor = MPPUtility.getColor(data, offset);
        LineStyle normalLineStyle = LineStyle.getInstance(data[offset + 13]);
        byte intervalNumber = data[offset + 14];
        LineStyle intervalLineStyle = LineStyle.getInstance(data[offset + 15]);
        Color intervalLineColor = MPPUtility.getColor(data, offset + 16);
        return new GridLines(normalLineColor, normalLineStyle, intervalNumber, intervalLineStyle, intervalLineColor);
    }

    protected FontStyle getFontStyle(byte[] data, int offset, Map<Integer, FontBase> fontBases, boolean ignoreBackground) {
        BackgroundPattern backgroundPattern;
        Color backgroundColor;
        Integer index = MPPUtility.getByte(data, offset);
        FontBase fontBase = fontBases.get(index);
        int style = MPPUtility.getByte(data, offset + 3);
        Color color = MPPUtility.getColor(data, offset + 4);
        if (ignoreBackground) {
            backgroundColor = null;
            backgroundPattern = BackgroundPattern.SOLID;
        } else {
            backgroundColor = MPPUtility.getColor(data, offset + 16);
            backgroundPattern = BackgroundPattern.getInstance(MPPUtility.getShort(data, offset + 28));
        }
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        boolean strikethrough = (style & 8) != 0;
        FontStyle fontStyle = new FontStyle(fontBase, italic, bold, underline, strikethrough, color, backgroundColor, backgroundPattern);
        return fontStyle;
    }

    @Override
    protected void processTableFontStyles(Map<Integer, FontBase> fontBases, byte[] columnData) {
        this.m_tableFontStyles = new TableFontStyle[columnData.length / 44];
        int offset = 0;
        for (int loop = 0; loop < this.m_tableFontStyles.length; ++loop) {
            this.m_tableFontStyles[loop] = this.getColumnFontStyle(columnData, offset, fontBases);
            offset += 44;
        }
    }

    @Override
    protected TableFontStyle getColumnFontStyle(byte[] data, int offset, Map<Integer, FontBase> fontBases) {
        int uniqueID = MPPUtility.getInt(data, offset);
        TaskField fieldType = MPPTaskField14.getInstance(MPPUtility.getShort(data, offset + 4));
        Integer index = MPPUtility.getByte(data, offset + 8);
        int style = MPPUtility.getByte(data, offset + 11);
        Color color = MPPUtility.getColor(data, offset + 12);
        int change = MPPUtility.getShort(data, offset + 40);
        Color backgroundColor = MPPUtility.getColor(data, offset + 24);
        BackgroundPattern backgroundPattern = BackgroundPattern.getInstance(MPPUtility.getShort(data, offset + 36));
        FontBase fontBase = fontBases.get(index);
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        boolean strikethrough = (style & 8) != 0;
        boolean boldChanged = (change & 1) != 0;
        boolean underlineChanged = (change & 2) != 0;
        boolean italicChanged = (change & 4) != 0;
        boolean colorChanged = (change & 8) != 0;
        boolean fontChanged = (change & 0x10) != 0;
        boolean backgroundColorChanged = (change & 0x40) != 0;
        boolean backgroundPatternChanged = (change & 0x80) != 0;
        boolean strikethroughChanged = (change & 0x100) != 0;
        TableFontStyle tfs = new TableFontStyle(uniqueID, fieldType, fontBase, italic, bold, underline, strikethrough, color, backgroundColor, backgroundPattern, italicChanged, boldChanged, underlineChanged, strikethroughChanged, colorChanged, fontChanged, backgroundColorChanged, backgroundPatternChanged);
        return tfs;
    }

    @Override
    protected void processProgressLines(Map<Integer, FontBase> fontBases, byte[] progressLineData) {
        this.m_progressLinesEnabled = progressLineData[0] != 0;
        this.m_progressLinesAtCurrentDate = progressLineData[2] != 0;
        this.m_progressLinesAtRecurringIntervals = progressLineData[4] != 0;
        this.m_progressLinesInterval = Interval.getInstance(progressLineData[6]);
        this.m_progressLinesIntervalDailyDayNumber = progressLineData[8];
        this.m_progressLinesIntervalDailyWorkday = progressLineData[10] != 0;
        this.m_progressLinesIntervalWeekleyWeekNumber = progressLineData[12];
        this.m_progressLinesIntervalWeeklyDay[Day.SUNDAY.getValue()] = progressLineData[14] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.MONDAY.getValue()] = progressLineData[16] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.TUESDAY.getValue()] = progressLineData[18] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.WEDNESDAY.getValue()] = progressLineData[20] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.THURSDAY.getValue()] = progressLineData[22] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.FRIDAY.getValue()] = progressLineData[24] != 0;
        this.m_progressLinesIntervalWeeklyDay[Day.SATURDAY.getValue()] = progressLineData[26] != 0;
        this.m_progressLinesIntervalMonthlyDay = progressLineData[32] != 0;
        this.m_progressLinesIntervalMonthlyDayDayNumber = progressLineData[34];
        this.m_progressLinesIntervalMonthlyDayMonthNumber = progressLineData[28];
        this.m_progressLinesIntervalMonthlyFirstLast = progressLineData[40] == 1;
        this.m_progressLinesIntervalMonthlyFirstLastDay = ProgressLineDay.getInstance(progressLineData[36]);
        this.m_progressLinesIntervalMonthlyFirstLastMonthNumber = progressLineData[30];
        this.m_progressLinesBeginAtProjectStart = progressLineData[44] != 0;
        this.m_progressLinesBeginAtDate = MPPUtility.getDate(progressLineData, 46);
        this.m_progressLinesDisplaySelected = progressLineData[48] != 0;
        this.m_progressLinesActualPlan = progressLineData[52] != 0;
        this.m_progressLinesDisplayType = MPPUtility.getShort(progressLineData, 54);
        this.m_progressLinesShowDate = progressLineData[56] != 0;
        this.m_progressLinesDateFormat = MPPUtility.getShort(progressLineData, 58);
        this.m_progressLinesFontStyle = this.getFontStyle(progressLineData, 60, fontBases, true);
        this.m_progressLinesCurrentLineColor = MPPUtility.getColor(progressLineData, 92);
        this.m_progressLinesCurrentLineStyle = LineStyle.getInstance(progressLineData[104]);
        this.m_progressLinesCurrentProgressPointColor = MPPUtility.getColor(progressLineData, 105);
        this.m_progressLinesCurrentProgressPointShape = progressLineData[117];
        this.m_progressLinesOtherLineColor = MPPUtility.getColor(progressLineData, 118);
        this.m_progressLinesOtherLineStyle = LineStyle.getInstance(progressLineData[130]);
        this.m_progressLinesOtherProgressPointColor = MPPUtility.getColor(progressLineData, 131);
        this.m_progressLinesOtherProgressPointShape = progressLineData[143];
        int dateCount = MPPUtility.getShort(progressLineData, 50);
        if (dateCount != 0) {
            this.m_progressLinesDisplaySelectedDates = new Date[dateCount];
            int offset = 144;
            for (int count = 0; count < dateCount && offset < progressLineData.length; offset += 2, ++count) {
                this.m_progressLinesDisplaySelectedDates[count] = MPPUtility.getDate(progressLineData, offset);
            }
        }
    }

    GanttChartView14(ProjectFile parent, byte[] fixedMeta, byte[] fixedData, Var2Data varData, Map<Integer, FontBase> fontBases) throws IOException {
        super(parent, fixedMeta, fixedData, varData, fontBases);
    }
}

