/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.VarMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractVarMeta
extends MPPComponent
implements VarMeta {
    protected int m_unknown1;
    protected int m_itemCount;
    protected int m_unknown2;
    protected int m_unknown3;
    protected int m_dataSize;
    protected int[] m_offsets;
    protected Map<Integer, Map<Integer, Integer>> m_table = new TreeMap<Integer, Map<Integer, Integer>>();

    AbstractVarMeta() {
    }

    @Override
    public int getItemCount() {
        return this.m_itemCount;
    }

    @Override
    public int getDataSize() {
        return this.m_dataSize;
    }

    @Override
    public Integer[] getUniqueIdentifierArray() {
        Integer[] result = new Integer[this.m_table.size()];
        int index = 0;
        Iterator<Integer> i$ = this.m_table.keySet().iterator();
        while (i$.hasNext()) {
            Integer value;
            result[index] = value = i$.next();
            ++index;
        }
        return result;
    }

    @Override
    public Set<Integer> getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    @Override
    public Integer getOffset(Integer id, Integer type) {
        Integer result = null;
        Map<Integer, Integer> map = this.m_table.get(id);
        if (map != null && type != null) {
            result = map.get(type);
        }
        return result;
    }

    @Override
    public int getOffset(int index) {
        return this.m_offsets[index];
    }

    @Override
    public Set<Integer> getTypes(Integer id) {
        Map<Integer, Integer> map = this.m_table.get(id);
        Set<Integer> result = map != null ? map.keySet() : new HashSet<Integer>();
        return result;
    }

    @Override
    public boolean containsKey(Integer key) {
        return this.m_table.containsKey(key);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(FieldMap fieldMap) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: VarMeta");
        pw.println("   Item count: " + this.m_itemCount);
        pw.println("   Data size: " + this.m_dataSize);
        for (Integer uniqueID : this.m_table.keySet()) {
            pw.println("   Entries for Unique ID: " + uniqueID);
            Map<Integer, Integer> map = this.m_table.get(uniqueID);
            for (Integer type : map.keySet()) {
                Integer offset = map.get(type);
                FieldType fieldType = fieldMap == null ? null : fieldMap.getFieldTypeFromVarDataKey(type);
                pw.println("      Type=" + (fieldType == null ? type : fieldType) + " Offset=" + offset);
            }
        }
        pw.println("END: VarMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

