/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.CellViewSkin;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewBehavior;
import impl.org.controlsfx.spreadsheet.GridVirtualFlow;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.HorizontalPicker;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridViewSkin
extends TableViewSkinBase<ObservableList<SpreadsheetCell>, ObservableList<SpreadsheetCell>, TableView<ObservableList<SpreadsheetCell>>, TableViewBehavior<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>, TableColumn<ObservableList<SpreadsheetCell>, ?>> {
    public static final double DEFAULT_CELL_HEIGHT;
    private static final double DATE_CELL_MIN_WIDTH;
    final Map<GridRow, Set<CellView>> deportedCells = new HashMap<GridRow, Set<CellView>>();
    ObservableMap<Integer, Double> rowHeightMap = FXCollections.observableHashMap();
    private GridCellEditor gridCellEditor;
    protected final SpreadsheetHandle handle;
    protected SpreadsheetView spreadsheetView;
    protected VerticalHeader verticalHeader;
    protected HorizontalPicker horizontalPickers;
    private ObservableSet<Integer> currentlyFixedRow = FXCollections.observableSet(new HashSet());
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();
    private double fixedRowHeight = 0.0;
    BitSet hBarValue;
    BitSet rowToLayout;
    RectangleSelection rectangleSelection;
    double fixedColumnWidth;
    BooleanProperty lastRowLayout = new SimpleBooleanProperty(true);
    private final InvalidationListener vbarValueListener = new InvalidationListener(){

        public void invalidated(Observable valueModel) {
            GridViewSkin.this.verticalScroll();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c2) {
            GridViewSkin.this.hBarValue.clear();
            while (c2.next()) {
                if (c2.wasPermutated()) {
                    for (Integer fixedRow : c2.getList()) {
                        GridViewSkin.this.rowToLayout.set((int)fixedRow, true);
                    }
                    continue;
                }
                block2: for (Integer unfixedRow : c2.getRemoved()) {
                    GridViewSkin.this.rowToLayout.set((int)unfixedRow, false);
                    if (GridViewSkin.this.spreadsheetView.getGrid().getRows().size() <= unfixedRow) continue;
                    List myRow = (List)GridViewSkin.this.spreadsheetView.getGrid().getRows().get(unfixedRow.intValue());
                    for (SpreadsheetCell cell : myRow) {
                        if (cell.getRowSpan() <= 1 && cell.getColumnSpan() <= 1) continue;
                        GridViewSkin.this.rowToLayout.set((int)unfixedRow, true);
                        continue block2;
                    }
                }
                for (Integer fixedRow : c2.getAddedSubList()) {
                    GridViewSkin.this.rowToLayout.set((int)fixedRow, true);
                }
            }
            GridViewSkin.this.getFlow().requestLayout();
        }
    };
    private final SetChangeListener<? super Integer> currentlyFixedRowListener = new SetChangeListener<Integer>(){

        public void onChanged(SetChangeListener.Change<? extends Integer> arg0) {
            GridViewSkin.this.computeFixedRowHeight();
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c2) {
            GridViewSkin.this.hBarValue.clear();
            GridViewSkin.this.getFlow().requestLayout();
        }
    };

    public GridViewSkin(final SpreadsheetHandle handle) {
        super((Control)handle.getGridView(), (BehaviorBase)new GridViewBehavior(handle.getGridView()));
        super.init((Control)handle.getGridView());
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.gridCellEditor = new GridCellEditor(handle);
        SpreadsheetGridView tableView = handle.getGridView();
        tableView.setRowFactory((Callback)new Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>(){

            public TableRow<ObservableList<SpreadsheetCell>> call(TableView<ObservableList<SpreadsheetCell>> p) {
                return new GridRow(handle);
            }
        });
        tableView.getStyleClass().add((Object)"cell-spreadsheet");
        this.getCurrentlyFixedRow().addListener(this.currentlyFixedRowListener);
        this.spreadsheetView.getFixedRows().addListener(this.fixedRowsListener);
        this.spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
        handle.getView().gridProperty().addListener((ChangeListener)new ChangeListener<Grid>(){

            public void changed(ObservableValue<? extends Grid> ov, Grid t, Grid t1) {
                GridViewSkin.this.rowToLayout = GridViewSkin.this.initRowToLayoutBitSet();
            }
        });
        this.hBarValue = new BitSet(handle.getView().getGrid().getRowCount());
        this.rowToLayout = this.initRowToLayoutBitSet();
        this.computeFixedRowHeight();
        EventHandler ml = event -> {
            if (tableView.getEditingCell() != null) {
                tableView.edit(-1, null);
            }
            tableView.requestFocus();
        };
        this.getFlow().getVerticalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.getFlow().getHorizontalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        TableViewBehavior behavior = (TableViewBehavior)this.getBehavior();
        behavior.setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onFocusPreviousCell();
            }
        });
        behavior.setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onFocusNextCell();
            }
        });
        behavior.setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onMoveToFirstCell();
            }
        });
        behavior.setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onMoveToLastCell();
            }
        });
        behavior.setOnScrollPageDown((Callback)new Callback<Boolean, Integer>(){

            public Integer call(Boolean isFocusDriven) {
                return GridViewSkin.this.onScrollPageDown(isFocusDriven);
            }
        });
        behavior.setOnScrollPageUp((Callback)new Callback<Boolean, Integer>(){

            public Integer call(Boolean isFocusDriven) {
                return GridViewSkin.this.onScrollPageUp(isFocusDriven);
            }
        });
        behavior.setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onSelectPreviousCell();
            }
        });
        behavior.setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onSelectNextCell();
            }
        });
        behavior.setOnSelectLeftCell(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onSelectLeftCell();
            }
        });
        behavior.setOnSelectRightCell(new Runnable(){

            @Override
            public void run() {
                GridViewSkin.this.onSelectRightCell();
            }
        });
        this.registerChangeListener((ObservableValue)tableView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    public double getRowHeight(int row) {
        Double rowHeightCache = (Double)this.rowHeightMap.get((Object)row);
        if (rowHeightCache == null) {
            double rowHeight = this.handle.getView().getGrid().getRowHeight(row);
            return rowHeight == -1.0 ? DEFAULT_CELL_HEIGHT : rowHeight;
        }
        return rowHeightCache;
    }

    public double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public GridCellEditor getSpreadsheetCellEditorImpl() {
        return this.gridCellEditor;
    }

    public GridRow getRowIndexed(int index) {
        IndexedCell cell;
        List<?> cells = this.getFlow().getCells();
        if (!cells.isEmpty() && index >= (cell = (IndexedCell)cells.get(0)).getIndex() && index - cell.getIndex() < cells.size()) {
            return (GridRow)((Object)cells.get(index - cell.getIndex()));
        }
        for (IndexedCell cell2 : this.getFlow().getFixedCells()) {
            if (cell2.getIndex() != index) continue;
            return (GridRow)cell2;
        }
        return null;
    }

    public GridRow getRow(int index) {
        return (GridRow)((Object)this.getFlow().getCells().get(index));
    }

    public final boolean containsRow(int index) {
        for (Object obj : this.getFlow().getCells()) {
            if (((GridRow)((Object)obj)).getIndex() != index) continue;
            return true;
        }
        return false;
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public ScrollBar getHBar() {
        if (this.getFlow() != null) {
            return this.getFlow().getHorizontalBar();
        }
        return null;
    }

    public ScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    public void resizeRowsToFitContent() {
        Grid grid = this.spreadsheetView.getGrid();
        int maxRows = this.handle.getView().getGrid().getRowCount();
        for (int row = 0; row < maxRows; ++row) {
            if (!grid.isRowResizable(row)) continue;
            this.resizeRowToFitContent(row);
        }
    }

    public void resizeRowToFitContent(int row) {
        Node n;
        if (((TableView)this.getSkinnable()).getColumns().isEmpty()) {
            return;
        }
        TableColumn col = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(0);
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        if (!this.spreadsheetView.getGrid().isRowResizable(row)) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        CellView cell = (CellView)((Object)cellFactory.call((Object)col));
        if (cell == null) {
            return;
        }
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 5.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedTopInset() + r.snappedBottomInset();
        }
        double maxHeight = 0.0;
        this.getChildren().add((Object)cell);
        for (TableColumn column : ((TableView)this.getSkinnable()).getColumns()) {
            cell.updateTableColumn(column);
            cell.updateTableView(this.handle.getGridView());
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            cell.setWrapText(true);
            cell.impl_processCSS(false);
            maxHeight = Math.max(maxHeight, cell.prefHeight(column.getWidth()));
        }
        this.getChildren().remove((Object)cell);
        this.rowHeightMap.put((Object)row, (Object)(maxHeight + padding));
        Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(row, maxHeight + padding));
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToMaximum() {
        this.resizeRowsToFitContent();
        Grid grid = this.spreadsheetView.getGrid();
        double maxHeight = 0.0;
        Iterator iterator = this.rowHeightMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            maxHeight = Math.max(maxHeight, (Double)this.rowHeightMap.get((Object)key));
        }
        this.rowHeightMap.clear();
        int maxRows = this.handle.getView().getGrid().getRowCount();
        for (int row = 0; row < maxRows; ++row) {
            if (!grid.isRowResizable(row)) continue;
            Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(row, maxHeight));
            this.rowHeightMap.put((Object)row, (Object)maxHeight);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToDefault() {
        this.rowHeightMap.clear();
        Grid grid = this.spreadsheetView.getGrid();
        for (GridRow row : this.getFlow().getCells()) {
            if (!grid.isRowResizable(row.getIndex())) continue;
            double newHeight = row.computePrefHeight(-1.0);
            if (row.getPrefHeight() == newHeight) continue;
            row.setRowHeight(newHeight);
            row.requestLayout();
        }
        this.getFlow().layoutChildren();
        for (GridRow row : this.getFlow().getCells()) {
            double height = this.getRowHeight(row.getIndex());
            if (row.getHeight() == height || !grid.isRowResizable(row.getIndex())) continue;
            row.setRowHeight(height);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeColumnToFitContent(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, int maxRows) {
        Node n;
        TableColumn<ObservableList<SpreadsheetCell>, ?> col = tc;
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TableCell cell = (TableCell)cellFactory.call(col);
        if (cell == null) {
            return;
        }
        int indexColumn = this.handle.getGridView().getColumns().indexOf(tc);
        if (maxRows == 30 && this.handle.isColumnWidthSet(indexColumn)) {
            return;
        }
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        ObservableList<ObservableList<SpreadsheetCell>> gridRows = this.spreadsheetView.getGrid().getRows();
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows == 30 ? 100 : maxRows);
        double maxWidth = 0.0;
        boolean datePresent = false;
        cell.updateTableColumn(col);
        cell.updateTableView((TableView)this.handle.getGridView());
        if (cell.getSkin() == null) {
            cell.setSkin((Skin)new CellViewSkin((TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell>)cell));
        }
        for (int row = 0; row < rows; ++row) {
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add((Object)cell);
            if (((SpreadsheetCell)cell.getItem()).getItem() instanceof LocalDate) {
                datePresent = true;
            }
            cell.impl_processCSS(false);
            double width = cell.prefWidth(-1.0);
            SpreadsheetCell spc = (SpreadsheetCell)((ObservableList)gridRows.get(row)).get(indexColumn);
            if (spc.getColumnSpan() > 1) {
                for (int i = spc.getColumn(); i < spc.getColumn() + spc.getColumnSpan(); ++i) {
                    if (i == indexColumn) continue;
                    width -= ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(i)).getWidth();
                }
            }
            maxWidth = Math.max(maxWidth, width);
            this.getChildren().remove((Object)cell);
        }
        cell.updateIndex(-1);
        double widthMax = maxWidth + padding;
        if (this.handle.getGridView().getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            widthMax = Math.max(widthMax, col.getWidth());
        }
        if (datePresent && widthMax < DATE_CELL_MIN_WIDTH) {
            widthMax = DATE_CELL_MIN_WIDTH;
        }
        widthMax = this.snapSize(widthMax);
        if (col.getPrefWidth() == widthMax && col.getWidth() != widthMax) {
            col.impl_setWidth(widthMax);
        } else {
            col.setPrefWidth(widthMax);
        }
        this.rectangleSelection.updateRectangle();
    }

    protected final void init() {
        this.rectangleSelection = new RectangleSelection(this, (TableViewSpanSelectionModel)this.handle.getGridView().getSelectionModel());
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        this.verticalHeader = new VerticalHeader(this.handle);
        this.getChildren().add((Object)this.verticalHeader);
        ((HorizontalHeader)this.getTableHeaderRow()).init();
        this.verticalHeader.init(this, (HorizontalHeader)this.getTableHeaderRow());
        this.horizontalPickers = new HorizontalPicker((HorizontalHeader)this.getTableHeaderRow(), this.spreadsheetView);
        this.getChildren().add((Object)this.horizontalPickers);
        this.getFlow().init(this.spreadsheetView);
        ((GridViewBehavior)this.getBehavior()).setGridViewSkin(this);
    }

    protected final ObservableSet<Integer> getCurrentlyFixedRow() {
        return this.currentlyFixedRow;
    }

    public void resize(TableColumnBase<?, ?> tc, int maxRows) {
        if (tc.isResizable()) {
            int columnIndex = this.getColumns().indexOf(tc);
            TableColumn tableColumn = (TableColumn)this.getColumns().get(columnIndex);
            this.resizeColumnToFitContent(tableColumn, maxRows);
            Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.ColumnWidthEvent(columnIndex, tableColumn.getWidth()));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double horizontalPickerHeight;
        if (this.spreadsheetView == null) {
            return;
        }
        double verticalHeaderWidth = this.verticalHeader.computeHeaderWidth();
        double d = horizontalPickerHeight = this.spreadsheetView.getColumnPickers().isEmpty() ? 0.0 : 16.0;
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            x += verticalHeaderWidth;
            w -= verticalHeaderWidth;
        } else {
            x = 0.0;
        }
        super.layoutChildren(x, y += horizontalPickerHeight, w, h - horizontalPickerHeight);
        double baselineOffset = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double tableHeaderRowHeight = 0.0;
        if (!this.spreadsheetView.getColumnPickers().isEmpty()) {
            this.layoutInArea((Node)this.horizontalPickers, x, y - 16.0, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            tableHeaderRowHeight = this.getTableHeaderRow().prefHeight(-1.0);
            this.layoutInArea((Node)this.getTableHeaderRow(), x, y, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
            y += tableHeaderRowHeight;
        }
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            this.layoutInArea((Node)this.verticalHeader, x - verticalHeaderWidth, y - tableHeaderRowHeight, w, h, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
    }

    protected void onFocusPreviousCell() {
        this.focusScroll();
    }

    protected void onFocusNextCell() {
        this.focusScroll();
    }

    void focusScroll() {
        TableFocusModel<ObservableList<SpreadsheetCell>, TableColumn<ObservableList<SpreadsheetCell>, ?>> fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.spreadsheetView.getFixedRows().size())).getIndex() > row && !this.spreadsheetView.getFixedRows().contains((Object)row)) {
            this.flow.scrollTo(row);
        } else {
            this.flow.show(row);
        }
        this.scrollHorizontally();
    }

    protected void onSelectPreviousCell() {
        super.onSelectPreviousCell();
        this.scrollHorizontally();
    }

    protected void onSelectNextCell() {
        super.onSelectNextCell();
        this.scrollHorizontally();
    }

    protected VirtualFlow<TableRow<ObservableList<SpreadsheetCell>>> createVirtualFlow() {
        return new GridVirtualFlow<TableRow<ObservableList<SpreadsheetCell>>>(this);
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new HorizontalHeader(this);
    }

    protected HorizontalHeader getHorizontalHeader() {
        return (HorizontalHeader)this.getTableHeaderRow();
    }

    BooleanProperty getTableMenuButtonVisibleProperty() {
        return this.tableMenuButtonVisibleProperty();
    }

    public void scrollHorizontally() {
        super.scrollHorizontally();
    }

    protected void scrollHorizontally(TableColumn<ObservableList<SpreadsheetCell>, ?> col) {
        if (col == null || !col.isVisible()) {
            return;
        }
        this.fixedColumnWidth = 0.0;
        double pos = this.getFlow().getHorizontalBar().getValue();
        int index = this.getColumns().indexOf(col);
        double start = 0.0;
        for (int i = 0; i < index; ++i) {
            SpreadsheetColumn column = (SpreadsheetColumn)this.spreadsheetView.getColumns().get(i);
            if (column.isFixed()) {
                this.fixedColumnWidth += column.getWidth();
            }
            start += column.getWidth();
        }
        double end = start + col.getWidth();
        double headerWidth = this.handle.getView().getWidth() - this.snappedLeftInset() - this.snappedRightInset() - this.verticalHeader.getVerticalHeaderWidth();
        double max = this.getFlow().getHorizontalBar().getMax();
        if (start < pos + this.fixedColumnWidth && start >= 0.0 && start >= this.fixedColumnWidth) {
            double newPos = start - this.fixedColumnWidth < 0.0 ? start : start - this.fixedColumnWidth;
            this.getFlow().getHorizontalBar().setValue(newPos);
        } else if (start > pos + headerWidth) {
            double delta = start < 0.0 || end > headerWidth ? start - pos - this.fixedColumnWidth : 0.0;
            double newPos = pos + delta > max ? max : pos + delta;
            this.getFlow().getHorizontalBar().setValue(newPos);
        }
    }

    private void verticalScroll() {
        this.verticalHeader.requestLayout();
    }

    GridVirtualFlow<?> getFlow() {
        return (GridVirtualFlow)this.flow;
    }

    private BitSet initRowToLayoutBitSet() {
        Grid grid = this.handle.getView().getGrid();
        BitSet bitSet = new BitSet(grid.getRowCount());
        block0: for (int row = 0; row < grid.getRowCount(); ++row) {
            if (this.spreadsheetView.getFixedRows().contains((Object)row)) {
                bitSet.set(row);
                continue;
            }
            List myRow = (List)grid.getRows().get(row);
            for (SpreadsheetCell cell : myRow) {
                if (cell.getRowSpan() <= 1) continue;
                bitSet.set(row);
                continue block0;
            }
        }
        return bitSet;
    }

    public void computeFixedRowHeight() {
        this.fixedRowHeight = 0.0;
        Iterator iterator = this.getCurrentlyFixedRow().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.fixedRowHeight += this.getRowHeight(i);
        }
    }

    protected TableSelectionModel<ObservableList<SpreadsheetCell>> getSelectionModel() {
        return ((TableView)this.getSkinnable()).getSelectionModel();
    }

    protected TableFocusModel<ObservableList<SpreadsheetCell>, TableColumn<ObservableList<SpreadsheetCell>, ?>> getFocusModel() {
        return ((TableView)this.getSkinnable()).getFocusModel();
    }

    protected TablePositionBase<? extends TableColumn<ObservableList<SpreadsheetCell>, ?>> getFocusedCell() {
        return ((TableView)this.getSkinnable()).getFocusModel().getFocusedCell();
    }

    protected ObservableList<? extends TableColumn<ObservableList<SpreadsheetCell>, ?>> getVisibleLeafColumns() {
        return ((TableView)this.getSkinnable()).getVisibleLeafColumns();
    }

    protected int getVisibleLeafIndex(TableColumn<ObservableList<SpreadsheetCell>, ?> tc) {
        return ((TableView)this.getSkinnable()).getVisibleLeafIndex(tc);
    }

    protected TableColumn<ObservableList<SpreadsheetCell>, ?> getVisibleLeafColumn(int col) {
        return ((TableView)this.getSkinnable()).getVisibleLeafColumn(col);
    }

    protected ObservableList<TableColumn<ObservableList<SpreadsheetCell>, ?>> getColumns() {
        return ((TableView)this.getSkinnable()).getColumns();
    }

    protected ObservableList<TableColumn<ObservableList<SpreadsheetCell>, ?>> getSortOrder() {
        return ((TableView)this.getSkinnable()).getSortOrder();
    }

    protected ObjectProperty<ObservableList<ObservableList<SpreadsheetCell>>> itemsProperty() {
        return ((TableView)this.getSkinnable()).itemsProperty();
    }

    protected ObjectProperty<Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>> rowFactoryProperty() {
        return ((TableView)this.getSkinnable()).rowFactoryProperty();
    }

    protected ObjectProperty<Node> placeholderProperty() {
        return ((TableView)this.getSkinnable()).placeholderProperty();
    }

    protected BooleanProperty tableMenuButtonVisibleProperty() {
        return ((TableView)this.getSkinnable()).tableMenuButtonVisibleProperty();
    }

    protected ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty() {
        return ((TableView)this.getSkinnable()).columnResizePolicyProperty();
    }

    protected boolean resizeColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, double delta) {
        this.getHorizontalHeader().getRootHeader().lastColumnResized = this.getColumns().indexOf(tc);
        boolean returnedValue = ((TableView)this.getSkinnable()).resizeColumn(tc, delta);
        if (returnedValue) {
            Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.ColumnWidthEvent(this.getColumns().indexOf(tc), tc.getWidth()));
        }
        return returnedValue;
    }

    protected void edit(int index, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        ((TableView)this.getSkinnable()).edit(index, column);
    }

    public TableRow<ObservableList<SpreadsheetCell>> createCell() {
        TableRow cell = ((TableView)this.getSkinnable()).getRowFactory() != null ? (TableRow)((TableView)this.getSkinnable()).getRowFactory().call((Object)this.getSkinnable()) : new TableRow();
        cell.updateTableView((TableView)this.getSkinnable());
        return cell;
    }

    public int getItemCount() {
        return ((TableView)this.getSkinnable()).getItems() == null ? 0 : ((TableView)this.getSkinnable()).getItems().size();
    }

    public void setHbarValue(double value) {
        this.setHbarValue(value, 0);
    }

    public void setHbarValue(double value, int count) {
        if (count > 5) {
            return;
        }
        int newCount = count + 1;
        if (this.flow.getScene() == null) {
            Platform.runLater(() -> this.setHbarValue(value, newCount));
            return;
        }
        this.getHBar().setValue(value);
    }

    static {
        DATE_CELL_MIN_WIDTH = 200.0 - Screen.getPrimary().getDpi();
        double cell_size = 24.0;
        try {
            Class<CellSkinBase> clazz = CellSkinBase.class;
            Field f = clazz.getDeclaredField("DEFAULT_CELL_SIZE");
            f.setAccessible(true);
            cell_size = f.getDouble(null);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        DEFAULT_CELL_HEIGHT = cell_size;
    }
}

