/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.util;

import com.flexganttfx.model.Activity;
import impl.com.flexganttfx.skin.util.Column;
import impl.com.flexganttfx.skin.util.Placement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class Cluster<A extends Activity> {
    private List<A> activities;
    private Instant startTime;
    private Instant endTime;
    private List<Column<A>> columns;

    public int getColumnCount() {
        if (this.columns == null || this.columns.isEmpty()) {
            return -1;
        }
        return this.columns.size();
    }

    public void add(A activity) {
        if (this.activities == null) {
            this.activities = new ArrayList<A>();
        }
        this.activities.add(activity);
        Instant activityStartTime = activity.getStartTime();
        Instant activityEndTime = activity.getEndTime();
        if (this.startTime == null || activityStartTime.isBefore(this.startTime)) {
            this.startTime = activityStartTime;
        }
        if (this.endTime == null || activityEndTime.isAfter(this.endTime)) {
            this.endTime = activityEndTime;
        }
    }

    public List<A> getActivities() {
        return this.activities;
    }

    public boolean intersects(A activity) {
        if (this.startTime == null) {
            return true;
        }
        Instant activityStartTime = activity.getStartTime();
        Instant activityEndTime = activity.getEndTime();
        return activityStartTime.isBefore(this.endTime) && activityEndTime.isAfter(this.startTime);
    }

    public Map<A, Placement<A>> resolve(Predicate<A> filter) {
        Column<Activity> column;
        if (this.activities == null || this.activities.isEmpty()) {
            return Collections.emptyMap();
        }
        this.columns = new ArrayList<Column<A>>();
        this.columns.add(new Column());
        for (Activity activity : this.activities) {
            boolean added = false;
            for (Column<Activity> column2 : this.columns) {
                if (!column2.hasRoomFor(activity, filter)) continue;
                column2.add(activity);
                added = true;
                break;
            }
            if (added) continue;
            column = new Column<Activity>();
            this.columns.add(column);
            column.add(activity);
        }
        HashMap<Activity, Placement<Activity>> placements = new HashMap<Activity, Placement<Activity>>();
        int colCount = this.columns.size();
        for (int col = 0; col < this.columns.size(); ++col) {
            column = this.columns.get(col);
            for (Activity activity : column.getActivities()) {
                placements.put(activity, new Placement<Activity>(activity, col, colCount));
            }
        }
        return placements;
    }

    public List<Column<A>> getColumns() {
        return this.columns;
    }
}

