/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.treetable;

import com.flexganttfx.model.Row;
import java.util.ArrayList;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;

public final class GanttChartTreeItem<R extends Row<?, ?, ?>>
extends TreeItem<R> {
    private final ObjectProperty<Predicate> filter = new SimpleObjectProperty((Object)this, "filter", row -> true);
    private final InvalidationListener updateChildrenListener = it -> this.updateChildren();
    private final WeakInvalidationListener weakUpdateChildrenListener = new WeakInvalidationListener(this.updateChildrenListener);

    public GanttChartTreeItem(R row2, Node graphic) {
        super(row2, graphic);
        this.init();
    }

    public GanttChartTreeItem(R row2) {
        super(row2);
        this.init();
    }

    public GanttChartTreeItem() {
        this.init();
    }

    public final ObjectProperty<Predicate> filterProperty() {
        return this.filter;
    }

    private Predicate getFilter() {
        return (Predicate)this.filter.get();
    }

    public boolean isLeaf() {
        return ((Row)this.getValue()).isLeaf();
    }

    private void init() {
        R row = this.getRow();
        Bindings.bindBidirectional((Property)this.expandedProperty(), (Property)((Row)row).expandedProperty());
        ObservableList children = ((Row)row).getChildren();
        children.addListener((InvalidationListener)this.weakUpdateChildrenListener);
        this.filterProperty().addListener((InvalidationListener)this.weakUpdateChildrenListener);
        this.buildChildren(this);
    }

    private void updateChildren() {
        this.buildChildren(this);
    }

    private void buildChildren(GanttChartTreeItem<R> item) {
        R row = item.getRow();
        Predicate filter = this.getFilter();
        ArrayList<GanttChartTreeItem<Row>> newChildren = new ArrayList<GanttChartTreeItem<Row>>();
        for (Row child : ((Row)row).getChildren()) {
            if (filter != null && !filter.test(child) && !child.hasChildren(filter)) continue;
            GanttChartTreeItem<Row> childItem = new GanttChartTreeItem<Row>(child);
            newChildren.add(childItem);
        }
        newChildren.forEach(this::buildChildren);
        item.getChildren().setAll(newChildren);
    }

    public final R getRow() {
        return (R)((Row)this.getValue());
    }

    public String getLevelNumber() {
        GanttChartTreeItem parent = (GanttChartTreeItem)this.getParent();
        if (parent != null) {
            String parentLevelNumber = parent.getLevelNumber();
            if (parentLevelNumber != null) {
                return parentLevelNumber + "." + (parent.getChildren().indexOf((Object)this) + 1);
            }
            return Integer.toString(parent.getChildren().indexOf((Object)this) + 1);
        }
        return null;
    }
}

