/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.timeline;

import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.timeline.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class TimelineSkin
extends SkinBase<Timeline> {
    private final Dateline dateline;
    private final Eventline eventline;
    private final VBox box;

    public TimelineSkin(Timeline timeline) {
        super((Control)timeline);
        this.dateline = timeline.getDateline();
        this.eventline = timeline.getEventline();
        EventHandler arrowKeysHandler = event -> {
            switch (event.getCode()) {
                case RIGHT: {
                    if (event.isShiftDown()) {
                        ((Timeline)this.getSkinnable()).scrollRightFast();
                    } else {
                        ((Timeline)this.getSkinnable()).scrollRight();
                    }
                    event.consume();
                    break;
                }
                case LEFT: {
                    if (event.isShiftDown()) {
                        ((Timeline)this.getSkinnable()).scrollLeftFast();
                    } else {
                        ((Timeline)this.getSkinnable()).scrollLeft();
                    }
                    event.consume();
                    break;
                }
            }
        };
        EventHandler plusMinusKeyHandler = event -> {
            switch (event.getCharacter()) {
                case "-": {
                    timeline.zoomOut();
                    break;
                }
                case "+": {
                    timeline.zoomIn();
                    break;
                }
            }
        };
        timeline.addEventHandler(KeyEvent.KEY_PRESSED, arrowKeysHandler);
        timeline.addEventHandler(KeyEvent.KEY_TYPED, plusMinusKeyHandler);
        VBox.setVgrow((Node)this.dateline, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.eventline, (Priority)Priority.NEVER);
        this.box = new VBox();
        this.box.getStyleClass().add((Object)"dateline-eventline-wrapper");
        this.box.setFillWidth(true);
        this.getChildren().add((Object)this.box);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)timeline.widthProperty());
        clip.heightProperty().bind((ObservableValue)timeline.heightProperty());
        timeline.setClip((Node)clip);
        this.dateline.visibleProperty().addListener(it -> this.updateVisibilities());
        this.eventline.visibleProperty().addListener(it -> this.updateVisibilities());
        this.updateVisibilities();
    }

    private void updateVisibilities() {
        this.box.getChildren().clear();
        if (this.dateline.isVisible()) {
            this.box.getChildren().add((Object)this.dateline);
        }
        if (this.eventline.isVisible()) {
            this.box.getChildren().add((Object)this.eventline);
        }
    }

    public Timeline getTimeline() {
        return (Timeline)this.getSkinnable();
    }
}

