/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.timeline;

import com.flexganttfx.model.Row;
import com.flexganttfx.model.timeline.TimelineModel;
import com.flexganttfx.model.util.TimeInterval;
import com.flexganttfx.view.graphics.SingleRowGraphics;
import com.flexganttfx.view.timeline.Dateline;
import com.flexganttfx.view.timeline.Eventline;
import com.flexganttfx.view.timeline.Timeline;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.zone.ZoneOffsetTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.shape.Rectangle;

public class EventlineSkin
extends SkinBase<Eventline> {
    private final Label timeCursor = new Label();
    private final Label markedStartTime;
    private final Label markedEndTime;
    private final Label dst;
    private final SingleRowGraphics<Row<?, ?, ?>> graphics;
    private DateTimeFormatter formatter;

    public EventlineSkin(Eventline eventline) {
        super((Control)eventline);
        this.timeCursor.setMouseTransparent(true);
        this.timeCursor.setManaged(false);
        this.timeCursor.getStyleClass().add((Object)"time-cursor");
        this.timeCursor.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)eventline.showTimeCursorProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline.cursorTimeProperty())));
        this.markedStartTime = new Label();
        this.markedStartTime.setMouseTransparent(true);
        this.markedStartTime.setManaged(false);
        this.markedStartTime.getStyleClass().addAll((Object[])new String[]{"marked-time", "marked-time-start"});
        this.markedStartTime.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)eventline.showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline.markedTimeIntervalProperty())));
        this.markedEndTime = new Label();
        this.markedEndTime.setMouseTransparent(true);
        this.markedEndTime.setManaged(false);
        this.markedEndTime.getStyleClass().addAll((Object[])new String[]{"marked-time", "marked-time-end"});
        this.markedEndTime.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)eventline.showMarkedTimeIntervalProperty(), (ObservableBooleanValue)Bindings.isNotNull(eventline.markedTimeIntervalProperty())));
        this.dst = new Label("DST");
        this.dst.setManaged(false);
        this.dst.getStyleClass().addAll((Object[])new String[]{"dst-marker"});
        this.dst.setTooltip(new Tooltip("Daylight Savings Time Change"));
        ((Eventline)this.getSkinnable()).showDSTMarkerProperty().addListener(it -> eventline.requestLayout());
        this.graphics = eventline.getGraphics();
        this.graphics.getStyleClass().add((Object)"frozen-row");
        this.graphics.setContextMenu(null);
        this.graphics.setContextMenuCallback(null);
        this.graphics.setTimeline(eventline.getTimeline());
        this.graphics.setShowGridLineLayer(false);
        this.graphics.getBackgroundSystemLayers().clear();
        this.graphics.getForegroundSystemLayers().clear();
        Rectangle eventlineClip = new Rectangle();
        eventlineClip.widthProperty().bind((ObservableValue)((Eventline)this.getSkinnable()).widthProperty());
        eventlineClip.heightProperty().bind((ObservableValue)((Eventline)this.getSkinnable()).heightProperty());
        this.graphics.setClip((Node)eventlineClip);
        eventline.frozenRowProperty().addListener(it -> this.updateRowList());
        this.updateRowList();
        this.getChildren().setAll((Object[])new Node[]{this.graphics, this.dst, this.markedStartTime, this.markedEndTime, this.timeCursor});
        this.registerListeners();
        this.formatter = ((Eventline)this.getSkinnable()).getDateTimeFormatter();
        ((Eventline)this.getSkinnable()).dateTimeFormatterProperty().addListener(observable -> {
            this.formatter = ((Eventline)this.getSkinnable()).getDateTimeFormatter();
            ((Eventline)this.getSkinnable()).requestLayout();
        });
    }

    private void updateRowList() {
        ((Eventline)this.getSkinnable()).getGraphics().getRows().setAll((Object[])new Row[]{((Eventline)this.getSkinnable()).getFrozenRow()});
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        TimeInterval markedTime;
        this.graphics.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        Timeline timeline = ((Eventline)this.getSkinnable()).getTimeline();
        Instant time = ((Eventline)this.getSkinnable()).getCursorTime();
        if (time != null) {
            double cursorLocation = ((Eventline)this.getSkinnable()).getCursorLocation();
            Dateline dateline = timeline.getDateline();
            ZoneId zoneId = dateline.getZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(time, zoneId);
            String text = this.formatter.format(zonedDateTime);
            this.timeCursor.setText(text);
            this.timeCursor.resizeRelocate(cursorLocation, contentY, this.timeCursor.prefWidth(-1.0), contentHeight);
        }
        if ((markedTime = ((Eventline)this.getSkinnable()).getMarkedTimeInterval()) != null) {
            Instant markedStart = markedTime.getStartTime();
            Instant markedEnd = markedTime.getEndTime();
            Dateline dateline = timeline.getDateline();
            ZoneId zoneId = dateline.getZoneId();
            ZonedDateTime zonedStartTime = ZonedDateTime.ofInstant(markedStart, zoneId);
            ZonedDateTime zonedEndTime = ZonedDateTime.ofInstant(markedEnd, zoneId);
            this.markedStartTime.setText(this.formatter.format(zonedStartTime));
            this.markedEndTime.setText(this.formatter.format(zonedEndTime));
            TimelineModel<?> timelineModel = timeline.getModel();
            double xStart = timelineModel.calculateLocationForTime(markedStart);
            double xEnd = timelineModel.calculateLocationForTime(markedEnd);
            this.markedStartTime.resizeRelocate(xStart - this.markedStartTime.prefWidth(-1.0), contentY, this.markedStartTime.prefWidth(-1.0), contentHeight);
            this.markedEndTime.resizeRelocate(xEnd, contentY, this.markedEndTime.prefWidth(-1.0), contentHeight);
        }
        Dateline dateline = timeline.getDateline();
        TemporalUnit unit = dateline.getPrimaryTemporalUnit();
        boolean showDST = false;
        if (unit != null && (unit.equals(ChronoUnit.HOURS) || unit.equals(ChronoUnit.MINUTES))) {
            Instant startTime = timeline.getVisibleStartTime();
            ZoneId zoneId = dateline.getZoneId();
            ZoneOffsetTransition transition = zoneId.getRules().nextTransition(startTime);
            if (transition != null) {
                double dstWidth = this.dst.prefWidth(-1.0);
                double location = this.snapPosition(timeline.getModel().calculateLocationForTime(transition.getInstant())) - dstWidth / 2.0;
                if (location < dateline.getWidth()) {
                    this.dst.resizeRelocate(location, contentY, dstWidth, contentHeight);
                    showDST = true;
                }
            }
        }
        this.dst.setVisible(showDST && ((Eventline)this.getSkinnable()).isShowDSTMarker());
    }

    private void registerListeners() {
        ChangeListener instantChangedListener = (value, oldStartTime, newStartTime) -> ((Eventline)this.getSkinnable()).requestLayout();
        Timeline timeline = ((Eventline)this.getSkinnable()).getTimeline();
        timeline.getModel().startTimeProperty().addListener(instantChangedListener);
        ChangeListener numberChangedListener = (value, oldWidth, newWidth) -> ((Eventline)this.getSkinnable()).requestLayout();
        ((Eventline)this.getSkinnable()).cursorLocationProperty().addListener(numberChangedListener);
        ((Eventline)this.getSkinnable()).markedTimeIntervalProperty().addListener(observable -> ((Eventline)this.getSkinnable()).requestLayout());
        timeline.getModel().millisPerPixelProperty().addListener(numberChangedListener);
        timeline.modelProperty().addListener((ChangeListener)new WeakChangeListener((value, oldModel, newModel) -> {
            if (oldModel != null) {
                oldModel.startTimeProperty().removeListener(instantChangedListener);
                oldModel.millisPerPixelProperty().removeListener(numberChangedListener);
            }
            if (newModel != null) {
                newModel.startTimeProperty().addListener(instantChangedListener);
                newModel.millisPerPixelProperty().addListener(numberChangedListener);
            }
            ((Eventline)this.getSkinnable()).requestLayout();
        }));
    }
}

