/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.VBoxGraphics;
import impl.com.flexganttfx.skin.graphics.GraphicsBaseSkin;
import impl.com.flexganttfx.skin.graphics.RowCanvas;
import impl.com.flexganttfx.skin.graphics.RowPane;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class VBoxGraphicsSkin<R extends Row<?, ?, ?>>
extends GraphicsBaseSkin<VBoxGraphics<R>, R> {
    private VBox vbox;

    public VBoxGraphicsSkin(VBoxGraphics<R> graphics) {
        super(graphics);
        graphics.getRows().addListener(evt -> this.updateBox());
        graphics.priorityCallbackProperty().addListener(evt -> this.updateBox());
        this.updateBox();
    }

    private void updateBox() {
        this.vbox.getChildren().clear();
        VBoxGraphics graphics = (VBoxGraphics)this.getSkinnable();
        graphics.getRowPanes().clear();
        Callback priorityCallback = graphics.getPriorityCallback();
        for (Row row : graphics.getRows()) {
            RowPane rowPane = new RowPane(graphics);
            rowPane.getStyleClass().add((Object)"vbox-row-pane");
            if (priorityCallback != null) {
                Priority priority = (Priority)priorityCallback.call((Object)row);
                VBox.setVgrow(rowPane, (Priority)priority);
            }
            rowPane.setRow(row);
            this.vbox.getChildren().add(rowPane);
            graphics.getRowPanes().add(rowPane);
        }
    }

    @Override
    protected Region createRowPaneRegion() {
        VBoxGraphics graphics = (VBoxGraphics)this.getSkinnable();
        this.vbox = graphics.getVBox();
        this.vbox.setFillWidth(true);
        return this.vbox;
    }

    @Override
    protected RowPane<R> getRowPaneAt(double y) {
        for (Node node : this.vbox.getChildren()) {
            if (!(node instanceof RowPane)) continue;
            Point2D point = this.vbox.localToScene(0.0, y);
            Bounds sceneNodeBounds = node.localToScene(node.getBoundsInLocal());
            if (!sceneNodeBounds.contains(point)) continue;
            return (RowPane)node;
        }
        return null;
    }

    @Override
    protected boolean isRowAboveViewport(R row) {
        return false;
    }

    @Override
    protected List<Row<?, ?, ?>> findLassoSelectedRows() {
        ArrayList rows = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds localLassoBounds = lasso.getBoundsInLocal();
        Bounds sceneLassoBounds = lasso.localToScene(localLassoBounds);
        this.vbox.getChildren().stream().filter(node -> node instanceof RowPane).forEach(node -> {
            RowPane pane;
            Object row;
            Bounds sceneNodeBounds = node.localToScene(node.getBoundsInLocal());
            if (sceneNodeBounds.intersects(sceneLassoBounds) && (row = (pane = (RowPane)((Object)node)).getRow()) != null) {
                rows.add((Row<?, ?, ?>)row);
            }
        });
        return rows;
    }

    @Override
    protected List<ActivityRef<?>> findLassoSelectedActivities() {
        ArrayList selection = new ArrayList();
        Rectangle lasso = this.getLasso();
        Bounds localLassoBounds = lasso.getBoundsInLocal();
        Bounds sceneLassoBounds = lasso.localToScene(localLassoBounds);
        for (Node node : this.vbox.getChildren()) {
            Bounds sceneNodeBounds;
            if (!(node instanceof RowPane) || !(sceneNodeBounds = node.localToScene(node.getBoundsInLocal())).intersects(sceneLassoBounds)) continue;
            RowPane rowPane = (RowPane)node;
            RowCanvas rowCanvas = rowPane.getCanvas();
            double x = localLassoBounds.getMinX();
            double y = Math.max(0.0, sceneLassoBounds.getMinY() - sceneNodeBounds.getMinY());
            double w = localLassoBounds.getWidth();
            double h = localLassoBounds.getHeight();
            if (sceneNodeBounds.getMinY() > sceneLassoBounds.getMinY()) {
                y -= sceneNodeBounds.getMinY() - sceneLassoBounds.getMinY();
            }
            List<ActivityBounds> activityBounds = rowCanvas.getActivityBounds(x, y, w, h);
            List refs = activityBounds.stream().map(ActivityBounds::getActivityRef).collect(Collectors.toList());
            selection.addAll(refs);
        }
        return selection;
    }
}

