/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.QuadCurveTo;

public class PathBuilder {
    private double offset = 8.0;
    private double gap = 4.0;
    private double curve = 6.0;

    private TargetLocation calculateTargetLocation(double sx, double sy, double tx, double ty) {
        double xDelta = tx - sx;
        if (sy < ty) {
            if (xDelta > 0.0) {
                return TargetLocation.BELOW_RIGHT;
            }
            if (xDelta < 0.0) {
                return TargetLocation.BELOW_LEFT;
            }
            return TargetLocation.BELOW;
        }
        if (sy > ty) {
            if (xDelta > 0.0) {
                return TargetLocation.ABOVE_RIGHT;
            }
            if (xDelta < 0.0) {
                return TargetLocation.ABOVE_LEFT;
            }
            return TargetLocation.ABOVE;
        }
        if (xDelta > 0.0) {
            return TargetLocation.RIGHT;
        }
        if (xDelta < 0.0) {
            return TargetLocation.LEFT;
        }
        return TargetLocation.SAME_LOCATION;
    }

    public PathBuilderResult buildPathStartToStart(Rectangle2D sourceRect, Rectangle2D targetRect) {
        TargetLocation targetLocationOriginalLocations;
        double sx = sourceRect.getMinX();
        double sx1 = sx - this.offset;
        double tx = targetRect.getMinX();
        double tx1 = tx - this.offset;
        double sy = sourceRect.getMinY() + sourceRect.getHeight() / 2.0;
        double ty = targetRect.getMinY() + targetRect.getHeight() / 2.0;
        Point2D startPoint = new Point2D(sx, sy);
        Point2D endPoint = new Point2D(tx, ty);
        Path path = new Path();
        boolean close = false;
        TargetLocation targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        if (sy == ty && (targetLocation.equals((Object)TargetLocation.RIGHT) || targetLocation.equals((Object)TargetLocation.LEFT)) && !targetLocation.equals((Object)(targetLocationOriginalLocations = this.calculateTargetLocation(sx, sy, tx, ty)))) {
            sx1 = sx;
            tx1 = tx;
            targetLocation = targetLocationOriginalLocations;
            close = true;
        }
        PathBuilderResult result = new PathBuilderResult(startPoint, endPoint, path, ArrowDirection.RIGHT, close);
        ObservableList pathElements = path.getElements();
        pathElements.add((Object)new MoveTo(sx, sy));
        switch (targetLocation) {
            case BELOW_RIGHT: 
            case BELOW: 
            case BELOW_LEFT: {
                double x = Math.min(sx1, tx1);
                pathElements.add((Object)new LineTo(x + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(x, sy, x, sy + this.curve));
                pathElements.add((Object)new LineTo(x, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(x, ty, x + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_RIGHT: 
            case ABOVE_LEFT: 
            case ABOVE: {
                double x = Math.min(sx1, tx1);
                pathElements.add((Object)new LineTo(x + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(x, sy, x, sy - this.curve));
                pathElements.add((Object)new LineTo(x, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(x, ty, x + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case RIGHT: {
                double my = sourceRect.getMinY() + sourceRect.getHeight() + this.gap;
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, my - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 + this.curve, my));
                pathElements.add((Object)new LineTo(tx1 - this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my - this.curve));
                pathElements.add((Object)new LineTo(tx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case LEFT: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, my + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 - this.curve, my));
                pathElements.add((Object)new LineTo(tx1 + this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
        }
        return result;
    }

    public PathBuilderResult buildPathEndToEnd(Rectangle2D sourceRect, Rectangle2D targetRect) {
        TargetLocation targetLocationOriginalLocations;
        double sx = sourceRect.getMinX() + sourceRect.getWidth();
        double sx1 = sx + this.offset;
        double tx = targetRect.getMinX() + targetRect.getWidth();
        double tx1 = tx + this.offset;
        double sy = sourceRect.getMinY() + sourceRect.getHeight() / 2.0;
        double ty = targetRect.getMinY() + targetRect.getHeight() / 2.0;
        Point2D startPoint = new Point2D(sx, sy);
        Point2D endPoint = new Point2D(tx, ty);
        Path path = new Path();
        TargetLocation targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        boolean close = false;
        if (sy == ty && (targetLocation.equals((Object)TargetLocation.RIGHT) || targetLocation.equals((Object)TargetLocation.LEFT)) && !targetLocation.equals((Object)(targetLocationOriginalLocations = this.calculateTargetLocation(sx, sy, tx, ty)))) {
            sx1 = sx;
            tx1 = tx;
            targetLocation = targetLocationOriginalLocations;
            close = true;
        }
        PathBuilderResult result = new PathBuilderResult(startPoint, endPoint, path, ArrowDirection.LEFT, close);
        ObservableList pathElements = path.getElements();
        pathElements.add((Object)new MoveTo(sx, sy));
        switch (targetLocation) {
            case BELOW_RIGHT: 
            case BELOW: 
            case BELOW_LEFT: {
                double x = Math.max(sx1, tx1);
                pathElements.add((Object)new LineTo(x - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(x, sy, x, sy + this.curve));
                pathElements.add((Object)new LineTo(x, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(x, ty, x - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_RIGHT: 
            case ABOVE_LEFT: 
            case ABOVE: {
                double x = Math.max(sx1, tx1);
                pathElements.add((Object)new LineTo(x - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(x, sy, x, sy - this.curve));
                pathElements.add((Object)new LineTo(x, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(x, ty, x - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case RIGHT: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, my + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 + this.curve, my));
                pathElements.add((Object)new LineTo(tx1 - this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case LEFT: {
                double my = sourceRect.getMinY() + sourceRect.getHeight() + this.gap;
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, my - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 - this.curve, my));
                pathElements.add((Object)new LineTo(tx1 + this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my - this.curve));
                pathElements.add((Object)new LineTo(tx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
        }
        return result;
    }

    public PathBuilderResult buildPathStartToEnd(Rectangle2D sourceRect, Rectangle2D targetRect) {
        TargetLocation targetLocationOriginalLocations;
        double sx = sourceRect.getMinX();
        double sx1 = sx - this.offset;
        double tx = targetRect.getMinX() + targetRect.getWidth();
        double tx1 = tx + this.offset;
        double sy = sourceRect.getMinY() + sourceRect.getHeight() / 2.0;
        double ty = targetRect.getMinY() + targetRect.getHeight() / 2.0;
        Point2D startPoint = new Point2D(sx, sy);
        Point2D endPoint = new Point2D(tx, ty);
        Path path = new Path();
        boolean close = false;
        TargetLocation targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        if (sy == ty && (targetLocation.equals((Object)TargetLocation.RIGHT) || targetLocation.equals((Object)TargetLocation.LEFT)) && !targetLocation.equals((Object)(targetLocationOriginalLocations = this.calculateTargetLocation(sx, sy, tx, ty)))) {
            sx1 = sx;
            tx1 = tx;
            targetLocation = targetLocationOriginalLocations;
            close = true;
        }
        PathBuilderResult result = new PathBuilderResult(startPoint, endPoint, path, ArrowDirection.LEFT, close);
        ObservableList pathElements = path.getElements();
        pathElements.add((Object)new MoveTo(sx, sy));
        switch (targetLocation) {
            case BELOW: 
            case BELOW_LEFT: {
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, ty, sx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case BELOW_RIGHT: {
                double my = sourceRect.getMinY() + sourceRect.getHeight() + this.gap;
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, my - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 + this.curve, my));
                pathElements.add((Object)new LineTo(tx1 - this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_RIGHT: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, my + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 + this.curve, my));
                pathElements.add((Object)new LineTo(tx1 - this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my - this.curve));
                pathElements.add((Object)new LineTo(tx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_LEFT: 
            case ABOVE: {
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, ty, sx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case RIGHT: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 + this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, my + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 + this.curve, my));
                pathElements.add((Object)new LineTo(tx1 - this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 - this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case LEFT: {
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
        }
        return result;
    }

    public PathBuilderResult buildPathEndToStart(Rectangle2D sourceRect, Rectangle2D targetRect) {
        TargetLocation targetLocationOriginalLocations;
        double sx = this.snapLocation(sourceRect.getMinX() + sourceRect.getWidth());
        double sx1 = this.snapLocation(sx + this.offset);
        double tx = this.snapLocation(targetRect.getMinX()) + 0.5;
        double tx1 = this.snapLocation(tx - this.offset);
        double sy = this.snapLocation(sourceRect.getMinY() + sourceRect.getHeight() / 2.0);
        double ty = this.snapLocation(targetRect.getMinY() + targetRect.getHeight() / 2.0);
        Point2D startPoint = new Point2D(sx, sy);
        Point2D endPoint = new Point2D(tx, ty);
        Path path = new Path();
        TargetLocation targetLocation = this.calculateTargetLocation(sx1, sy, tx1, ty);
        boolean close = false;
        if (sy == ty && (targetLocation.equals((Object)TargetLocation.RIGHT) || targetLocation.equals((Object)TargetLocation.LEFT)) && !targetLocation.equals((Object)(targetLocationOriginalLocations = this.calculateTargetLocation(sx, sy, tx, ty)))) {
            sx1 = sx;
            tx1 = tx;
            targetLocation = targetLocationOriginalLocations;
            close = true;
        }
        PathBuilderResult result = new PathBuilderResult(startPoint, endPoint, path, ArrowDirection.RIGHT, close);
        ObservableList pathElements = path.getElements();
        pathElements.add((Object)new MoveTo(sx, sy));
        switch (targetLocation) {
            case BELOW_RIGHT: {
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, ty, sx1 + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case BELOW: 
            case BELOW_LEFT: {
                double my = sourceRect.getMinY() + sourceRect.getHeight() + this.gap;
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy + this.curve));
                pathElements.add((Object)new LineTo(sx1, my - this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, my, sx1 - this.curve, my));
                pathElements.add((Object)new LineTo(tx1 + this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_RIGHT: {
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                pathElements.add((Object)new QuadCurveTo(sx1, sy, sx1, sy - this.curve));
                pathElements.add((Object)new LineTo(sx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(sx1, ty, sx1 + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case ABOVE_LEFT: 
            case ABOVE: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                double delta = (sy - my) / 2.0 + 1.0;
                pathElements.add((Object)new QuadCurveTo(sx1 - this.curve + delta, sy - delta, sx1 - this.curve, my));
                pathElements.add((Object)new LineTo(tx1 + this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my - this.curve));
                pathElements.add((Object)new LineTo(tx1, ty + this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 + this.curve, ty));
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case RIGHT: {
                pathElements.add((Object)new LineTo(tx, ty));
                break;
            }
            case LEFT: {
                double my = sourceRect.getMinY() - this.gap;
                pathElements.add((Object)new LineTo(sx1 - this.curve, sy));
                double delta = (sy - my) / 2.0 + 1.0;
                pathElements.add((Object)new QuadCurveTo(sx1 - this.curve + delta, sy - delta, sx1 - this.curve, my));
                pathElements.add((Object)new LineTo(tx1 + this.curve, my));
                pathElements.add((Object)new QuadCurveTo(tx1, my, tx1, my + this.curve));
                pathElements.add((Object)new LineTo(tx1, ty - this.curve));
                pathElements.add((Object)new QuadCurveTo(tx1, ty, tx1 + this.curve, ty));
                break;
            }
        }
        return result;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final void setOffset(double offset) {
        if (offset < 0.0) {
            throw new IllegalArgumentException("offset can not be negative");
        }
        if (this.curve > offset) {
            throw new IllegalArgumentException("curve can not be larger than the offset (requested offset = " + offset + ", current curve = " + this.curve);
        }
        this.offset = offset;
    }

    public final void setCurve(double curve) {
        if (curve < 0.0) {
            throw new IllegalArgumentException("curve can not be negative");
        }
        if (curve > this.offset) {
            throw new IllegalArgumentException("curve can not be larger than the offset (current offset = " + this.offset + ", requested curve = " + curve);
        }
        this.curve = curve;
    }

    public final double getCurve() {
        return this.curve;
    }

    public final double getGap() {
        return this.gap;
    }

    public final void setGap(double gap) {
        this.gap = gap;
    }

    private double snapLocation(double location) {
        return (double)((int)location) + 0.5;
    }

    public static enum ArrowDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static enum TargetLocation {
        BELOW_RIGHT,
        BELOW,
        BELOW_LEFT,
        ABOVE_RIGHT,
        ABOVE,
        ABOVE_LEFT,
        LEFT,
        RIGHT,
        SAME_LOCATION;

    }

    final class PathBuilderResult {
        private final Point2D start;
        private final Point2D end;
        private final Path path;
        private final boolean close;
        private final ArrowDirection arrowDirection;

        public PathBuilderResult(Point2D start, Point2D end, Path path, ArrowDirection arrowDirection, boolean close) {
            this.start = Objects.requireNonNull(start);
            this.end = Objects.requireNonNull(end);
            this.path = Objects.requireNonNull(path);
            this.arrowDirection = Objects.requireNonNull(arrowDirection);
            this.close = close;
        }

        public final Point2D getStart() {
            return this.start;
        }

        public final Point2D getEnd() {
            return this.end;
        }

        public final Path getPath() {
            return this.path;
        }

        public ArrowDirection getArrowDirection() {
            return this.arrowDirection;
        }

        public boolean isClose() {
            return this.close;
        }

        public String toString() {
            return "start = " + this.start.toString() + ", end = " + this.end.toString() + ", path = " + this.path.toString();
        }
    }
}

