/*
 * Decompiled with CFR 0.152.
 */
package impl.com.flexganttfx.skin.graphics;

import com.flexganttfx.model.ActivityRef;
import com.flexganttfx.model.Row;
import com.flexganttfx.view.graphics.ActivityBounds;
import com.flexganttfx.view.graphics.GraphicsBase;
import com.flexganttfx.view.graphics.renderer.ActivityRenderer;
import com.flexganttfx.view.timeline.Timeline;
import com.flexganttfx.view.util.Position;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.DragEvent;

public class DragCanvas<R extends Row<?, ?, ?>>
extends Canvas {
    private final GraphicsBase<R> graphics;
    private boolean includeSelectedActivitiesInDrag;
    private List<ActivityBounds> renderedBounds = new ArrayList<ActivityBounds>();

    public DragCanvas(GraphicsBase<R> graphics) {
        this.graphics = graphics;
        this.setMouseTransparent(true);
    }

    public boolean isResizable() {
        return true;
    }

    public double prefWidth(double height) {
        return this.getWidth();
    }

    public double prefHeight(double width) {
        return this.getHeight();
    }

    public void draw(GraphicsBase.DragAndDropInfo info) {
        this.renderedBounds.clear();
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (info != null) {
            ActivityBounds draggedBounds = info.getActivityBounds();
            this.draw(info, gc, draggedBounds, draggedBounds);
            if (this.includeSelectedActivitiesInDrag) {
                info.getSelectedActivities().forEach(activity -> this.draw(info, gc, draggedBounds, (ActivityBounds)((Object)activity)));
            }
        }
    }

    private void draw(GraphicsBase.DragAndDropInfo info, GraphicsContext gc, ActivityBounds draggedBounds, ActivityBounds bounds) {
        DragEvent evt = info.getDragEvent();
        ActivityRef<?> ref = bounds.getActivityRef();
        Object activity = ref.getActivity();
        ActivityRenderer<?> renderer = this.graphics.getActivityRenderer(activity.getClass(), bounds.getLayout().getClass());
        ActivityRef<?> draggedActivityRef = draggedBounds.getActivityRef();
        Object draggedActivity = draggedActivityRef.getActivity();
        Timeline timeline = this.graphics.getTimeline();
        Instant startTime = info.getDropInterval().getStartTime();
        if (!draggedBounds.equals((Object)bounds)) {
            Duration duration = Duration.between(draggedActivity.getStartTime(), activity.getStartTime());
            startTime = startTime.plus(duration);
        }
        double x = timeline.getModel().calculateLocationForTime(startTime);
        double y = evt.getSceneY() - this.localToScene(0.0, 0.0).getY() - info.getOffset().getY();
        if (!draggedBounds.equals((Object)bounds)) {
            y += bounds.getMinY() - draggedBounds.getMinY();
        }
        renderer.draw(ref, Position.ONLY, gc, x, y, bounds.getWidth(), bounds.getHeight(), false, false, false, false);
        this.renderedBounds.add(new ActivityBounds(ref, x, y, bounds.getWidth(), bounds.getHeight()));
    }

    protected final List<ActivityBounds> getRenderedBounds() {
        return this.renderedBounds;
    }

    public final void setIncludeSelectedActivitiesInDrag(boolean include) {
        this.includeSelectedActivitiesInDrag = include;
    }

    public final boolean isIncludeSelectedActivitiesInDrag() {
        return this.includeSelectedActivitiesInDrag;
    }
}

